/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureContext {
    private VirtualFile root;
    private VirtualFile parent;
    private VirtualFile file;
    private StructureMetaData metaData;
    private VFSStructuralDeployers deployers;
    private StructureContext parentContext;
    private boolean candidateAnnotationScanning;
    private Set<Object> callbacks;

    private static VirtualFile getRoot(StructureContext parentContext) {
        if (parentContext == null) {
            throw new IllegalArgumentException("Null parentContext");
        }
        return parentContext.getRoot();
    }

    public StructureContext(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers, StructureContext parentContext) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null structure metadata");
        }
        if (deployers == null) {
            throw new IllegalArgumentException("Null structural deployers");
        }
        this.root = root;
        this.parent = parent;
        this.file = file;
        this.metaData = metaData;
        this.deployers = deployers;
        this.parentContext = parentContext;
    }

    public StructureContext(VirtualFile root, StructureMetaData metaData, VFSStructuralDeployers deployers) {
        this(root, null, root, metaData, deployers, null);
    }

    public StructureContext(VirtualFile file, StructureMetaData metaData, StructureContext parentContext) {
        this(StructureContext.getRoot(parentContext), parentContext.getFile(), file, metaData, parentContext.getDeployers(), parentContext);
    }

    public String getName() {
        return this.file.getName();
    }

    public VirtualFile getRoot() {
        return this.root;
    }

    public VirtualFile getParent() {
        return this.parent;
    }

    public boolean isTopLevel() {
        return this.parent == null;
    }

    public VirtualFile getFile() {
        return this.file;
    }

    public StructureMetaData getMetaData() {
        return this.metaData;
    }

    public VFSStructuralDeployers getDeployers() {
        return this.deployers;
    }

    public StructureContext getParentContext() {
        return this.parentContext;
    }

    public boolean isCandidateAnnotationScanning() {
        return this.candidateAnnotationScanning;
    }

    public void setCandidateAnnotationScanning(boolean candidateAnnotationScanning) {
        this.candidateAnnotationScanning = candidateAnnotationScanning;
    }

    public <T> Set<T> getCallbacks(Class<T> callbackType) {
        if (callbackType == null) {
            throw new IllegalArgumentException("Null callback type");
        }
        if (this.callbacks == null || this.callbacks.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<T> set = new HashSet<T>();
        for (Object callback : this.callbacks) {
            if (!callbackType.isInstance(callback)) continue;
            set.add(callbackType.cast(callback));
        }
        return set;
    }

    public void addCallback(Object callback) {
        if (this.callbacks == null) {
            this.callbacks = new HashSet<Object>();
        }
        this.callbacks.add(callback);
    }

    public void setCallbacks(Set<Object> callbacks) {
        this.callbacks = callbacks;
    }

    public boolean determineChildStructure(VirtualFile child) throws DeploymentException {
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        return this.getDeployers().determineStructure(child, this);
    }

    public void addChild(ContextInfo child) {
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        this.getMetaData().addContext(child);
    }

    public void removeChild(ContextInfo child) {
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        this.getMetaData().removeContext(child);
    }
}

