/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.helpers;

import java.io.IOException;
import java.util.ArrayList;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
import org.jboss.deployers.vfs.spi.structure.StructureDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
import org.jboss.deployers.vfs.spi.structure.helpers.CandidateStructureVisitorFactory;
import org.jboss.deployers.vfs.spi.structure.helpers.DefaultCandidateStructureVisitorFactory;
import org.jboss.deployers.vfs.spi.structure.helpers.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;

public abstract class AbstractStructureDeployer
implements StructureDeployer {
    protected Logger log = Logger.getLogger(this.getClass());
    private int relativeOrder = Integer.MAX_VALUE;
    private CandidateStructureVisitorFactory candidateStructureVisitorFactory = DefaultCandidateStructureVisitorFactory.INSTANCE;
    private Integer contextInfoOrder;

    public static final String getRelativePath(VirtualFile parent, VirtualFile child) {
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        String childPath = child.getPathName();
        if (parent != null) {
            String parentPath = parent.getPathName();
            if (parentPath.length() == childPath.length()) {
                return "";
            }
            if (parentPath.length() < childPath.length()) {
                if (!parentPath.endsWith("/")) {
                    parentPath = parentPath + "/";
                }
                if (childPath.startsWith(parentPath)) {
                    return childPath.substring(parentPath.length());
                }
            }
        }
        if (childPath.endsWith("/")) {
            childPath = childPath.substring(0, childPath.length() - 1);
        }
        return childPath;
    }

    public int getRelativeOrder() {
        return this.relativeOrder;
    }

    public void setRelativeOrder(int order) {
        this.relativeOrder = order;
    }

    public void setContextInfoOrder(Integer contextInfoOrder) {
        this.contextInfoOrder = contextInfoOrder;
    }

    public CandidateStructureVisitorFactory getCandidateStructureVisitorFactory() {
        return this.candidateStructureVisitorFactory;
    }

    public void setCandidateStructureVisitorFactory(CandidateStructureVisitorFactory candidateStructureVisitorFactory) {
        if (candidateStructureVisitorFactory == null) {
            throw new IllegalArgumentException("Null candidateStructureVisitorFactory");
        }
        this.candidateStructureVisitorFactory = candidateStructureVisitorFactory;
    }

    public boolean isTopLevel(VirtualFile parent) {
        return parent == null;
    }

    protected void addClassPath(VirtualFile root, VirtualFile entry, boolean includeEntry, boolean includeRootManifestCP, ContextInfo context) throws IOException {
        ArrayList<VirtualFile> paths;
        boolean trace;
        block5: {
            trace = this.log.isTraceEnabled();
            paths = new ArrayList<VirtualFile>();
            if (includeEntry) {
                paths.add(entry);
            }
            if (includeRootManifestCP && !this.isLeaf(entry)) {
                try {
                    VFSUtils.addManifestLocations((VirtualFile)entry, paths);
                }
                catch (Exception e) {
                    if (!trace) break block5;
                    this.log.trace((Object)"Failed to add manifest locations", (Throwable)e);
                }
            }
        }
        for (VirtualFile vf : paths) {
            String entryPath = AbstractStructureDeployer.getRelativePath(root, vf);
            ClassPathEntry cpe = StructureMetaDataFactory.createClassPathEntry((String)entryPath);
            context.addClassPathEntry(cpe);
            if (!trace) continue;
            this.log.trace((Object)("Added classpath entry " + entryPath + " for " + vf.getName() + " from " + root));
        }
    }

    protected void addAllChildren(VirtualFile root, VirtualFile parent, StructureMetaData metaData, VFSStructuralDeployers deployers) throws Exception {
        this.addChildren(root, parent, metaData, deployers, null);
    }

    protected void addChildren(VirtualFile root, VirtualFile parent, StructureMetaData metaData, VFSStructuralDeployers deployers, VisitorAttributes attributes) throws Exception {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        VirtualFileVisitor visitor = this.candidateStructureVisitorFactory.createVisitor(root, parent, metaData, deployers, attributes);
        parent.visit(visitor);
    }

    protected boolean isLeaf(VirtualFile file) throws IOException {
        return SecurityActions.isLeaf(file);
    }

    protected ContextInfo createContext(VirtualFile root, String metaDataPath, StructureMetaData structureMetaData) {
        boolean trace = this.log.isTraceEnabled();
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        if (structureMetaData == null) {
            throw new IllegalArgumentException("Null structure metadata");
        }
        if (metaDataPath != null) {
            try {
                VirtualFile child = root.getChild(metaDataPath);
                if (child == null) {
                    metaDataPath = null;
                }
            }
            catch (IOException e) {
                this.log.warn((Object)("Not using metadata path " + metaDataPath + " for " + root.getName() + " reason: " + e.getMessage()));
                metaDataPath = null;
            }
        }
        ContextInfo result = metaDataPath != null ? StructureMetaDataFactory.createContextInfo((String)"", (String)metaDataPath, null) : StructureMetaDataFactory.createContextInfo((String)"", null);
        this.applyContextInfoOrder(root, result);
        structureMetaData.addContext(result);
        if (trace) {
            this.log.trace((Object)("Added context " + result + " from " + root.getName()));
        }
        return result;
    }

    protected void applyContextInfoOrder(VirtualFile root, ContextInfo result) {
        if (result != null && this.contextInfoOrder != null) {
            result.setRelativeOrder(this.contextInfoOrder.intValue());
        }
    }
}

