/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractParsingDeployerWithOutput;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.FileMatcher;
import org.jboss.deployers.vfs.spi.deployer.SecurityActions;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVFSParsingDeployer<T>
extends AbstractParsingDeployerWithOutput<T>
implements FileMatcher {
    private boolean allowMultipleFiles;

    public AbstractVFSParsingDeployer(Class<T> output) {
        super(output);
    }

    @Override
    public boolean isDeployable(VirtualFile file) {
        String fileName = file.getName();
        String suffix = this.getSuffix();
        if (suffix == null) {
            return this.getNames() != null && this.getNames().contains(fileName);
        }
        return fileName.endsWith(suffix);
    }

    protected boolean accepts(VFSDeploymentUnit unit) throws DeploymentException {
        return true;
    }

    protected boolean accepts(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            this.log.trace((Object)("Not a vfs deployment: " + unit.getName()));
            return false;
        }
        return this.accepts((VFSDeploymentUnit)unit);
    }

    protected InputStream openStreamAndValidate(VirtualFile file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        InputStream inputStream = SecurityActions.openStream(file);
        if (inputStream == null) {
            throw new IOException("Null file stream: " + file);
        }
        return inputStream;
    }

    protected T parse(DeploymentUnit unit, String name, T root) throws Exception {
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        VirtualFile file = vfsDeploymentUnit.getMetaDataFile(name);
        if (file == null) {
            return null;
        }
        T result = this.parse(vfsDeploymentUnit, file, root);
        if (result != null) {
            this.init(vfsDeploymentUnit, result, file);
        }
        return result;
    }

    protected T parse(DeploymentUnit unit, Set<String> names, T root) throws Exception {
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("Null or empty names.");
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        HashSet<String> missingFiles = new HashSet<String>();
        for (String name : names) {
            VirtualFile file = vfsDeploymentUnit.getMetaDataFile(name);
            if (file != null) {
                files.add(file);
                continue;
            }
            missingFiles.add(name);
        }
        if (missingFiles.size() == names.size()) {
            return null;
        }
        return this.mergeFiles(vfsDeploymentUnit, root, files, missingFiles);
    }

    protected T parse(DeploymentUnit unit, String name, String suffix, T root) throws Exception {
        VFSDeploymentUnit vfsDeploymentUnit;
        List<VirtualFile> files;
        if (name == null && this.isIncludeDeploymentFile()) {
            name = unit.getName();
        }
        if ((files = (vfsDeploymentUnit = (VFSDeploymentUnit)unit).getMetaDataFiles(name, suffix)).size() == 0) {
            return null;
        }
        if (files.size() > 1) {
            return this.handleMultipleFiles(vfsDeploymentUnit, root, files);
        }
        VirtualFile file = files.get(0);
        T result = this.parse(vfsDeploymentUnit, file, root);
        if (result != null) {
            this.init(vfsDeploymentUnit, result, file);
        }
        return result;
    }

    protected T parse(DeploymentUnit unit, Set<String> names, String suffix, T root) throws Exception {
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("Null or empty names.");
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        HashSet<String> missingFiles = new HashSet<String>();
        for (String name : names) {
            List<VirtualFile> matched = vfsDeploymentUnit.getMetaDataFiles(name, suffix);
            if (matched != null && !matched.isEmpty()) {
                files.addAll(matched);
                continue;
            }
            missingFiles.add(name);
        }
        if (missingFiles.size() == names.size()) {
            return null;
        }
        return this.mergeFiles(vfsDeploymentUnit, root, files, missingFiles);
    }

    protected T mergeFiles(VFSDeploymentUnit unit, T root, Set<VirtualFile> files, Set<String> missingFiles) throws Exception {
        return null;
    }

    protected T handleMultipleFiles(VFSDeploymentUnit unit, T root, List<VirtualFile> files) throws Exception {
        if (!this.allowsMultipleFiles(files)) {
            throw new IllegalArgumentException("Multiple matching files not allowed: " + files);
        }
        for (VirtualFile file : files) {
            T result = this.parse(unit, file, root);
            if (result == null) continue;
            this.init(unit, result, file);
            unit.addAttachment(file.toURL().toString(), result, this.getOutput());
        }
        return null;
    }

    protected boolean allowsMultipleFiles(List<VirtualFile> files) {
        return this.allowMultipleFiles;
    }

    protected abstract T parse(VFSDeploymentUnit var1, VirtualFile var2, T var3) throws Exception;

    protected void init(VFSDeploymentUnit unit, T metaData, VirtualFile file) throws Exception {
    }

    public void setAllowMultipleFiles(boolean allowMultipleFiles) {
        this.allowMultipleFiles = allowMultipleFiles;
    }
}

