/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.structure.attachments.test;

import java.util.Collections;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentContext;
import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentUnit;
import org.jboss.test.BaseTestCase;

public class AbstractDeploymentUnitAttachmentHierarchyUnitTestCase
extends BaseTestCase {
    private DeploymentUnit unit;
    private MutableAttachments predeterminedManagedObjects;
    private MutableAttachments transientManagedObjects;
    private MutableAttachments transientAttachments;

    public static Test suite() {
        return new TestSuite(AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.class);
    }

    public AbstractDeploymentUnitAttachmentHierarchyUnitTestCase(String name) {
        super(name);
        AbstractDeploymentContext context = new AbstractDeploymentContext("attachments", "");
        this.unit = new AbstractDeploymentUnit((DeploymentContext)context);
        context.setDeploymentUnit(this.unit);
        this.predeterminedManagedObjects = (MutableAttachments)context.getPredeterminedManagedObjects();
        this.transientManagedObjects = context.getTransientManagedObjects();
        this.transientAttachments = context.getTransientAttachments();
    }

    public void testPredeterminedIsFirstByName() {
        this.predeterminedManagedObjects.addAttachment("Name", (Object)"pMO");
        this.transientManagedObjects.addAttachment("Name", (Object)"tMO");
        this.transientAttachments.addAttachment("Name", (Object)"tA");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((Object)"pMO", (Object)this.unit.getAttachment("Name"));
        Map<String, String> expected = Collections.singletonMap("Name", "pMO");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals(expected, (Object)this.unit.getAttachments());
    }

    public void testPredeterminedIsFirstByNameAndType() {
        this.predeterminedManagedObjects.addAttachment("Name", (Object)"pMO", String.class);
        this.transientManagedObjects.addAttachment("Name", (Object)"tMO", String.class);
        this.transientAttachments.addAttachment("Name", (Object)"tA", String.class);
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((Object)"pMO", (Object)this.unit.getAttachment("Name"));
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((String)"pMO", (String)((String)this.unit.getAttachment("Name", String.class)));
        Map<String, String> expected = Collections.singletonMap("Name", "pMO");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals(expected, (Object)this.unit.getAttachments());
    }

    public void testPredeterminedIsFirstByType() {
        this.predeterminedManagedObjects.addAttachment(String.class, (Object)"pMO");
        this.transientManagedObjects.addAttachment(String.class, (Object)"tMO");
        this.transientAttachments.addAttachment(String.class, (Object)"tA");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((Object)"pMO", (Object)this.unit.getAttachment(String.class.getName()));
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((String)"pMO", (String)((String)this.unit.getAttachment(String.class.getName(), String.class)));
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((String)"pMO", (String)((String)this.unit.getAttachment(String.class)));
        Map<String, String> expected = Collections.singletonMap(String.class.getName(), "pMO");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals(expected, (Object)this.unit.getAttachments());
    }

    public void testTransientManagedObjectsIsSecondByName() {
        this.transientManagedObjects.addAttachment("Name", (Object)"tMO");
        this.transientAttachments.addAttachment("Name", (Object)"tA");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((Object)"tMO", (Object)this.unit.getAttachment("Name"));
        Map<String, String> expected = Collections.singletonMap("Name", "tMO");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals(expected, (Object)this.unit.getAttachments());
    }

    public void testTransientManagedObjectsIsSecondAndType() {
        this.transientManagedObjects.addAttachment("Name", (Object)"tMO", String.class);
        this.transientAttachments.addAttachment("Name", (Object)"tA", String.class);
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((Object)"tMO", (Object)this.unit.getAttachment("Name"));
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((String)"tMO", (String)((String)this.unit.getAttachment("Name", String.class)));
        Map<String, String> expected = Collections.singletonMap("Name", "tMO");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals(expected, (Object)this.unit.getAttachments());
    }

    public void testTransientManagedObjectsIsSecondByType() {
        this.transientManagedObjects.addAttachment(String.class, (Object)"tMO");
        this.transientAttachments.addAttachment(String.class, (Object)"tA");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((Object)"tMO", (Object)this.unit.getAttachment(String.class.getName()));
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((String)"tMO", (String)((String)this.unit.getAttachment(String.class.getName(), String.class)));
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((String)"tMO", (String)((String)this.unit.getAttachment(String.class)));
        Map<String, String> expected = Collections.singletonMap(String.class.getName(), "tMO");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals(expected, (Object)this.unit.getAttachments());
    }

    public void testTransientAttrachmentsIsThirdByName() {
        this.transientAttachments.addAttachment("Name", (Object)"tA");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((Object)"tA", (Object)this.unit.getAttachment("Name"));
        Map<String, String> expected = Collections.singletonMap("Name", "tA");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals(expected, (Object)this.unit.getAttachments());
    }

    public void testTransientAttrachmentsIsThirdAndType() {
        this.transientAttachments.addAttachment("Name", (Object)"tA", String.class);
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((Object)"tA", (Object)this.unit.getAttachment("Name"));
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((String)"tA", (String)((String)this.unit.getAttachment("Name", String.class)));
        Map<String, String> expected = Collections.singletonMap("Name", "tA");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals(expected, (Object)this.unit.getAttachments());
    }

    public void testTransientAttrachmentsIsThirdByType() {
        this.transientAttachments.addAttachment(String.class, (Object)"tA");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((Object)"tA", (Object)this.unit.getAttachment(String.class.getName()));
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((String)"tA", (String)((String)this.unit.getAttachment(String.class.getName(), String.class)));
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals((String)"tA", (String)((String)this.unit.getAttachment(String.class)));
        Map<String, String> expected = Collections.singletonMap(String.class.getName(), "tA");
        AbstractDeploymentUnitAttachmentHierarchyUnitTestCase.assertEquals(expected, (Object)this.unit.getAttachments());
    }
}

