/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.structure.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.plugins.attachments.AttachmentsImpl;
import org.jboss.deployers.plugins.structure.ClassPathEntryImpl;
import org.jboss.deployers.plugins.structure.ContextInfoImpl;
import org.jboss.deployers.plugins.structure.MetaDataEntryImpl;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.MetaDataEntry;
import org.jboss.test.deployers.structure.AbstractContextInfoTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextInfoImplUnitTestCase
extends AbstractContextInfoTest {
    public static Test suite() {
        return new TestSuite(ContextInfoImplUnitTestCase.class);
    }

    public ContextInfoImplUnitTestCase(String name) {
        super(name);
    }

    protected ContextInfoImpl createDefault() {
        return new ContextInfoImpl();
    }

    protected ContextInfoImpl createPath(String path) {
        return new ContextInfoImpl(path);
    }

    protected ContextInfoImpl createPathAndClassPath(String path, List<ClassPathEntry> classPath) {
        return new ContextInfoImpl(path, classPath);
    }

    @Override
    protected ContextInfo createPathAndMetaDataAndClassPath(String path, String metaDataPath, List<ClassPathEntry> classPath) {
        MetaDataEntryImpl entry = new MetaDataEntryImpl(metaDataPath);
        return new ContextInfoImpl(path, (MetaDataEntry)entry, classPath);
    }

    @Override
    protected ContextInfo createPathAndMetaDataAndClassPath(String path, List<String> metaDataPath, List<ClassPathEntry> classPath) {
        ArrayList<MetaDataEntryImpl> entries = new ArrayList<MetaDataEntryImpl>();
        for (String mdp : metaDataPath) {
            entries.add(new MetaDataEntryImpl(mdp));
        }
        return new ContextInfoImpl(path, entries, classPath);
    }

    @Override
    protected ClassPathEntry createClassPathEntry(String path) {
        return new ClassPathEntryImpl(path);
    }

    public void testSetPath() {
        ContextInfoImpl context = this.createDefault();
        ContextInfoImplUnitTestCase.assertEquals((String)"", (String)context.getPath());
        ContextInfoImplUnitTestCase.assertDefaultNonPath((ContextInfo)context);
        context.setPath("path");
        ContextInfoImplUnitTestCase.assertEquals((String)"path", (String)context.getPath());
        ContextInfoImplUnitTestCase.assertDefaultNonPath((ContextInfo)context);
        context.setPath("changed");
        ContextInfoImplUnitTestCase.assertEquals((String)"changed", (String)context.getPath());
        ContextInfoImplUnitTestCase.assertDefaultNonPath((ContextInfo)context);
    }

    public void testSetPathErrors() {
        ContextInfoImpl context = this.createDefault();
        ContextInfoImplUnitTestCase.assertEquals((String)"", (String)context.getPath());
        ContextInfoImplUnitTestCase.assertDefaultNonPath((ContextInfo)context);
        try {
            context.setPath(null);
            ContextInfoImplUnitTestCase.fail((String)"Should not be here!");
        }
        catch (Exception e) {
            ContextInfoImplUnitTestCase.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testAddMetaDataPath() {
        ContextInfoImpl context = this.createDefault();
        ContextInfoImplUnitTestCase.assertEquals((String)"", (String)context.getPath());
        ContextInfoImplUnitTestCase.assertDefaultNonPath((ContextInfo)context);
        this.addMetaDataPath((ContextInfo)context, "metaDataPath");
        ContextInfoImplUnitTestCase.assertDefaultMetaDataPath(context.getMetaDataPath());
        ContextInfoImplUnitTestCase.assertDefaultClassPath(context.getClassPath());
        this.addMetaDataPath((ContextInfo)context, "added");
        ContextInfoImplUnitTestCase.assertMetaDataPaths(Arrays.asList("metaDataPath", "added"), context.getMetaDataPath());
        ContextInfoImplUnitTestCase.assertDefaultClassPath(context.getClassPath());
    }

    public void testAddToDefaultMetaDataPath() {
        ArrayList<ClassPathEntry> classPath = new ArrayList<ClassPathEntry>();
        classPath.add((ClassPathEntry)new ClassPathEntryImpl());
        ContextInfo context = this.createPathAndMetaDataAndClassPath("", "metaDataPath", classPath);
        ContextInfoImplUnitTestCase.assertEquals((String)"", (String)context.getPath());
        ContextInfoImplUnitTestCase.assertDefaultMetaDataPath(context.getMetaDataPath());
        ContextInfoImplUnitTestCase.assertDefaultClassPath(context.getClassPath());
        this.addMetaDataPath(context, "added");
        ContextInfoImplUnitTestCase.assertMetaDataPaths(Arrays.asList("metaDataPath", "added"), context.getMetaDataPath());
        ContextInfoImplUnitTestCase.assertDefaultClassPath(context.getClassPath());
    }

    public void testSetMetaDataPathErrors() {
        ContextInfoImpl context = this.createDefault();
        ContextInfoImplUnitTestCase.assertEquals((String)"", (String)context.getPath());
        ContextInfoImplUnitTestCase.assertDefaultNonPath((ContextInfo)context);
        try {
            context.addMetaDataPath(null);
            ContextInfoImplUnitTestCase.fail((String)"Should not be here!");
        }
        catch (Exception e) {
            ContextInfoImplUnitTestCase.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testSetClassPath() {
        ContextInfoImpl context = this.createDefault();
        ContextInfoImplUnitTestCase.assertEquals((String)"", (String)context.getPath());
        ContextInfoImplUnitTestCase.assertDefaultNonPath((ContextInfo)context);
        List<ClassPathEntry> classPath = this.createClassPath("classPath");
        context.setClassPath(classPath);
        ContextInfoImplUnitTestCase.assertEquals((String)"", (String)context.getPath());
        ContextInfoImplUnitTestCase.assertDefaultMetaDataPath((ContextInfo)context);
        ContextInfoImplUnitTestCase.assertEquals(classPath, (Object)context.getClassPath());
        classPath = this.createClassPath("changed");
        context.setClassPath(classPath);
        ContextInfoImplUnitTestCase.assertEquals((String)"", (String)context.getPath());
        ContextInfoImplUnitTestCase.assertDefaultMetaDataPath((ContextInfo)context);
        ContextInfoImplUnitTestCase.assertEquals(classPath, (Object)context.getClassPath());
        classPath = null;
        context.setClassPath(classPath);
        ContextInfoImplUnitTestCase.assertEquals((String)"", (String)context.getPath());
        ContextInfoImplUnitTestCase.assertDefaultMetaDataPath((ContextInfo)context);
        ContextInfoImplUnitTestCase.assertEquals(classPath, (Object)context.getClassPath());
    }

    public void testPredeterminedManagedObjectAttachments() {
        ContextInfoImpl context = this.createDefault();
        ContextInfoImplUnitTestCase.assertEquals((String)"", (String)context.getPath());
        AttachmentsImpl ai = new AttachmentsImpl();
        ai.addAttachment("key1", (Object)"testPredeterminedManagedObjectAttachments");
        context.setPredeterminedManagedObjects((Attachments)ai);
        String a1 = (String)context.getPredeterminedManagedObjects().getAttachment("key1", String.class);
        ContextInfoImplUnitTestCase.assertEquals((String)"key1 attachment", (String)"testPredeterminedManagedObjectAttachments", (String)a1);
    }
}

