/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.structure.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.plugins.structure.ClassPathEntryImpl;
import org.jboss.test.deployers.structure.AbstractClassPathEntryTest;

public class ClassPathEntryImplUnitTestCase
extends AbstractClassPathEntryTest {
    public static Test suite() {
        return new TestSuite(ClassPathEntryImplUnitTestCase.class);
    }

    public ClassPathEntryImplUnitTestCase(String name) {
        super(name);
    }

    protected ClassPathEntryImpl createDefault() {
        return new ClassPathEntryImpl();
    }

    protected ClassPathEntryImpl createPath(String path) {
        return new ClassPathEntryImpl(path);
    }

    protected ClassPathEntryImpl createPathAndSuffixes(String path, String suffixes) {
        return new ClassPathEntryImpl(path, suffixes);
    }

    public void testSetPath() {
        ClassPathEntryImpl entry = this.createDefault();
        ClassPathEntryImplUnitTestCase.assertEquals((String)"", (String)entry.getPath());
        ClassPathEntryImplUnitTestCase.assertNull((Object)entry.getSuffixes());
        entry.setPath("path");
        ClassPathEntryImplUnitTestCase.assertEquals((String)"path", (String)entry.getPath());
        ClassPathEntryImplUnitTestCase.assertNull((Object)entry.getSuffixes());
        entry.setPath("changed");
        ClassPathEntryImplUnitTestCase.assertEquals((String)"changed", (String)entry.getPath());
        ClassPathEntryImplUnitTestCase.assertNull((Object)entry.getSuffixes());
    }

    public void testSetPathErrors() {
        ClassPathEntryImpl entry = this.createDefault();
        ClassPathEntryImplUnitTestCase.assertEquals((String)"", (String)entry.getPath());
        ClassPathEntryImplUnitTestCase.assertNull((Object)entry.getSuffixes());
        try {
            entry.setPath(null);
            ClassPathEntryImplUnitTestCase.fail((String)"Should not be here!");
        }
        catch (Exception e) {
            ClassPathEntryImplUnitTestCase.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testSetSuffixes() {
        ClassPathEntryImpl entry = this.createDefault();
        ClassPathEntryImplUnitTestCase.assertEquals((String)"", (String)entry.getPath());
        ClassPathEntryImplUnitTestCase.assertNull((Object)entry.getSuffixes());
        entry.setSuffixes("suffixes");
        ClassPathEntryImplUnitTestCase.assertEquals((String)"", (String)entry.getPath());
        ClassPathEntryImplUnitTestCase.assertEquals((String)"suffixes", (String)entry.getSuffixes());
        entry.setSuffixes("changed");
        ClassPathEntryImplUnitTestCase.assertEquals((String)"", (String)entry.getPath());
        ClassPathEntryImplUnitTestCase.assertEquals((String)"changed", (String)entry.getSuffixes());
        entry.setSuffixes(null);
        ClassPathEntryImplUnitTestCase.assertEquals((String)"", (String)entry.getPath());
        ClassPathEntryImplUnitTestCase.assertNull((Object)entry.getSuffixes());
    }
}

