/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.structure;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.test.BaseTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStructureTest
extends BaseTestCase {
    public AbstractStructureTest(String name) {
        super(name);
    }

    protected static void assertDefault(ContextInfo contextInfo) {
        AbstractStructureTest.assertDefaultPath(contextInfo);
        AbstractStructureTest.assertDefaultMetaDataPath(contextInfo);
        AbstractStructureTest.assertDefaultClassPath(contextInfo.getClassPath());
    }

    protected static void assertDefaultPath(ContextInfo contextInfo) {
        AbstractStructureTest.assertEquals((String)"", (String)contextInfo.getPath());
    }

    protected static void assertDefaultNonPath(ContextInfo contextInfo) {
        AbstractStructureTest.assertDefaultMetaDataPath(contextInfo);
        AbstractStructureTest.assertDefaultClassPath(contextInfo.getClassPath());
    }

    protected static void assertDefaultMetaDataPath(ContextInfo contextInfo) {
        AbstractStructureTest.assertNotNull((Object)contextInfo);
        AbstractStructureTest.assertNotNull((Object)contextInfo.getMetaDataPath());
        AbstractStructureTest.assertTrue((boolean)contextInfo.getMetaDataPath().isEmpty());
    }

    protected static void assertDefaultClassPath(List<ClassPathEntry> classPath) {
        AbstractStructureTest.assertNotNull(classPath);
        AbstractStructureTest.assertEquals((int)1, (int)classPath.size());
        ClassPathEntry entry = classPath.get(0);
        AbstractStructureTest.assertNotNull((Object)entry);
        AbstractStructureTest.assertEquals((String)"", (String)entry.getPath());
        AbstractStructureTest.assertNull((Object)entry.getSuffixes());
    }

    protected static void assertClassPath(ContextInfo context, ClassPathEntry ... paths) {
        ArrayList<ClassPathEntry> classPath = new ArrayList<ClassPathEntry>();
        if (paths != null) {
            for (ClassPathEntry entry : paths) {
                classPath.add(entry);
            }
        }
        AbstractStructureTest.assertEquals(classPath, (Object)context.getClassPath());
    }

    protected List<ClassPathEntry> createClassPath(String ... paths) {
        ArrayList<ClassPathEntry> result = new ArrayList<ClassPathEntry>();
        if (paths != null) {
            for (String path : paths) {
                result.add(this.createClassPathEntry(path));
            }
        }
        return result;
    }

    protected ClassPathEntry createClassPathEntry(String path) {
        throw new UnsupportedOperationException();
    }
}

