/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.test.deployers.structure.AbstractStructureTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStructureMetaDataTest
extends AbstractStructureTest {
    public AbstractStructureMetaDataTest(String name) {
        super(name);
    }

    protected abstract StructureMetaData createDefault();

    protected abstract ContextInfo createContext(String var1);

    protected List<ContextInfo> getExpected(ContextInfo ... expected) {
        ArrayList<ContextInfo> result = new ArrayList<ContextInfo>();
        if (expected != null) {
            for (ContextInfo context : expected) {
                result.add(context);
            }
        }
        return result;
    }

    public void testConstructorDefault() {
        StructureMetaData structure = this.createDefault();
        this.assertEmpty(structure.getContexts());
    }

    public void testAddContext() {
        StructureMetaData structure = this.createDefault();
        this.assertEmpty(structure.getContexts());
        ContextInfo one = this.createContext("one");
        structure.addContext(one);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(one), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
    }

    public void testAddContexts() {
        StructureMetaData structure = this.createDefault();
        this.assertEmpty(structure.getContexts());
        ContextInfo one = this.createContext("one");
        ContextInfo two = this.createContext("two");
        ContextInfo three = this.createContext("three");
        structure.addContext(one);
        structure.addContext(two);
        structure.addContext(three);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(one, two, three), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertEquals((Object)two, (Object)structure.getContext("two"));
        AbstractStructureMetaDataTest.assertEquals((Object)three, (Object)structure.getContext("three"));
    }

    public void testAddContextsErrors() {
        StructureMetaData structure = this.createDefault();
        this.assertEmpty(structure.getContexts());
        try {
            structure.addContext(null);
            AbstractStructureMetaDataTest.fail((String)"Should not be here!");
        }
        catch (Exception e) {
            AbstractStructureMetaDataTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
        ContextInfo one = this.createContext("one");
        structure.addContext(one);
        try {
            structure.addContext(one);
            AbstractStructureMetaDataTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractStructureMetaDataTest.checkThrowable(IllegalStateException.class, (Throwable)e);
        }
        ContextInfo another = this.createContext("one");
        try {
            structure.addContext(another);
            AbstractStructureMetaDataTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractStructureMetaDataTest.checkThrowable(IllegalStateException.class, (Throwable)e);
        }
    }

    public void testRemoveContext() {
        StructureMetaData structure = this.createDefault();
        this.assertEmpty(structure.getContexts());
        ContextInfo one = this.createContext("one");
        structure.addContext(one);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(one), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
        structure.removeContext(one);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(new ContextInfo[0]), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("one"));
        structure.addContext(one);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(one), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
    }

    public void testRemoveContexts() {
        StructureMetaData structure = this.createDefault();
        this.assertEmpty(structure.getContexts());
        ContextInfo one = this.createContext("one");
        ContextInfo two = this.createContext("two");
        ContextInfo three = this.createContext("three");
        structure.addContext(one);
        structure.addContext(two);
        structure.addContext(three);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(one, two, three), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertEquals((Object)two, (Object)structure.getContext("two"));
        AbstractStructureMetaDataTest.assertEquals((Object)three, (Object)structure.getContext("three"));
        structure.removeContext(one);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(two, three), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertEquals((Object)two, (Object)structure.getContext("two"));
        AbstractStructureMetaDataTest.assertEquals((Object)three, (Object)structure.getContext("three"));
        structure.removeContext(two);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(three), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("two"));
        AbstractStructureMetaDataTest.assertEquals((Object)three, (Object)structure.getContext("three"));
        structure.removeContext(three);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(new ContextInfo[0]), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("two"));
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("three"));
        structure.addContext(one);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(one), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
        structure.removeContext(two);
    }

    public void testRemoveContextErrors() {
        StructureMetaData structure = this.createDefault();
        this.assertEmpty(structure.getContexts());
        try {
            ContextInfo context = null;
            structure.removeContext(context);
            AbstractStructureMetaDataTest.fail((String)"Should not be here!");
        }
        catch (Exception e) {
            AbstractStructureMetaDataTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testRemoveContextByName() {
        StructureMetaData structure = this.createDefault();
        this.assertEmpty(structure.getContexts());
        ContextInfo one = this.createContext("one");
        structure.addContext(one);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(one), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
        structure.removeContext("one");
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(new ContextInfo[0]), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("one"));
        structure.addContext(one);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(one), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
    }

    public void testRemoveContextsByName() {
        StructureMetaData structure = this.createDefault();
        this.assertEmpty(structure.getContexts());
        ContextInfo one = this.createContext("one");
        ContextInfo two = this.createContext("two");
        ContextInfo three = this.createContext("three");
        structure.addContext(one);
        structure.addContext(two);
        structure.addContext(three);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(one, two, three), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertEquals((Object)two, (Object)structure.getContext("two"));
        AbstractStructureMetaDataTest.assertEquals((Object)three, (Object)structure.getContext("three"));
        structure.removeContext("one");
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(two, three), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertEquals((Object)two, (Object)structure.getContext("two"));
        AbstractStructureMetaDataTest.assertEquals((Object)three, (Object)structure.getContext("three"));
        structure.removeContext("two");
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(three), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("two"));
        AbstractStructureMetaDataTest.assertEquals((Object)three, (Object)structure.getContext("three"));
        structure.removeContext("three");
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(new ContextInfo[0]), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("two"));
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("three"));
        structure.addContext(one);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(one), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
        structure.removeContext("two");
    }

    public void testRemoveContextByNameErrors() {
        StructureMetaData structure = this.createDefault();
        this.assertEmpty(structure.getContexts());
        try {
            String name = null;
            structure.removeContext(name);
            AbstractStructureMetaDataTest.fail((String)"Should not be here!");
        }
        catch (Exception e) {
            AbstractStructureMetaDataTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testGetContext() {
        StructureMetaData structure = this.createDefault();
        this.assertEmpty(structure.getContexts());
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("two"));
        ContextInfo one = this.createContext("one");
        ContextInfo two = this.createContext("two");
        structure.addContext(one);
        structure.addContext(two);
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertEquals((Object)two, (Object)structure.getContext("two"));
        structure.removeContext("one");
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertEquals((Object)two, (Object)structure.getContext("two"));
        structure.removeContext("two");
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("two"));
        structure.addContext(one);
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertNull((Object)structure.getContext("two"));
    }

    public void testEqualsAndHashCode() {
        StructureMetaData one = this.createDefault();
        StructureMetaData two = this.createDefault();
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)two);
        AbstractStructureMetaDataTest.assertEquals((Object)two, (Object)one);
        AbstractStructureMetaDataTest.assertEquals((int)one.hashCode(), (int)two.hashCode());
        ContextInfo context1 = this.createContext("one");
        ContextInfo context2 = this.createContext("two");
        one.addContext(context1);
        two.addContext(context1);
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)two);
        AbstractStructureMetaDataTest.assertEquals((Object)two, (Object)one);
        AbstractStructureMetaDataTest.assertEquals((int)one.hashCode(), (int)two.hashCode());
        one.addContext(context2);
        two.addContext(context2);
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)two);
        AbstractStructureMetaDataTest.assertEquals((Object)two, (Object)one);
        AbstractStructureMetaDataTest.assertEquals((int)one.hashCode(), (int)two.hashCode());
        one.removeContext(context2);
        two.removeContext(context2);
        ContextInfo another1 = this.createContext("one");
        two.removeContext(context1);
        two.addContext(another1);
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)two);
        AbstractStructureMetaDataTest.assertEquals((Object)two, (Object)one);
        AbstractStructureMetaDataTest.assertEquals((int)one.hashCode(), (int)two.hashCode());
        two.removeContext(context1);
        AbstractStructureMetaDataTest.assertNotSame((Object)one, (Object)two);
        AbstractStructureMetaDataTest.assertNotSame((Object)two, (Object)one);
        AbstractStructureMetaDataTest.assertNotSame((Object)one.hashCode(), (Object)two.hashCode());
        two.addContext(context2);
        AbstractStructureMetaDataTest.assertNotSame((Object)one, (Object)two);
        AbstractStructureMetaDataTest.assertNotSame((Object)two, (Object)one);
        AbstractStructureMetaDataTest.assertNotSame((Object)one.hashCode(), (Object)two.hashCode());
        one = this.createDefault();
        two = this.createDefault();
        one.addContext(context1);
        one.addContext(context2);
        two.addContext(context2);
        two.addContext(context1);
        AbstractStructureMetaDataTest.assertNotSame((Object)one, (Object)two);
        AbstractStructureMetaDataTest.assertNotSame((Object)two, (Object)one);
        AbstractStructureMetaDataTest.assertNotSame((Object)one.hashCode(), (Object)two.hashCode());
    }

    public void testSerialization() throws Exception {
        StructureMetaData structure = this.createDefault();
        this.assertEmpty(structure.getContexts());
        structure = (StructureMetaData)this.serializeDeserialize((Serializable)structure, StructureMetaData.class);
        this.assertEmpty(structure.getContexts());
        ContextInfo one = this.createContext("one");
        ContextInfo two = this.createContext("two");
        structure.addContext(one);
        structure.addContext(two);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(one, two), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertEquals((Object)two, (Object)structure.getContext("two"));
        structure = (StructureMetaData)this.serializeDeserialize((Serializable)structure, StructureMetaData.class);
        AbstractStructureMetaDataTest.assertEquals(this.getExpected(one, two), (Object)structure.getContexts());
        AbstractStructureMetaDataTest.assertEquals((Object)one, (Object)structure.getContext("one"));
        AbstractStructureMetaDataTest.assertEquals((Object)two, (Object)structure.getContext("two"));
    }
}

