/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.structure;

import java.io.Serializable;
import java.util.List;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.MetaDataEntry;
import org.jboss.deployers.spi.structure.MetaDataType;
import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
import org.jboss.test.deployers.structure.AbstractStructureTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContextInfoTest
extends AbstractStructureTest {
    public AbstractContextInfoTest(String name) {
        super(name);
    }

    protected abstract ContextInfo createDefault();

    public void testConstructorDefault() {
        ContextInfo context = this.createDefault();
        AbstractContextInfoTest.assertDefault(context);
    }

    protected abstract ContextInfo createPath(String var1);

    public void testConstructorPath() {
        ContextInfo context = this.createPath("path");
        AbstractContextInfoTest.assertEquals((String)"path", (String)context.getPath());
        AbstractContextInfoTest.assertDefaultNonPath(context);
    }

    public void testConstructorErrorsPath() {
        try {
            this.createPath(null);
            AbstractContextInfoTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractContextInfoTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    protected abstract ContextInfo createPathAndClassPath(String var1, List<ClassPathEntry> var2);

    @Override
    protected abstract ClassPathEntry createClassPathEntry(String var1);

    public void testConstructorPathAndClassPath() {
        List<ClassPathEntry> classPath = this.createClassPath("ClassPath");
        ContextInfo context = this.createPathAndClassPath("path", classPath);
        AbstractContextInfoTest.assertEquals((String)"path", (String)context.getPath());
        AbstractContextInfoTest.assertDefaultMetaDataPath(context);
        AbstractContextInfoTest.assertEquals(classPath, (Object)context.getClassPath());
        classPath = null;
        context = this.createPathAndClassPath("path", classPath);
        AbstractContextInfoTest.assertEquals((String)"path", (String)context.getPath());
        AbstractContextInfoTest.assertDefaultMetaDataPath(context);
        AbstractContextInfoTest.assertNull((Object)context.getClassPath());
    }

    public void testConstructorErrorsPathAndClassPath() {
        List<ClassPathEntry> classPath = this.createClassPath("ClassPath");
        try {
            this.createPathAndClassPath(null, classPath);
            AbstractContextInfoTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractContextInfoTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    protected abstract ContextInfo createPathAndMetaDataAndClassPath(String var1, String var2, List<ClassPathEntry> var3);

    protected abstract ContextInfo createPathAndMetaDataAndClassPath(String var1, List<String> var2, List<ClassPathEntry> var3);

    protected void addMetaDataPath(ContextInfo context, String path) {
        MetaDataEntry entry = StructureMetaDataFactory.createMetaDataEntry((String)path);
        context.addMetaDataPath(entry);
    }

    protected static void assertDefaultMetaDataPath(List<MetaDataEntry> metaDataPath) {
        AbstractContextInfoTest.assertEquals((int)1, (int)metaDataPath.size());
        AbstractContextInfoTest.assertEquals((String)"metaDataPath", (String)metaDataPath.get(0).getPath());
        AbstractContextInfoTest.assertEquals((Object)MetaDataType.DEFAULT, (Object)metaDataPath.get(0).getType());
    }

    protected static void assertMetaDataPaths(List<String> expected, List<MetaDataEntry> entries) {
        AbstractContextInfoTest.assertEquals((int)expected.size(), (int)entries.size());
        int i = 0;
        for (String path : expected) {
            AbstractContextInfoTest.assertEquals((String)path, (String)entries.get(i).getPath());
            ++i;
        }
    }

    public void testConstructorPathAndMetaDataAndClassPath() {
        List<ClassPathEntry> classPath = this.createClassPath("ClassPath");
        ContextInfo context = this.createPathAndMetaDataAndClassPath("path", "metaDataPath", classPath);
        AbstractContextInfoTest.assertEquals((String)"path", (String)context.getPath());
        AbstractContextInfoTest.assertDefaultMetaDataPath(context.getMetaDataPath());
        AbstractContextInfoTest.assertEquals(classPath, (Object)context.getClassPath());
        classPath = null;
        context = this.createPathAndMetaDataAndClassPath("path", "metaDataPath", classPath);
        AbstractContextInfoTest.assertEquals((String)"path", (String)context.getPath());
        AbstractContextInfoTest.assertDefaultMetaDataPath(context.getMetaDataPath());
        AbstractContextInfoTest.assertNull((Object)context.getClassPath());
    }

    public void testConstructorErrorsPathAndMetaDataPathAndAndClassPath() {
        List<ClassPathEntry> classPath = this.createClassPath("ClassPath");
        try {
            this.createPathAndMetaDataAndClassPath(null, "metaData", classPath);
            AbstractContextInfoTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractContextInfoTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
        try {
            this.createPathAndMetaDataAndClassPath("path", (String)null, classPath);
            AbstractContextInfoTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractContextInfoTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testAddClassPath() {
        ContextInfo context = this.createPathAndClassPath("", null);
        AbstractContextInfoTest.assertDefaultPath(context);
        AbstractContextInfoTest.assertDefaultMetaDataPath(context);
        AbstractContextInfoTest.assertNull((Object)context.getClassPath());
        ClassPathEntry entry1 = this.createClassPathEntry("path1");
        context.addClassPathEntry(entry1);
        AbstractContextInfoTest.assertDefaultPath(context);
        AbstractContextInfoTest.assertDefaultMetaDataPath(context);
        AbstractContextInfoTest.assertClassPath(context, entry1);
        ClassPathEntry entry2 = this.createClassPathEntry("path2");
        context.addClassPathEntry(entry2);
        AbstractContextInfoTest.assertDefaultPath(context);
        AbstractContextInfoTest.assertDefaultMetaDataPath(context);
        AbstractContextInfoTest.assertClassPath(context, entry1, entry2);
    }

    public void testEqualsAndHashCode() {
        ContextInfo one = this.createDefault();
        ContextInfo two = this.createDefault();
        AbstractContextInfoTest.assertEquals((Object)one, (Object)two);
        AbstractContextInfoTest.assertEquals((Object)two, (Object)one);
        AbstractContextInfoTest.assertEquals((int)one.hashCode(), (int)two.hashCode());
        List<ClassPathEntry> classPath1 = this.createClassPath("");
        two = this.createPathAndClassPath("", classPath1);
        AbstractContextInfoTest.assertEquals((Object)one, (Object)two);
        AbstractContextInfoTest.assertEquals((Object)two, (Object)one);
        AbstractContextInfoTest.assertEquals((int)one.hashCode(), (int)two.hashCode());
        classPath1 = this.createClassPath("classPath");
        one = this.createPathAndMetaDataAndClassPath("path", "metaDataPath", classPath1);
        two = this.createPathAndMetaDataAndClassPath("path", "metaDataPath", classPath1);
        AbstractContextInfoTest.assertEquals((Object)one, (Object)two);
        AbstractContextInfoTest.assertEquals((Object)two, (Object)one);
        AbstractContextInfoTest.assertEquals((int)one.hashCode(), (int)two.hashCode());
        List<ClassPathEntry> classPath2 = this.createClassPath("classPath");
        one = this.createPathAndMetaDataAndClassPath("path", "metaDataPath", classPath1);
        two = this.createPathAndMetaDataAndClassPath("path", "metaDataPath", classPath2);
        AbstractContextInfoTest.assertEquals((Object)one, (Object)two);
        AbstractContextInfoTest.assertEquals((Object)two, (Object)one);
        AbstractContextInfoTest.assertEquals((int)one.hashCode(), (int)two.hashCode());
        one = this.createPathAndMetaDataAndClassPath("path", "metaDataPath", classPath1);
        two = this.createPathAndMetaDataAndClassPath("not-path", "metaDataPath", classPath1);
        AbstractContextInfoTest.assertNotSame((Object)one, (Object)two);
        AbstractContextInfoTest.assertNotSame((Object)two, (Object)one);
        AbstractContextInfoTest.assertNotSame((Object)one.hashCode(), (Object)two.hashCode());
        one = this.createPathAndMetaDataAndClassPath("path", "metaDataPath", classPath1);
        two = this.createPathAndMetaDataAndClassPath("path", "not-metaDataPath", classPath1);
        AbstractContextInfoTest.assertNotSame((Object)one, (Object)two);
        AbstractContextInfoTest.assertNotSame((Object)two, (Object)one);
        AbstractContextInfoTest.assertNotSame((Object)one.hashCode(), (Object)two.hashCode());
        classPath2 = this.createClassPath("not-classPath");
        one = this.createPathAndMetaDataAndClassPath("path", "metaDataPath", classPath1);
        two = this.createPathAndMetaDataAndClassPath("Path", "metaDataPath", classPath2);
        AbstractContextInfoTest.assertNotSame((Object)one, (Object)two);
        AbstractContextInfoTest.assertNotSame((Object)two, (Object)one);
        AbstractContextInfoTest.assertNotSame((Object)one.hashCode(), (Object)two.hashCode());
        one = this.createPathAndMetaDataAndClassPath("path", "metaDataPath", classPath1);
        two = this.createPathAndMetaDataAndClassPath("Path", "metaDataPath", null);
        AbstractContextInfoTest.assertNotSame((Object)one, (Object)two);
        AbstractContextInfoTest.assertNotSame((Object)two, (Object)one);
        AbstractContextInfoTest.assertNotSame((Object)one.hashCode(), (Object)two.hashCode());
        classPath2 = this.createClassPath("classPath", "notClassPath");
        one = this.createPathAndMetaDataAndClassPath("path", "metaDataPath", classPath1);
        two = this.createPathAndMetaDataAndClassPath("Path", "metaDataPath", classPath2);
        AbstractContextInfoTest.assertNotSame((Object)one, (Object)two);
        AbstractContextInfoTest.assertNotSame((Object)two, (Object)one);
        AbstractContextInfoTest.assertNotSame((Object)one.hashCode(), (Object)two.hashCode());
    }

    public void testSerialization() throws Exception {
        ContextInfo context = this.createDefault();
        AbstractContextInfoTest.assertDefault(context);
        context = (ContextInfo)this.serializeDeserialize((Serializable)context, ContextInfo.class);
        AbstractContextInfoTest.assertDefault(context);
        List<ClassPathEntry> classPath = this.createClassPath("ClassPath");
        context = this.createPathAndMetaDataAndClassPath("path", "metaDataPath", classPath);
        AbstractContextInfoTest.assertEquals((String)"path", (String)context.getPath());
        AbstractContextInfoTest.assertDefaultMetaDataPath(context.getMetaDataPath());
        AbstractContextInfoTest.assertEquals(classPath, (Object)context.getClassPath());
        context = (ContextInfo)this.serializeDeserialize((Serializable)context, ContextInfo.class);
        AbstractContextInfoTest.assertEquals((String)"path", (String)context.getPath());
        AbstractContextInfoTest.assertDefaultMetaDataPath(context.getMetaDataPath());
        AbstractContextInfoTest.assertEquals(classPath, (Object)context.getClassPath());
    }
}

