/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.structure;

import java.io.Serializable;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.test.BaseTestCase;

public abstract class AbstractClassPathEntryTest
extends BaseTestCase {
    public AbstractClassPathEntryTest(String name) {
        super(name);
    }

    protected abstract ClassPathEntry createDefault();

    public void testConstructorDefault() {
        ClassPathEntry entry = this.createDefault();
        AbstractClassPathEntryTest.assertEquals((String)"", (String)entry.getPath());
        AbstractClassPathEntryTest.assertNull((Object)entry.getSuffixes());
    }

    protected abstract ClassPathEntry createPath(String var1);

    public void testConstructorPath() {
        ClassPathEntry entry = this.createPath("path");
        AbstractClassPathEntryTest.assertEquals((String)"path", (String)entry.getPath());
        AbstractClassPathEntryTest.assertNull((Object)entry.getSuffixes());
    }

    public void testConstructorErrorsPath() {
        try {
            this.createPath(null);
            AbstractClassPathEntryTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractClassPathEntryTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    protected abstract ClassPathEntry createPathAndSuffixes(String var1, String var2);

    public void testConstructorPathAndSuffixes() {
        ClassPathEntry entry = this.createPathAndSuffixes("path", "suffixes");
        AbstractClassPathEntryTest.assertEquals((String)"path", (String)entry.getPath());
        AbstractClassPathEntryTest.assertEquals((String)"suffixes", (String)entry.getSuffixes());
        entry = this.createPathAndSuffixes("path", null);
        AbstractClassPathEntryTest.assertEquals((String)"path", (String)entry.getPath());
        AbstractClassPathEntryTest.assertNull((Object)entry.getSuffixes());
    }

    public void testConstructorErrorsPathAndSuffixes() {
        try {
            this.createPathAndSuffixes(null, "suffixes");
            AbstractClassPathEntryTest.fail((String)"Should not be here");
        }
        catch (Exception e) {
            AbstractClassPathEntryTest.checkThrowable(IllegalArgumentException.class, (Throwable)e);
        }
    }

    public void testEqualsAndHashCode() {
        ClassPathEntry one = this.createDefault();
        ClassPathEntry two = this.createDefault();
        AbstractClassPathEntryTest.assertEquals((Object)one, (Object)two);
        AbstractClassPathEntryTest.assertEquals((Object)two, (Object)one);
        AbstractClassPathEntryTest.assertEquals((int)one.hashCode(), (int)two.hashCode());
        two = this.createPathAndSuffixes("", null);
        AbstractClassPathEntryTest.assertEquals((Object)one, (Object)two);
        AbstractClassPathEntryTest.assertEquals((Object)two, (Object)one);
        AbstractClassPathEntryTest.assertEquals((int)one.hashCode(), (int)two.hashCode());
        one = this.createPathAndSuffixes("path", "suffixes");
        two = this.createPathAndSuffixes("path", "suffixes");
        AbstractClassPathEntryTest.assertEquals((Object)one, (Object)two);
        AbstractClassPathEntryTest.assertEquals((Object)two, (Object)one);
        AbstractClassPathEntryTest.assertEquals((int)one.hashCode(), (int)two.hashCode());
        one = this.createPathAndSuffixes("path", "suffixes");
        two = this.createPathAndSuffixes("not-path", "suffixes");
        AbstractClassPathEntryTest.assertNotSame((Object)one, (Object)two);
        AbstractClassPathEntryTest.assertNotSame((Object)two, (Object)one);
        AbstractClassPathEntryTest.assertNotSame((Object)one.hashCode(), (Object)two.hashCode());
        one = this.createPathAndSuffixes("path", "suffixes");
        two = this.createPathAndSuffixes("Path", "not-suffixes");
        AbstractClassPathEntryTest.assertNotSame((Object)one, (Object)two);
        AbstractClassPathEntryTest.assertNotSame((Object)two, (Object)one);
        AbstractClassPathEntryTest.assertNotSame((Object)one.hashCode(), (Object)two.hashCode());
        one = this.createPathAndSuffixes("path", "suffixes");
        two = this.createPathAndSuffixes("Path", null);
        AbstractClassPathEntryTest.assertNotSame((Object)one, (Object)two);
        AbstractClassPathEntryTest.assertNotSame((Object)two, (Object)one);
        AbstractClassPathEntryTest.assertNotSame((Object)one.hashCode(), (Object)two.hashCode());
    }

    public void testSerialization() throws Exception {
        ClassPathEntry entry = this.createDefault();
        AbstractClassPathEntryTest.assertEquals((String)"", (String)entry.getPath());
        AbstractClassPathEntryTest.assertNull((Object)entry.getSuffixes());
        entry = (ClassPathEntry)this.serializeDeserialize((Serializable)entry, ClassPathEntry.class);
        AbstractClassPathEntryTest.assertEquals((String)"", (String)entry.getPath());
        AbstractClassPathEntryTest.assertNull((Object)entry.getSuffixes());
        entry = this.createPathAndSuffixes("path", "suffixes");
        AbstractClassPathEntryTest.assertEquals((String)"path", (String)entry.getPath());
        AbstractClassPathEntryTest.assertEquals((String)"suffixes", (String)entry.getSuffixes());
        entry = (ClassPathEntry)this.serializeDeserialize((Serializable)entry, ClassPathEntry.class);
        AbstractClassPathEntryTest.assertEquals((String)"path", (String)entry.getPath());
        AbstractClassPathEntryTest.assertEquals((String)"suffixes", (String)entry.getSuffixes());
    }
}

