/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.deployers.attachments.test;

import java.io.Serializable;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.test.BaseTestCase;
import org.jboss.test.deployers.attachments.test.ExpectedAttachments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttachmentsTest
extends BaseTestCase {
    public static Test suite() {
        return new TestSuite(AttachmentsTest.class);
    }

    public AttachmentsTest(String name) {
        super(name);
    }

    protected abstract Attachments getAttachments();

    protected abstract MutableAttachments getMutable();

    public void testAddAttachmentErrors() throws Exception {
        MutableAttachments mutable = this.getMutable();
        try {
            mutable.addAttachment((String)null, (Object)"attachment");
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            mutable.addAttachment("name", null);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            mutable.addAttachment(null, (Object)"attachment", String.class);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            mutable.addAttachment("name", null, String.class);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            mutable.addAttachment("name", (Object)"attachment", null);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            mutable.addAttachment((Class)null, (Object)"attachment");
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            mutable.addAttachment(String.class, null);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
    }

    public void testAddAttachmentByName() throws Exception {
        MutableAttachments mutable = this.getMutable();
        ExpectedAttachments expected = new ExpectedAttachments();
        this.assertAddFreshAttachmentByName(mutable, expected, "name1", "attachment1");
        this.assertAddFreshAttachmentByName(mutable, expected, "name2", "attachment2");
        this.assertAddReplaceAttachmentByName(mutable, expected, "name1", "different1", "attachment1");
    }

    protected void assertAddFreshAttachmentByName(MutableAttachments mutable, ExpectedAttachments expected, String name, Object attachment) {
        this.assertAddReplaceAttachmentByName(mutable, expected, name, attachment, null);
    }

    protected void assertAddReplaceAttachmentByName(MutableAttachments mutable, ExpectedAttachments expected, String name, Object attachment, Object replaced) {
        Object result = this.assertAddAttachmentByName(mutable, expected, name, attachment);
        AttachmentsTest.assertEquals((Object)replaced, (Object)result);
    }

    protected Object assertAddAttachmentByName(MutableAttachments mutable, ExpectedAttachments expected, String name, Object attachment) {
        Object result = mutable.addAttachment(name, attachment);
        this.checkAdd((Attachments)mutable, expected, name, attachment, result);
        return result;
    }

    protected Object checkAdd(Attachments attachments, ExpectedAttachments expected, String name, Object attachment, Object result) {
        AttachmentsTest.assertEquals((Object)attachment, (Object)attachments.getAttachment(name));
        AttachmentsTest.assertTrue((boolean)attachments.isAttachmentPresent(name));
        Object expectedResult = this.assertExpectedAdd(attachments, expected, name, attachment);
        AttachmentsTest.assertEquals((Object)expectedResult, (Object)result);
        return result;
    }

    protected Object assertExpectedAdd(Attachments attachments, ExpectedAttachments expected, String name, Object attachment) {
        Object result = expected.add(name, attachment);
        AttachmentsTest.assertEquals(expected.expected, (Object)attachments.getAttachments());
        return result;
    }

    public void testAddAttachmentByNameAndType() throws Exception {
        MutableAttachments mutable = this.getMutable();
        ExpectedAttachments expected = new ExpectedAttachments();
        this.assertAddFreshAttachmentByNameAndType(mutable, expected, "name1", "attachment1", String.class);
        this.assertAddFreshAttachmentByNameAndType(mutable, expected, "name2", "attachment2", String.class);
        this.assertAddReplaceAttachmentByNameAndType(mutable, expected, "name1", "different1", "attachment1", String.class);
    }

    protected <T> void assertAddFreshAttachmentByNameAndType(MutableAttachments mutable, ExpectedAttachments expected, String name, T attachment, Class<T> expectedType) {
        this.assertAddReplaceAttachmentByNameAndType(mutable, expected, name, attachment, null, expectedType);
    }

    protected <T> void assertAddReplaceAttachmentByNameAndType(MutableAttachments mutable, ExpectedAttachments expected, String name, T attachment, Object replaced, Class<T> expectedType) {
        Object result = this.assertAddAttachmentByNameAndType(mutable, expected, name, attachment, expectedType);
        AttachmentsTest.assertEquals((Object)replaced, (Object)result);
    }

    protected <T> Object assertAddAttachmentByNameAndType(MutableAttachments mutable, ExpectedAttachments expected, String name, T attachment, Class<T> expectedType) {
        Object result = mutable.addAttachment(name, attachment, expectedType);
        this.checkAdd((Attachments)mutable, expected, name, attachment, result);
        AttachmentsTest.assertEquals(attachment, (Object)mutable.getAttachment(name, expectedType));
        AttachmentsTest.assertTrue((boolean)mutable.isAttachmentPresent(name, expectedType));
        return result;
    }

    public void testAddAttachmentByType() throws Exception {
        MutableAttachments mutable = this.getMutable();
        ExpectedAttachments expected = new ExpectedAttachments();
        this.assertAddFreshAttachmentByType(mutable, expected, Integer.class, 1);
        this.assertAddFreshAttachmentByType(mutable, expected, String.class, "attachment");
        this.assertAddReplaceAttachmentByType(mutable, expected, String.class, "different", "attachment");
    }

    protected <T> void assertAddFreshAttachmentByType(MutableAttachments mutable, ExpectedAttachments expected, Class<T> type, T attachment) {
        this.assertAddReplaceAttachmentByType(mutable, expected, type, attachment, null);
    }

    protected <T> void assertAddReplaceAttachmentByType(MutableAttachments mutable, ExpectedAttachments expected, Class<T> type, T attachment, Object replaced) {
        Object result = this.assertAddAttachmentByType(mutable, expected, type, attachment);
        AttachmentsTest.assertEquals((Object)replaced, (Object)result);
    }

    protected <T> Object assertAddAttachmentByType(MutableAttachments mutable, ExpectedAttachments expected, Class<T> type, T attachment) {
        Object result = mutable.addAttachment(type, attachment);
        String name = type.getName();
        this.checkAdd((Attachments)mutable, expected, name, attachment, result);
        AttachmentsTest.assertEquals(attachment, (Object)mutable.getAttachment(type));
        AttachmentsTest.assertTrue((boolean)mutable.isAttachmentPresent(type));
        AttachmentsTest.assertEquals(attachment, (Object)mutable.getAttachment(name, type));
        AttachmentsTest.assertTrue((boolean)mutable.isAttachmentPresent(name, type));
        return result;
    }

    public void testRemoveAttachmentErrors() throws Exception {
        MutableAttachments mutable = this.getMutable();
        try {
            mutable.removeAttachment((String)null);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            mutable.removeAttachment(null, String.class);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            mutable.removeAttachment("name", null);
            AttachmentsTest.fail((String)"Should nt be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            mutable.removeAttachment((Class)null);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
    }

    public void testRemoveAttachmentByName() throws Exception {
        MutableAttachments mutable = this.getMutable();
        ExpectedAttachments expected = new ExpectedAttachments();
        this.assertRemoveNotPresentAttachmentByName(mutable, expected, "name1");
        this.assertAddAttachmentByName(mutable, expected, "name1", "attachment1");
        this.assertAddAttachmentByName(mutable, expected, "name2", "different2");
        this.assertRemoveAttachmentByName(mutable, expected, "name1", "attachment1");
    }

    protected void assertRemoveNotPresentAttachmentByName(MutableAttachments mutable, ExpectedAttachments expected, String name) {
        this.assertRemoveAttachmentByName(mutable, expected, name, null);
    }

    protected void assertRemoveAttachmentByName(MutableAttachments mutable, ExpectedAttachments expected, String name, Object removed) {
        Object result = this.assertRemoveAttachmentByName(mutable, expected, name);
        AttachmentsTest.assertEquals((Object)removed, (Object)result);
    }

    protected Object assertRemoveAttachmentByName(MutableAttachments mutable, ExpectedAttachments expected, String name) {
        Object result = mutable.removeAttachment(name);
        this.checkRemove((Attachments)mutable, expected, name, result);
        return result;
    }

    protected Object checkRemove(Attachments attachments, ExpectedAttachments expected, String name, Object result) {
        AttachmentsTest.assertNull((Object)attachments.getAttachment(name));
        AttachmentsTest.assertFalse((boolean)attachments.isAttachmentPresent(name));
        Object expectedResult = this.assertExpectedRemove(attachments, expected, name);
        AttachmentsTest.assertEquals((Object)expectedResult, (Object)result);
        return result;
    }

    protected Object assertExpectedRemove(Attachments attachments, ExpectedAttachments expected, String name) {
        Object result = expected.remove(name);
        AttachmentsTest.assertEquals(expected.expected, (Object)attachments.getAttachments());
        return result;
    }

    public void testRemoveAttachmentByNameAndType() throws Exception {
        MutableAttachments mutable = this.getMutable();
        ExpectedAttachments expected = new ExpectedAttachments();
        this.assertRemoveNotPresentAttachmentByNameAndType(mutable, expected, "name1", String.class);
        this.assertAddAttachmentByNameAndType(mutable, expected, "name1", "attachment1", String.class);
        this.assertAddAttachmentByNameAndType(mutable, expected, "name2", "different2", String.class);
        this.assertRemoveAttachmentByNameAndType(mutable, expected, "name1", "attachment1", String.class);
    }

    protected <T> void assertRemoveNotPresentAttachmentByNameAndType(MutableAttachments mutable, ExpectedAttachments expected, String name, Class<T> expectedType) {
        this.assertRemoveAttachmentByNameAndType(mutable, expected, name, null, expectedType);
    }

    protected <T> void assertRemoveAttachmentByNameAndType(MutableAttachments mutable, ExpectedAttachments expected, String name, Object removed, Class<T> expectedType) {
        Object result = this.assertRemoveAttachmentByNameAndType(mutable, expected, name, expectedType);
        AttachmentsTest.assertEquals((Object)removed, (Object)result);
    }

    protected <T> Object assertRemoveAttachmentByNameAndType(MutableAttachments mutable, ExpectedAttachments expected, String name, Class<T> expectedType) {
        Object result = mutable.removeAttachment(name, expectedType);
        this.checkRemove((Attachments)mutable, expected, name, result);
        AttachmentsTest.assertNull((Object)mutable.getAttachment(name, expectedType));
        AttachmentsTest.assertFalse((boolean)mutable.isAttachmentPresent(name, expectedType));
        return result;
    }

    public void testRemoveAttachmentByType() throws Exception {
        MutableAttachments mutable = this.getMutable();
        ExpectedAttachments expected = new ExpectedAttachments();
        this.assertRemoveNotPresentAttachmentByType(mutable, expected, Integer.class);
        this.assertAddAttachmentByType(mutable, expected, Integer.class, 1);
        this.assertAddAttachmentByType(mutable, expected, String.class, "attachment");
        this.assertRemoveAttachmentByType(mutable, expected, String.class, "attachment");
    }

    protected <T> void assertRemoveNotPresentAttachmentByType(MutableAttachments mutable, ExpectedAttachments expected, Class<T> type) {
        this.assertRemoveAttachmentByType(mutable, expected, type, null);
    }

    protected <T> void assertRemoveAttachmentByType(MutableAttachments mutable, ExpectedAttachments expected, Class<T> type, Object removed) {
        Object result = this.assertRemoveAttachmentByType(mutable, expected, type);
        AttachmentsTest.assertEquals((Object)removed, (Object)result);
    }

    protected <T> Object assertRemoveAttachmentByType(MutableAttachments mutable, ExpectedAttachments expected, Class<T> type) {
        Object result = mutable.removeAttachment(type);
        String name = type.getName();
        this.checkRemove((Attachments)mutable, expected, name, result);
        AttachmentsTest.assertNull((Object)mutable.getAttachment(type));
        AttachmentsTest.assertFalse((boolean)mutable.isAttachmentPresent(type));
        AttachmentsTest.assertNull((Object)mutable.getAttachment(name, type));
        AttachmentsTest.assertFalse((boolean)mutable.isAttachmentPresent(name, type));
        return result;
    }

    public void testGetAttachmentErrors() throws Exception {
        Attachments attachments = this.getAttachments();
        try {
            attachments.getAttachment((String)null);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            attachments.getAttachment(null, String.class);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            attachments.getAttachment("name", null);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            attachments.getAttachment((Class)null);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
    }

    public void testIsAttachmentPresentErrors() throws Exception {
        Attachments attachments = this.getAttachments();
        try {
            attachments.isAttachmentPresent((String)null);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            attachments.isAttachmentPresent(null, String.class);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            attachments.isAttachmentPresent("name", null);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
        try {
            attachments.isAttachmentPresent((Class)null);
            AttachmentsTest.fail((String)"Should not be here!");
        }
        catch (Throwable t) {
            AttachmentsTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
    }

    public void testSerialization() throws Exception {
        Attachments attachments = this.getAttachments();
        this.serializeDeserialize((Serializable)attachments, Attachments.class);
        MutableAttachments mutable = this.getMutable();
        this.serializeDeserialize((Serializable)mutable, MutableAttachments.class);
        mutable.addAttachment(String.class, (Object)"Hello");
        mutable = (MutableAttachments)this.serializeDeserialize((Serializable)mutable, MutableAttachments.class);
        AttachmentsTest.assertEquals((String)"Hello", (String)((String)mutable.getAttachment(String.class)));
    }
}

