/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.client.spi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.attachments.AttachmentsFactory;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.spi.structure.StructureMetaDataFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentFactory {
    public ContextInfo addContext(PredeterminedManagedObjectAttachments context, String path) {
        StructureMetaData structure = DeploymentFactory.assureStructure(context);
        ContextInfo result = StructureMetaDataFactory.createContextInfo((String)path);
        structure.addContext(result);
        return result;
    }

    public ContextInfo addContext(PredeterminedManagedObjectAttachments context, String path, List<ClassPathEntry> classPath) {
        StructureMetaData structure = DeploymentFactory.assureStructure(context);
        ContextInfo result = StructureMetaDataFactory.createContextInfo((String)path, classPath);
        structure.addContext(result);
        return result;
    }

    public ContextInfo addContext(PredeterminedManagedObjectAttachments context, String path, String metaDataPath, List<ClassPathEntry> classPath) {
        StructureMetaData structure = DeploymentFactory.assureStructure(context);
        ContextInfo result = StructureMetaDataFactory.createContextInfo((String)path, (String)metaDataPath, classPath);
        structure.addContext(result);
        return result;
    }

    public ContextInfo addContext(PredeterminedManagedObjectAttachments context, String path, List<String> metaDataPath, List<ClassPathEntry> classPath) {
        StructureMetaData structure = DeploymentFactory.assureStructure(context);
        ContextInfo result = StructureMetaDataFactory.createContextInfo((String)path, metaDataPath, classPath);
        structure.addContext(result);
        return result;
    }

    public static ClassPathEntry createClassPathEntry(String path) {
        return StructureMetaDataFactory.createClassPathEntry((String)path, null);
    }

    public static List<ClassPathEntry> createClassPath(String path) {
        return Collections.singletonList(DeploymentFactory.createClassPathEntry(path));
    }

    public static ClassPathEntry createClassPathEntry(String path, String suffixes) {
        return StructureMetaDataFactory.createClassPathEntry((String)path, (String)suffixes);
    }

    public static List<ClassPathEntry> createClassPath(String path, String suffixes) {
        return Collections.singletonList(DeploymentFactory.createClassPathEntry(path, suffixes));
    }

    protected static StructureMetaData assureStructure(PredeterminedManagedObjectAttachments context) {
        MutableAttachments mutable;
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        Attachments attachments = context.getPredeterminedManagedObjects();
        if (attachments == null) {
            mutable = AttachmentsFactory.createMutableAttachments();
            context.setPredeterminedManagedObjects((Attachments)mutable);
        } else if (!(attachments instanceof MutableAttachments)) {
            mutable = AttachmentsFactory.createMutableAttachments();
            Map map = attachments.getAttachments();
            if (map != null) {
                mutable.setAttachments(map);
            }
            context.setPredeterminedManagedObjects((Attachments)mutable);
        } else {
            mutable = (MutableAttachments)attachments;
        }
        StructureMetaData structure = (StructureMetaData)mutable.getAttachment(StructureMetaData.class);
        if (structure == null) {
            structure = StructureMetaDataFactory.createStructureMetaData();
            mutable.addAttachment(StructureMetaData.class, (Object)structure);
        }
        return structure;
    }
}

