/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.wildfly.cluster.jms;

import java.io.Serializable;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.spi.PartitionWorker;
import org.jberet.wildfly.cluster.jms._private.ClusterJmsLogger;

public class JmsPartitionWorker
implements PartitionWorker {
    private final ConnectionFactory connectionFactory;
    private final Queue partitionQueue;
    private final JMSContext stopRequestTopicContext;

    public JmsPartitionWorker(ConnectionFactory connectionFactory, Queue partitionQueue, JMSContext stopRequestTopicContext) {
        this.connectionFactory = connectionFactory;
        this.partitionQueue = partitionQueue;
        this.stopRequestTopicContext = stopRequestTopicContext;
    }

    public void reportData(Serializable data, AbstractStepExecution partitionExecution) throws Exception {
        long stepExecutionId = partitionExecution.getStepExecutionId();
        try (JMSContext partitionQueueContext = this.connectionFactory.createContext();){
            ObjectMessage message = partitionQueueContext.createObjectMessage(data);
            message.setStringProperty("type", "R");
            message.setLongProperty("stepExecutionId", stepExecutionId);
            partitionQueueContext.createProducer().send((Destination)this.partitionQueue, (Message)message);
        }
        ClusterJmsLogger.LOGGER.sendCollectorData(stepExecutionId, ((PartitionExecutionImpl)partitionExecution).getPartitionId(), data);
    }

    public void partitionDone(AbstractStepExecution partitionExecution) throws Exception {
        this.reportData((Serializable)partitionExecution, partitionExecution);
        this.stopRequestTopicContext.close();
    }
}

