/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.wildfly.cluster.jms;

import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jberet.job.model.Chunk;
import org.jberet.job.model.Step;
import org.jberet.operations.AbstractJobOperator;
import org.jberet.operations.DelegatingJobOperator;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.runtime.context.JobContextImpl;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.runner.BatchletRunner;
import org.jberet.runtime.runner.ChunkRunner;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.JobTask;
import org.jberet.spi.PartitionInfo;
import org.jberet.spi.PartitionWorker;
import org.jberet.wildfly.cluster.jms.JmsPartitionWorker;
import org.jberet.wildfly.cluster.jms._private.ClusterJmsLogger;
import org.jberet.wildfly.cluster.jms._private.ClusterJmsMessages;

public final class JmsPartitionResource {
    public static final String CONNECTION_FACTORY = "jms/connectionFactory";
    public static final String PARTITION_QUEUE = "jms/partitionQueue";
    public static final String STOP_REQUEST_TOPIC = "jms/stopRequestTopic";
    public static final String MESSAGE_JOB_EXECUTION_ID_KEY = "jobExecutionId";
    public static final String MESSAGE_STEP_EXECUTION_ID_KEY = "stepExecutionId";
    public static final String MESSAGE_TYPE_KEY = "type";
    public static final String MESSAGE_TYPE_PARTITION = "P";
    public static final String MESSAGE_TYPE_RESULT = "R";
    private final Context namingContext;

    public JmsPartitionResource() {
        try {
            this.namingContext = new InitialContext();
        }
        catch (NamingException e) {
            throw ClusterJmsMessages.MESSAGES.failedToNewNamingContext(e);
        }
    }

    public <T> T lookUp(String name) {
        String s = "java:comp/env/" + name;
        try {
            Object result = this.namingContext.lookup(s);
            ClusterJmsLogger.LOGGER.lookupResource(s, result);
            return (T)result;
        }
        catch (NamingException e) {
            throw ClusterJmsMessages.MESSAGES.failedToLookup(e, s);
        }
    }

    public Queue getPartitionQueue() {
        return (Queue)this.lookUp(PARTITION_QUEUE);
    }

    public Topic getStopRequestTopic() {
        return (Topic)this.lookUp(STOP_REQUEST_TOPIC);
    }

    public ConnectionFactory getConnectionFactory() {
        return (ConnectionFactory)this.lookUp(CONNECTION_FACTORY);
    }

    public static String getMessageSelector(String messageType, long stepExecutionId) {
        return stepExecutionId > 0L ? String.format("%s = '%s' AND %s = %s", MESSAGE_TYPE_KEY, messageType, MESSAGE_STEP_EXECUTION_ID_KEY, stepExecutionId) : String.format("%s = '%s'", MESSAGE_TYPE_KEY, messageType);
    }

    public static String getMessageSelector(long jobExecutionId) {
        return String.format("%s = %s", MESSAGE_JOB_EXECUTION_ID_KEY, jobExecutionId);
    }

    public void close() {
        if (this.namingContext != null) {
            try {
                this.namingContext.close();
            }
            catch (NamingException e) {
                ClusterJmsLogger.LOGGER.problemClosingResource(e);
            }
        }
    }

    public static void closeJmsContext(JMSContext jmsContext) {
        if (jmsContext != null) {
            try {
                jmsContext.close();
            }
            catch (Exception e) {
                ClusterJmsLogger.LOGGER.problemClosingResource(e);
            }
        }
    }

    public static AbstractJobOperator getJobOperator() {
        JobOperator delegate;
        JobOperator operator = BatchRuntime.getJobOperator();
        AbstractJobOperator jobOperator = null;
        if (operator instanceof DelegatingJobOperator && (delegate = ((DelegatingJobOperator)operator).getDelegate()) instanceof AbstractJobOperator) {
            jobOperator = (AbstractJobOperator)delegate;
        }
        if (jobOperator == null) {
            throw ClusterJmsMessages.MESSAGES.failedToGetJobOperator();
        }
        return jobOperator;
    }

    public static void runPartition(PartitionInfo partitionInfo, BatchEnvironment batchEnvironment, JobRepository jobRepository, ArtifactFactory artifactFactory, ConnectionFactory connectionFactory, Queue partitionQueue, Topic stopRequestTopic) {
        JobExecutionImpl jobExecution = partitionInfo.getJobExecution();
        Step step = partitionInfo.getStep();
        PartitionExecutionImpl partitionExecution = partitionInfo.getPartitionExecution();
        long jobExecutionId = jobExecution.getExecutionId();
        String stopTopicSelector = JmsPartitionResource.getMessageSelector(jobExecutionId);
        JMSContext stopRequestTopicContext = connectionFactory.createContext();
        JMSConsumer stopRequestConsumer = stopRequestTopicContext.createConsumer((Destination)stopRequestTopic, stopTopicSelector);
        stopRequestConsumer.setMessageListener(stopMessage -> {
            ClusterJmsLogger.LOGGER.receivedStopRequest(jobExecutionId, step.getId(), partitionExecution.getStepExecutionId(), partitionExecution.getPartitionId());
            jobExecution.stop();
        });
        ClusterJmsLogger.LOGGER.receivedPartitionInfo(partitionInfo);
        JobContextImpl jobContext = new JobContextImpl(jobExecution, null, artifactFactory, jobRepository, batchEnvironment);
        JmsPartitionWorker partitionWorker = new JmsPartitionWorker(connectionFactory, partitionQueue, stopRequestTopicContext);
        AbstractContext[] outerContext = new AbstractContext[]{jobContext};
        StepContextImpl stepContext = new StepContextImpl(step, (AbstractStepExecution)partitionExecution, outerContext);
        Chunk chunk = step.getChunk();
        Object runner = chunk == null ? new BatchletRunner(stepContext, null, step.getBatchlet(), (PartitionWorker)partitionWorker) : new ChunkRunner(stepContext, null, chunk, null, (PartitionWorker)partitionWorker);
        batchEnvironment.submitTask((JobTask)runner);
    }
}

