/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.mojo;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.jbehave.core.InjectableEmbedder;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.embedder.EmbedderClassLoader;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.embedder.UnmodifiableEmbedderControls;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.io.StoryFinder;
import org.jbehave.core.junit.AnnotatedEmbedderRunner;
import org.jbehave.core.model.Meta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEmbedderMojo
extends AbstractMojo {
    static final String TEST_SCOPE = "test";
    String sourceDirectory;
    String testSourceDirectory;
    String scope;
    List<String> includes;
    List<String> excludes;
    List<String> compileClasspathElements;
    List<String> testClasspathElements;
    boolean skip = false;
    boolean batch = false;
    boolean ignoreFailureInStories = false;
    boolean ignoreFailureInView = false;
    boolean generateViewAfterStories = true;
    String embedderClass = Embedder.class.getName();
    String injectableEmbedderClass;
    protected String annotatedEmbedderRunnerClass = AnnotatedEmbedderRunner.class.getName();
    String storyFinderClass = StoryFinder.class.getName();
    List<String> metaFilters = Arrays.asList(new Object[0]);

    boolean isTestScope() {
        return TEST_SCOPE.equals(this.scope);
    }

    String searchDirectory() {
        if (this.isTestScope()) {
            return this.testSourceDirectory;
        }
        return this.sourceDirectory;
    }

    protected EmbedderClassLoader createClassLoader() {
        return new EmbedderClassLoader(this.classpathElements());
    }

    List<String> classpathElements() {
        List<String> classpathElements = this.compileClasspathElements;
        if (this.isTestScope()) {
            classpathElements = this.testClasspathElements;
        }
        return classpathElements;
    }

    protected List<String> storyPaths() {
        this.getLog().debug((CharSequence)("Searching for story paths including " + this.includes + " and excluding " + this.excludes));
        List storyPaths = this.newStoryFinder().findPaths(this.searchDirectory(), this.includes, this.excludes);
        this.getLog().info((CharSequence)("Found story paths: " + storyPaths));
        return storyPaths;
    }

    protected List<String> classNames() {
        this.getLog().debug((CharSequence)("Searching for class names including " + this.includes + " and excluding " + this.excludes));
        List classNames = this.newStoryFinder().findClassNames(this.searchDirectory(), this.includes, this.excludes);
        this.getLog().info((CharSequence)("Found class names: " + classNames));
        return classNames;
    }

    protected StoryFinder newStoryFinder() {
        return (StoryFinder)this.createClassLoader().newInstance(StoryFinder.class, this.storyFinderClass);
    }

    protected Embedder newEmbedder() {
        Embedder embedder = null;
        EmbedderClassLoader classLoader = this.createClassLoader();
        embedder = this.injectableEmbedderClass != null ? ((InjectableEmbedder)classLoader.newInstance(InjectableEmbedder.class, this.injectableEmbedderClass)).injectedEmbedder() : (Embedder)classLoader.newInstance(Embedder.class, this.embedderClass);
        EmbedderMonitor embedderMonitor = this.embedderMonitor();
        embedder.useEmbedderMonitor(embedderMonitor);
        if (!this.metaFilters.isEmpty()) {
            embedder.useMetaFilters(this.metaFilters);
        }
        embedder.useEmbedderControls(this.embedderControls());
        return embedder;
    }

    protected EmbedderMonitor embedderMonitor() {
        return new MavenEmbedderMonitor();
    }

    protected EmbedderControls embedderControls() {
        return new UnmodifiableEmbedderControls(new EmbedderControls().doBatch(this.batch).doSkip(this.skip).doGenerateViewAfterStories(this.generateViewAfterStories).doIgnoreFailureInStories(this.ignoreFailureInStories).doIgnoreFailureInView(this.ignoreFailureInView));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MavenEmbedderMonitor
    implements EmbedderMonitor {
        protected MavenEmbedderMonitor() {
        }

        public void batchFailed(BatchFailures failures) {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)("Failed to run batch " + failures));
        }

        public void embeddableFailed(String name, Throwable cause) {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)("Failed to run embeddable " + name), cause);
        }

        public void embeddablesSkipped(List<String> classNames) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Skipped embeddables " + classNames));
        }

        public void metaNotAllowed(Meta meta, MetaFilter filter) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)(meta + " not allowed by filter '" + filter.asString() + "'"));
        }

        public void runningEmbeddable(String name) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Running embeddable " + name));
        }

        public void runningStory(String path) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Running story " + path));
        }

        public void storiesSkipped(List<String> storyPaths) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Skipped stories " + storyPaths));
        }

        public void storyFailed(String path, Throwable cause) {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)("Failed to run story " + path), cause);
        }

        public void annotatedInstanceNotOfType(Object annotatedInstance, Class<?> type) {
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)("Annotated instance " + annotatedInstance + " not of type " + type));
        }

        public void generatingStoriesView(File outputDirectory, List<String> formats, Properties viewProperties) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Generating stories view in '" + outputDirectory + "' using formats '" + formats + "'" + " and view properties '" + viewProperties + "'"));
        }

        public void storiesViewGenerationFailed(File outputDirectory, List<String> formats, Properties viewProperties, Throwable cause) {
            String message = "Failed to generate stories view in outputDirectory " + outputDirectory + " using formats " + formats + " and view properties '" + viewProperties + "'";
            AbstractEmbedderMojo.this.getLog().warn((CharSequence)message, cause);
        }

        public void storiesViewGenerated(int stories, int scenarios, int failedScenarios) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Stories view generated with " + stories + " stories containing " + scenarios + " scenarios (of which  " + failedScenarios + " failed)"));
        }

        public void storiesViewNotGenerated() {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)"Stories view not generated");
        }

        public void mappingStory(String storyPath, List<String> metaFilters) {
            AbstractEmbedderMojo.this.getLog().info((CharSequence)("Mapping story " + storyPath + " with meta filters " + metaFilters));
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

