/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps.guice;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.AbstractStepsFactory;
import org.jbehave.core.steps.InjectableStepsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceStepsFactory
extends AbstractStepsFactory {
    private final Injector injector;

    public GuiceStepsFactory(Configuration configuration, Injector injector) {
        super(configuration);
        this.injector = injector;
    }

    protected List<Class<?>> stepsTypes() {
        ArrayList types = new ArrayList();
        this.addTypes(this.injector, types);
        return types;
    }

    private void addTypes(Injector injector, List<Class<?>> types) {
        for (Binding binding : injector.getBindings().values()) {
            Key key = binding.getKey();
            Type type = key.getTypeLiteral().getType();
            if (!this.hasAnnotatedMethods(type)) continue;
            types.add((Class)type);
        }
        if (injector.getParent() != null) {
            this.addTypes(injector.getParent(), types);
        }
    }

    public Object createInstanceOfType(Class<?> type) {
        ArrayList<Object> instances = new ArrayList<Object>();
        this.addInstances(this.injector, type, instances);
        if (!instances.isEmpty()) {
            return instances.iterator().next();
        }
        return new AbstractStepsFactory.StepsInstanceNotFound(type, (InjectableStepsFactory)this);
    }

    private void addInstances(Injector injector, Class<?> type, List<Object> instances) {
        for (Binding binding : injector.getBindings().values()) {
            Key key = binding.getKey();
            if (!type.equals(key.getTypeLiteral().getType())) continue;
            instances.add(injector.getInstance(key));
        }
        if (injector.getParent() != null) {
            this.addInstances(injector.getParent(), type, instances);
        }
    }
}

