/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps.guice;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.AbstractStepsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceStepsFactory
extends AbstractStepsFactory {
    private final Injector injector;

    public GuiceStepsFactory(Configuration configuration, Injector injector) {
        super(configuration);
        this.injector = injector;
    }

    protected List<Object> stepsInstances() {
        ArrayList<Object> steps = new ArrayList<Object>();
        this.addInstances(this.injector, steps);
        return steps;
    }

    private void addInstances(Injector injector, List<Object> steps) {
        for (Binding binding : injector.getBindings().values()) {
            Key key = binding.getKey();
            if (!this.hasAnnotatedMethods(key.getTypeLiteral().getType())) continue;
            steps.add(injector.getInstance(key));
        }
        if (injector.getParent() != null) {
            this.addInstances(injector.getParent(), steps);
        }
    }
}

