/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps.guice;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.Steps;
import org.jbehave.core.steps.StepsConfiguration;

public class GuiceStepsFactory {
    private final StepsConfiguration configuration;
    private final Injector parent;

    public GuiceStepsFactory(StepsConfiguration configuration, Injector parent) {
        this.configuration = configuration;
        this.parent = parent;
    }

    public CandidateSteps[] createCandidateSteps() {
        ArrayList<Steps> steps = new ArrayList<Steps>();
        for (Binding binding : this.parent.getBindings().values()) {
            Key key = binding.getKey();
            if (!this.containsScenarioAnnotations(key.getTypeLiteral().getType())) continue;
            steps.add(new Steps(this.configuration, this.parent.getInstance(key)));
        }
        return steps.toArray(new CandidateSteps[steps.size()]);
    }

    private boolean containsScenarioAnnotations(Type type) {
        if (type instanceof Class) {
            for (Method method : ((Class)type).getMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    if (!annotation.annotationType().getName().startsWith("org.jbehave.core.annotations")) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

