/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.configuration.groovy.BytecodeGroovyClassLoader;
import org.jbehave.core.configuration.groovy.GroovyResourceFinder;

public class GroovyContext {
    private final GroovyClassLoader classLoader;
    private final List<String> resources;
    private List<Object> instances;

    public GroovyContext() {
        this(new GroovyResourceFinder());
    }

    public GroovyContext(GroovyResourceFinder resourceFinder) {
        this(resourceFinder.findResources());
    }

    public GroovyContext(List<String> resources) {
        this((GroovyClassLoader)new BytecodeGroovyClassLoader(), resources);
    }

    public GroovyContext(GroovyClassLoader classLoader, GroovyResourceFinder resourceFinder) {
        this(classLoader, resourceFinder.findResources());
    }

    public GroovyContext(GroovyClassLoader classLoader, List<String> resources) {
        this.classLoader = classLoader;
        this.resources = resources;
        this.instances = this.createGroovyInstances();
    }

    public List<Object> getInstances() {
        return this.instances;
    }

    public <T> T getInstanceOfType(Class<T> type) {
        for (Object instance : this.instances) {
            if (!type.isAssignableFrom(instance.getClass())) continue;
            return (T)instance;
        }
        throw new GroovyInstanceNotFound(type);
    }

    public Object newInstance(String resource) {
        try {
            String name = resource.startsWith("/") ? resource : "/" + resource;
            File file = new File(this.getClass().getResource(name).toURI());
            return this.newInstance(this.classLoader.parseClass(new GroovyCodeSource(file), true));
        }
        catch (Exception e) {
            throw new GroovyClassInstantiationFailed(this.classLoader, resource, e);
        }
    }

    public Object newInstance(Class<?> parsedClass) throws Exception {
        return parsedClass.newInstance();
    }

    private List<Object> createGroovyInstances() {
        ArrayList<Object> instances = new ArrayList<Object>();
        for (String resource : this.resources) {
            instances.add(this.newInstance(resource));
        }
        return instances;
    }

    public static final class GroovyInstanceNotFound
    extends RuntimeException {
        public GroovyInstanceNotFound(Class<?> type) {
            super(type.toString());
        }
    }

    public static final class GroovyClassInstantiationFailed
    extends RuntimeException {
        public GroovyClassInstantiationFailed(GroovyClassLoader classLoader, String resource, Exception cause) {
            super(MessageFormat.format("Failed to create new instance of class from resource {0} using Groovy class loader {1}", resource, classLoader), cause);
        }
    }
}

