/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration.groovy;

import groovy.lang.GroovyClassLoader;
import groovyjarjarasm.asm.ClassWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class BytecodeGroovyClassLoader
extends GroovyClassLoader {
    private Map<String, byte[]> classBytes = new HashMap<String, byte[]>();

    public InputStream getResourceAsStream(String name) {
        if (this.classBytes.containsKey(name)) {
            return new ByteArrayInputStream(this.classBytes.get(name));
        }
        return super.getResourceAsStream(name);
    }

    protected GroovyClassLoader.ClassCollector createCollector(CompilationUnit unit, SourceUnit su) {
        GroovyClassLoader.InnerLoader loader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader.InnerLoader>(){

            @Override
            public GroovyClassLoader.InnerLoader run() {
                return new GroovyClassLoader.InnerLoader((GroovyClassLoader)BytecodeGroovyClassLoader.this);
            }
        });
        return new BytecodeClassCollector(this.classBytes, loader, unit, su);
    }

    public static class BytecodeClassCollector
    extends GroovyClassLoader.ClassCollector {
        private final Map<String, byte[]> classBytes;

        public BytecodeClassCollector(Map<String, byte[]> classBytes, GroovyClassLoader.InnerLoader loader, CompilationUnit unit, SourceUnit su) {
            super(loader, unit, su);
            this.classBytes = classBytes;
        }

        protected Class<?> onClassNode(ClassWriter classWriter, ClassNode classNode) {
            this.classBytes.put(classNode.getName() + ".class", classWriter.toByteArray());
            return super.onClassNode(classWriter, classNode);
        }
    }
}

