/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.boot.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.util.Optional;
import org.javers.common.collections.Lists;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.spring.boot.mongo.JaversMongoProperties;

class JaversDedicatedMongoFactory {
    private static String DEFAULT_HOST = "localhost";
    private static int DEFAULT_PORT = 27017;

    JaversDedicatedMongoFactory() {
    }

    static MongoDatabase createMongoDatabase(JaversMongoProperties properties, Optional<MongoClientSettings> mongoClientSettings) {
        if (properties.getMongodb().getUri() != null) {
            ConnectionString connectionString = new ConnectionString(properties.getMongodb().getUri());
            MongoClient mongoClient = MongoClients.create((ConnectionString)connectionString);
            return mongoClient.getDatabase(connectionString.getDatabase());
        }
        if (properties.getMongodb().getHost() != null) {
            String host = properties.getMongodb().getHost() == null ? DEFAULT_HOST : properties.getMongodb().getHost();
            int port = properties.getMongodb().getPort() == null ? DEFAULT_PORT : properties.getMongodb().getPort();
            MongoClientSettings.Builder clientBuilder = mongoClientSettings.map(s -> MongoClientSettings.builder((MongoClientSettings)s)).orElse(MongoClientSettings.builder());
            clientBuilder.applyToClusterSettings(b -> b.hosts(Lists.asList((Object[])new ServerAddress[]{new ServerAddress(host, port)})));
            MongoCredential credentials = JaversDedicatedMongoFactory.getCredentials(properties);
            if (credentials != null) {
                clientBuilder.credential(credentials);
            }
            MongoClient mongoClient = MongoClients.create((MongoClientSettings)clientBuilder.build());
            return mongoClient.getDatabase(properties.getMongodb().getDatabase());
        }
        throw new JaversException(JaversExceptionCode.MALFORMED_JAVERS_MONGODB_PROPERTIES, new Object[0]);
    }

    private static boolean hasCustomCredentials(JaversMongoProperties properties) {
        return properties.getMongodb().getUsername() != null && properties.getMongodb().getPassword() != null;
    }

    private static MongoCredential getCredentials(JaversMongoProperties properties) {
        if (!JaversDedicatedMongoFactory.hasCustomCredentials(properties)) {
            return null;
        }
        String username = properties.getMongodb().getUsername();
        String database = properties.getMongodb().getAuthenticationDatabase() != null ? properties.getMongodb().getAuthenticationDatabase() : properties.getMongodb().getDatabase();
        char[] password = properties.getMongodb().getPassword();
        return MongoCredential.createCredential((String)username, (String)database, (char[])password);
    }
}

