/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.mongo;

import org.javers.common.string.Strings;
import org.javers.repository.mongo.MongoDialect;
import org.javers.repository.mongo.MongoRepositoryConfiguration;

public class MongoRepositoryConfigurationBuilder {
    private String snapshotCollectionName;
    private String headCollectionName;
    private Integer cacheSize;
    private MongoDialect dialect;

    public static MongoRepositoryConfigurationBuilder mongoRepositoryConfiguration() {
        return new MongoRepositoryConfigurationBuilder();
    }

    MongoRepositoryConfigurationBuilder() {
    }

    public MongoRepositoryConfigurationBuilder withSnapshotCollectionName(String snapshotCollectionName) {
        if (Strings.isNonEmpty((String)snapshotCollectionName)) {
            this.snapshotCollectionName = snapshotCollectionName;
        }
        return this;
    }

    public MongoRepositoryConfigurationBuilder withCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public MongoRepositoryConfigurationBuilder withDialect(MongoDialect dialect) {
        this.dialect = dialect;
        return this;
    }

    public MongoRepositoryConfigurationBuilder withHeadCollectionName(String headCollectionName) {
        this.headCollectionName = headCollectionName;
        return this;
    }

    public MongoRepositoryConfiguration build() {
        return new MongoRepositoryConfiguration(this.snapshotCollectionName, this.headCollectionName, this.cacheSize, this.dialect);
    }
}

