/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.mongo;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;

class DocumentConverter {
    DocumentConverter() {
    }

    static Document toDocument(JsonObject jsonObject) {
        Document document = new Document();
        for (Map.Entry e : jsonObject.entrySet()) {
            document.append((String)e.getKey(), DocumentConverter.fromJsonElement((JsonElement)e.getValue()));
        }
        return document;
    }

    static JsonElement fromDocument(Document document) {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry e : document.entrySet()) {
            jsonObject.add((String)e.getKey(), DocumentConverter.createJsonElement(e.getValue()));
        }
        return jsonObject;
    }

    private static Object fromJsonElement(JsonElement jsonElement) {
        if (jsonElement == JsonNull.INSTANCE) {
            return null;
        }
        if (jsonElement instanceof JsonObject) {
            return DocumentConverter.toDocument((JsonObject)jsonElement);
        }
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
            if (jsonPrimitive.isString()) {
                return jsonElement.getAsString();
            }
            if (jsonPrimitive.isNumber() && jsonElement.getAsNumber() instanceof BigDecimal) {
                BigDecimal value = (BigDecimal)jsonElement.getAsNumber();
                try {
                    return value.longValueExact();
                }
                catch (ArithmeticException e) {
                    return value.doubleValue();
                }
            }
            if (jsonPrimitive.isNumber()) {
                return jsonElement.getAsNumber();
            }
            if (jsonPrimitive.isBoolean()) {
                return jsonElement.getAsBoolean();
            }
        }
        if (jsonElement instanceof JsonArray) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement e : (JsonArray)jsonElement) {
                list.add(DocumentConverter.fromJsonElement(e));
            }
            return list;
        }
        throw new IllegalArgumentException("unsupported JsonElement type - " + jsonElement.getClass().getSimpleName());
    }

    private static JsonElement createJsonElement(Object dbObject) {
        if (dbObject == null) {
            return JsonNull.INSTANCE;
        }
        if (dbObject instanceof Document) {
            return DocumentConverter.fromDocument((Document)dbObject);
        }
        if (dbObject instanceof String) {
            return new JsonPrimitive((String)dbObject);
        }
        if (dbObject instanceof Number) {
            return new JsonPrimitive((Number)dbObject);
        }
        if (dbObject instanceof Boolean) {
            return new JsonPrimitive((Boolean)dbObject);
        }
        if (dbObject instanceof List) {
            JsonArray array = new JsonArray();
            for (Object e : (List)dbObject) {
                array.add(DocumentConverter.createJsonElement(e));
            }
            return array;
        }
        if (dbObject instanceof ObjectId) {
            JsonObject id = new JsonObject();
            id.addProperty("$oid", dbObject.toString());
            return id;
        }
        throw new IllegalArgumentException("unsupported dbObject type - " + dbObject.getClass().getSimpleName());
    }
}

