/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jdbc.schema;

import java.io.Closeable;
import org.javers.repository.jdbc.schema.FixedSchemaFactory;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.schema.SchemaInspector;
import org.polyjdbc.core.schema.SchemaManager;
import org.polyjdbc.core.schema.SchemaManagerFactory;
import org.polyjdbc.core.schema.model.Schema;
import org.polyjdbc.core.transaction.TransactionManager;
import org.polyjdbc.core.util.TheCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversSchemaManager {
    private static final Logger logger = LoggerFactory.getLogger(JaversSchemaManager.class);
    private Schema schema;
    private FixedSchemaFactory schemaFactory;
    private TransactionManager transactionManager;

    public JaversSchemaManager(Dialect dialect, FixedSchemaFactory schemaFactory, TransactionManager transactionManager) {
        this.schema = schemaFactory.getSchema(dialect);
        this.transactionManager = transactionManager;
        this.schemaFactory = schemaFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchemaIfNotExists() {
        SchemaInspector schemaInspector;
        SchemaManager schemaManager;
        SchemaManagerFactory schemaManagerFactory;
        block3: {
            schemaManagerFactory = new SchemaManagerFactory(this.transactionManager);
            schemaManager = null;
            schemaInspector = null;
            try {
                schemaInspector = schemaManagerFactory.createInspector();
                if (!this.schemaExists(schemaInspector)) break block3;
                logger.info("javers schema exists");
            }
            catch (Throwable throwable) {
                TheCloser.close((Closeable[])new Closeable[]{schemaManager, schemaInspector});
                throw throwable;
            }
            TheCloser.close((Closeable[])new Closeable[]{schemaManager, schemaInspector});
            return;
        }
        logger.info("creating javers schema ...");
        schemaManager = schemaManagerFactory.createManager();
        schemaManager.create(this.schema);
        TheCloser.close((Closeable[])new Closeable[]{schemaManager, schemaInspector});
    }

    public boolean schemaExists(SchemaInspector schemaInspector) {
        return schemaInspector.relationExists(this.schemaFactory.getDiffTableName());
    }

    public void dropSchema() {
    }
}

