/*
 * Decompiled with CFR 0.152.
 */
package org.javastack.fontmetrics;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFontMetrics {
    public static final String FONT_NAME = "Verdana";
    public static final int FONT_SIZE = 110;
    private static final String FILE_RESOURCE_INDEX_CACHE = "/fontmetrics.bin";
    private static final Logger log = LoggerFactory.getLogger(SimpleFontMetrics.class);
    private static final SimpleFontMetrics INSTANCE = new SimpleFontMetrics();
    private FontMetricsHelper metrics = SystemFontMetrics.getDefaultInstance();

    public static SimpleFontMetrics getInstance() {
        return INSTANCE;
    }

    private SimpleFontMetrics() {
        if (this.metrics == null) {
            this.metrics = IndexedFontMetrics.getDefaultInstance();
        }
    }

    public int widthOf(String input) {
        return this.metrics.widthOf(input);
    }

    public byte widthOf(int codePoint) {
        return this.metrics.widthOf(codePoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<List<Integer>> loadRanges(String name) throws IOException {
        List<List<Integer>> list;
        URL url = SimpleFontMetrics.class.getResource("/ranges." + name + ".txt");
        InputStream is = null;
        URLConnection conn = null;
        try {
            conn = url.openConnection();
            conn.setDoOutput(false);
            conn.setUseCaches(true);
            conn.connect();
            is = conn.getInputStream();
            int size = conn.getContentLength();
            byte[] buf = new byte[size];
            is.read(buf);
            list = SimpleFontMetrics.processRawRanges(new String(buf));
        }
        catch (Throwable throwable) {
            SimpleFontMetrics.closeSilent(is);
            throw throwable;
        }
        SimpleFontMetrics.closeSilent(is);
        return list;
    }

    private static final List<List<Integer>> processRawRanges(String rawRanges) {
        Pattern regexp = Pattern.compile("^([^ ]+) . ([^ ]+) {3}");
        String[] lines = rawRanges.split("\n");
        ArrayList<List<Integer>> ranges = new ArrayList<List<Integer>>(lines.length);
        for (String line : lines) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            Matcher m = regexp.matcher(line);
            if (m.find()) {
                List<Integer> range = Collections.unmodifiableList(Arrays.asList(Integer.valueOf(m.group(1), 16), Integer.valueOf(m.group(2), 16)));
                ranges.add(range);
                continue;
            }
            throw new RuntimeException("Invalid line: " + line);
        }
        ranges.sort(new Comparator<List<Integer>>(){

            @Override
            public int compare(List<Integer> a, List<Integer> b) {
                return Integer.compare(a.get(0), b.get(0));
            }
        });
        return Collections.unmodifiableList(ranges);
    }

    private static final void closeSilent(Closeable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Throwable {
        long begin = System.currentTimeMillis();
        String TEST_FILE = new File("/tmp/", FILE_RESOURCE_INDEX_CACHE).getAbsolutePath();
        System.out.println("TestFile=" + TEST_FILE);
        SystemFontMetrics sys = SystemFontMetrics.getDefaultInstance();
        sys.exportFile(SimpleFontMetrics.loadRanges("short"), TEST_FILE);
        IndexedFontMetrics idx = IndexedFontMetrics.importFile(TEST_FILE);
        System.out.println("Export/Import Time=" + (System.currentTimeMillis() - begin));
        System.out.println("<LF> ==> " + sys.widthOf(10) + " => " + idx.widthOf(10));
        System.out.println("<SPACE> ==> " + sys.widthOf(32) + " => " + idx.widthOf(32));
        System.out.println("A ==> " + sys.widthOf(65) + " => " + idx.widthOf(65));
        System.out.println("<~> ==> " + sys.widthOf(126) + " => " + idx.widthOf(126));
        System.out.println("<127> ==> " + sys.widthOf(127) + " => " + idx.widthOf(127));
        System.out.println("<128> ==> " + sys.widthOf(128) + " => " + idx.widthOf(128));
        System.out.println("<NB> ==> " + sys.widthOf(160) + " => " + idx.widthOf(160));
        System.out.println("<SHY> ==> " + sys.widthOf(173) + " => " + idx.widthOf(173));
        System.out.println("<255> ==> " + sys.widthOf(255) + " => " + idx.widthOf(255));
        System.out.println("<7680> ==> " + sys.widthOf(7680) + " => " + idx.widthOf(7680));
        System.out.println("<7821> ==> " + sys.widthOf(7821) + " => " + idx.widthOf(7821));
        System.out.println("<7935> ==> " + sys.widthOf(7935) + " => " + idx.widthOf(7935));
        String hello = "Hello World!";
        System.out.println("Hello World! ==> " + sys.widthOf("Hello World!") + " => " + idx.widthOf("Hello World!"));
        begin = System.currentTimeMillis();
        int i = 0;
        while ((double)i < 1.0E7) {
            sys.widthOf("Hello World!");
            ++i;
        }
        System.out.println("SystemFontMetrics Time=" + (System.currentTimeMillis() - begin));
        begin = System.currentTimeMillis();
        i = 0;
        while ((double)i < 1.0E7) {
            idx.widthOf("Hello World!");
            ++i;
        }
        System.out.println("IndexedFontMetrics Time=" + (System.currentTimeMillis() - begin));
    }

    public static class IndexedFontMetrics
    implements FontMetricsHelper {
        private static IndexedFontMetrics INSTANCE = null;
        private final int[] ranges;
        private final byte[] widths;

        public static IndexedFontMetrics getDefaultInstance() {
            return INSTANCE;
        }

        private IndexedFontMetrics(int[] ranges, byte[] widths) {
            this.ranges = ranges;
            this.widths = widths;
        }

        private int findOffsetByRangeScan(int codePoint) {
            int offset = 0;
            for (int i = 0; i < this.ranges.length; i += 2) {
                int lower = this.ranges[i];
                int upper = this.ranges[i + 1];
                if (codePoint >= lower && codePoint <= upper) {
                    return offset + (codePoint - lower);
                }
                offset += upper - lower + 1;
            }
            return -1;
        }

        @Override
        public int widthOf(String input) {
            int width = 0;
            int len = input.length();
            for (int i = 0; i < len; ++i) {
                int codePoint = input.codePointAt(i);
                byte w = this.widthOf(codePoint);
                width += w;
            }
            return width;
        }

        @Override
        public byte widthOf(int codePoint) {
            if (codePoint < 32) {
                return 0;
            }
            int offset = this.findOffsetByRangeScan(codePoint);
            if (offset < 0 || offset >= this.widths.length) {
                return 110;
            }
            return this.widths[offset];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static IndexedFontMetrics importFile(URL url) throws IOException {
            IndexedFontMetrics indexedFontMetrics;
            InputStream is = null;
            URLConnection conn = null;
            try {
                conn = url.openConnection();
                conn.setDoOutput(false);
                conn.setUseCaches(true);
                conn.connect();
                is = conn.getInputStream();
                int size = conn.getContentLength();
                byte[] buf = new byte[size];
                is.read(buf);
                indexedFontMetrics = IndexedFontMetrics.fromByteBuffer(ByteBuffer.wrap(buf));
            }
            catch (Throwable throwable) {
                SimpleFontMetrics.closeSilent(is);
                throw throwable;
            }
            SimpleFontMetrics.closeSilent(is);
            return indexedFontMetrics;
        }

        public static IndexedFontMetrics importFile(File file) throws IOException {
            return IndexedFontMetrics.importFile(file.toURI().toURL());
        }

        public static IndexedFontMetrics importFile(String file) throws IOException {
            return IndexedFontMetrics.importFile(new File(file));
        }

        private static final IndexedFontMetrics fromByteBuffer(ByteBuffer bb) {
            int rangeCount = bb.getInt();
            int[] ranges = new int[rangeCount * 2];
            int i = 0;
            int o = 0;
            while (i < rangeCount) {
                ranges[o] = bb.getInt();
                ranges[o + 1] = bb.getInt();
                ++i;
                o += 2;
            }
            int widthCount = bb.getInt();
            byte[] widths = new byte[widthCount];
            for (int i2 = 0; i2 < widthCount; ++i2) {
                widths[i2] = bb.get();
            }
            bb.flip();
            return new IndexedFontMetrics(ranges, widths);
        }

        static {
            try {
                INSTANCE = IndexedFontMetrics.importFile(IndexedFontMetrics.class.getResource(SimpleFontMetrics.FILE_RESOURCE_INDEX_CACHE));
            }
            catch (Exception e) {
                log.error("IndexedFontMetrics not available: " + e);
                throw new RuntimeException(e);
            }
        }
    }

    public static class SystemFontMetrics
    implements FontMetricsHelper {
        private static SystemFontMetrics INSTANCE = null;
        private final FontMetrics metrics;

        public static SystemFontMetrics getDefaultInstance() {
            return INSTANCE;
        }

        public SystemFontMetrics() {
            BufferedImage canvas = new BufferedImage(5, 5, 1);
            Graphics graphics = canvas.getGraphics();
            Font font = new Font(SimpleFontMetrics.FONT_NAME, 0, 110);
            this.metrics = graphics.getFontMetrics(font);
        }

        @Override
        public int widthOf(String input) {
            return this.metrics.stringWidth(input);
        }

        @Override
        public byte widthOf(int codePoint) {
            return (byte)Math.min(Math.max(this.metrics.charWidth(codePoint), 0), 127);
        }

        public static List<String> getFontList() {
            return Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exportFile(List<List<Integer>> ranges, String file) throws IOException {
            List<Byte> widths = this.computeWidthsOfRanges(ranges);
            ByteBuffer bb = this.toByteBuffer(ranges, widths);
            FileOutputStream fos = null;
            FileChannel chan = null;
            try {
                fos = new FileOutputStream(file);
                chan = fos.getChannel();
                chan.write(bb);
            }
            catch (Throwable throwable) {
                SimpleFontMetrics.closeSilent(chan);
                SimpleFontMetrics.closeSilent(fos);
                throw throwable;
            }
            SimpleFontMetrics.closeSilent(chan);
            SimpleFontMetrics.closeSilent(fos);
        }

        private final List<Byte> computeWidthsOfRanges(List<List<Integer>> ranges) {
            Byte[] widths = new Byte[this.sumRanges(ranges)];
            int offset = 0;
            for (List<Integer> r : ranges) {
                Integer lower = r.get(0);
                Integer upper = r.get(1);
                this.widthOfRange(lower, upper, widths, offset);
                offset += upper - lower + 1;
            }
            return Arrays.asList(widths);
        }

        private final int sumRanges(List<List<Integer>> ranges) {
            int cx = 0;
            for (List<Integer> r : ranges) {
                Integer lower = r.get(0);
                Integer upper = r.get(1);
                cx += upper - lower + 1;
            }
            return cx;
        }

        private final void widthOfRange(int lower, int upper, Byte[] widths, int offset) {
            for (int codePoint = lower; codePoint <= upper; ++codePoint) {
                byte width = 0;
                width = codePoint < 32 ? (byte)0 : this.widthOf(codePoint);
                widths[offset + codePoint - lower] = width;
            }
        }

        private final ByteBuffer toByteBuffer(List<List<Integer>> ranges, List<Byte> widths) {
            int rangeSize = (1 + ranges.size() * 2) * 4;
            int widthSize = 4 + widths.size() * 1;
            int totalSize = rangeSize + widthSize;
            ByteBuffer bb = ByteBuffer.allocate(totalSize);
            bb.putInt(ranges.size());
            for (List<Integer> r : ranges) {
                Integer lower = r.get(0);
                Integer upper = r.get(1);
                bb.putInt(lower);
                bb.putInt(upper);
            }
            bb.putInt(widths.size());
            for (Byte b : widths) {
                bb.put(b);
            }
            bb.flip();
            return bb;
        }

        static {
            try {
                INSTANCE = new SystemFontMetrics();
            }
            catch (Throwable t) {
                log.warn("SystemFontMetrics not available: " + t);
            }
        }
    }

    public static interface FontMetricsHelper {
        public int widthOf(String var1);

        public byte widthOf(int var1);
    }
}

