package org.javacord.api.listener.webhook;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.message.MessageCreateListener;
import org.javacord.api.listener.message.MessageReplyListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link WebhookAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface WebhookAttachableListenerManager {

    /**
     * Adds a {@code MessageCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageCreateListener> addMessageCreateListener(MessageCreateListener listener);

    /**
     * Gets all registered {@code MessageCreateListener}s.
     *
     * @return All registered {@code MessageCreateListener}s.
     */
    List<MessageCreateListener> getMessageCreateListeners();

    /**
     * Adds a {@code MessageReplyListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageReplyListener> addMessageReplyListener(MessageReplyListener listener);

    /**
     * Gets all registered {@code MessageReplyListener}s.
     *
     * @return All registered {@code MessageReplyListener}s.
     */
    List<MessageReplyListener> getMessageReplyListeners();

    /**
     * Adds a listener that implements one or more {@code WebhookAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends WebhookAttachableListener & ObjectAttachableListener> Collection<ListenerManager<T>> addWebhookAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code WebhookAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends WebhookAttachableListener & ObjectAttachableListener> void removeWebhookAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code WebhookAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code WebhookAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends WebhookAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getWebhookAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends WebhookAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
