package org.javacord.api.listener.user;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.channel.server.ServerChannelChangeOverwrittenPermissionsListener;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelMemberJoinListener;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelMemberLeaveListener;
import org.javacord.api.listener.channel.user.PrivateChannelCreateListener;
import org.javacord.api.listener.channel.user.PrivateChannelDeleteListener;
import org.javacord.api.listener.interaction.AutocompleteCreateListener;
import org.javacord.api.listener.interaction.ButtonClickListener;
import org.javacord.api.listener.interaction.InteractionCreateListener;
import org.javacord.api.listener.interaction.MessageComponentCreateListener;
import org.javacord.api.listener.interaction.MessageContextMenuCommandListener;
import org.javacord.api.listener.interaction.ModalSubmitListener;
import org.javacord.api.listener.interaction.SelectMenuChooseListener;
import org.javacord.api.listener.interaction.SlashCommandCreateListener;
import org.javacord.api.listener.interaction.UserContextMenuCommandListener;
import org.javacord.api.listener.message.MessageCreateListener;
import org.javacord.api.listener.message.MessageReplyListener;
import org.javacord.api.listener.message.reaction.ReactionAddListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveListener;
import org.javacord.api.listener.server.member.ServerMemberBanListener;
import org.javacord.api.listener.server.member.ServerMemberJoinListener;
import org.javacord.api.listener.server.member.ServerMemberLeaveListener;
import org.javacord.api.listener.server.member.ServerMemberUnbanListener;
import org.javacord.api.listener.server.role.UserRoleAddListener;
import org.javacord.api.listener.server.role.UserRoleRemoveListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link UserAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface UserAttachableListenerManager {

    /**
     * Adds a {@code UserChangeSelfMutedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeSelfMutedListener> addUserChangeSelfMutedListener(UserChangeSelfMutedListener listener);

    /**
     * Gets all registered {@code UserChangeSelfMutedListener}s.
     *
     * @return All registered {@code UserChangeSelfMutedListener}s.
     */
    List<UserChangeSelfMutedListener> getUserChangeSelfMutedListeners();

    /**
     * Adds a {@code UserChangeNameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeNameListener> addUserChangeNameListener(UserChangeNameListener listener);

    /**
     * Gets all registered {@code UserChangeNameListener}s.
     *
     * @return All registered {@code UserChangeNameListener}s.
     */
    List<UserChangeNameListener> getUserChangeNameListeners();

    /**
     * Adds a {@code UserChangeServerAvatarListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeServerAvatarListener> addUserChangeServerAvatarListener(UserChangeServerAvatarListener listener);

    /**
     * Gets all registered {@code UserChangeServerAvatarListener}s.
     *
     * @return All registered {@code UserChangeServerAvatarListener}s.
     */
    List<UserChangeServerAvatarListener> getUserChangeServerAvatarListeners();

    /**
     * Adds a {@code UserChangeAvatarListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeAvatarListener> addUserChangeAvatarListener(UserChangeAvatarListener listener);

    /**
     * Gets all registered {@code UserChangeAvatarListener}s.
     *
     * @return All registered {@code UserChangeAvatarListener}s.
     */
    List<UserChangeAvatarListener> getUserChangeAvatarListeners();

    /**
     * Adds a {@code UserChangeStatusListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeStatusListener> addUserChangeStatusListener(UserChangeStatusListener listener);

    /**
     * Gets all registered {@code UserChangeStatusListener}s.
     *
     * @return All registered {@code UserChangeStatusListener}s.
     */
    List<UserChangeStatusListener> getUserChangeStatusListeners();

    /**
     * Adds a {@code UserChangeActivityListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeActivityListener> addUserChangeActivityListener(UserChangeActivityListener listener);

    /**
     * Gets all registered {@code UserChangeActivityListener}s.
     *
     * @return All registered {@code UserChangeActivityListener}s.
     */
    List<UserChangeActivityListener> getUserChangeActivityListeners();

    /**
     * Adds a {@code UserChangePendingListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangePendingListener> addUserChangePendingListener(UserChangePendingListener listener);

    /**
     * Gets all registered {@code UserChangePendingListener}s.
     *
     * @return All registered {@code UserChangePendingListener}s.
     */
    List<UserChangePendingListener> getUserChangePendingListeners();

    /**
     * Adds a {@code UserChangeDiscriminatorListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeDiscriminatorListener> addUserChangeDiscriminatorListener(UserChangeDiscriminatorListener listener);

    /**
     * Gets all registered {@code UserChangeDiscriminatorListener}s.
     *
     * @return All registered {@code UserChangeDiscriminatorListener}s.
     */
    List<UserChangeDiscriminatorListener> getUserChangeDiscriminatorListeners();

    /**
     * Adds a {@code UserChangeTimeoutListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeTimeoutListener> addUserChangeTimeoutListener(UserChangeTimeoutListener listener);

    /**
     * Gets all registered {@code UserChangeTimeoutListener}s.
     *
     * @return All registered {@code UserChangeTimeoutListener}s.
     */
    List<UserChangeTimeoutListener> getUserChangeTimeoutListeners();

    /**
     * Adds a {@code UserChangeNicknameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeNicknameListener> addUserChangeNicknameListener(UserChangeNicknameListener listener);

    /**
     * Gets all registered {@code UserChangeNicknameListener}s.
     *
     * @return All registered {@code UserChangeNicknameListener}s.
     */
    List<UserChangeNicknameListener> getUserChangeNicknameListeners();

    /**
     * Adds a {@code UserChangeSelfDeafenedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeSelfDeafenedListener> addUserChangeSelfDeafenedListener(UserChangeSelfDeafenedListener listener);

    /**
     * Gets all registered {@code UserChangeSelfDeafenedListener}s.
     *
     * @return All registered {@code UserChangeSelfDeafenedListener}s.
     */
    List<UserChangeSelfDeafenedListener> getUserChangeSelfDeafenedListeners();

    /**
     * Adds a {@code UserStartTypingListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserStartTypingListener> addUserStartTypingListener(UserStartTypingListener listener);

    /**
     * Gets all registered {@code UserStartTypingListener}s.
     *
     * @return All registered {@code UserStartTypingListener}s.
     */
    List<UserStartTypingListener> getUserStartTypingListeners();

    /**
     * Adds a {@code UserChangeDeafenedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeDeafenedListener> addUserChangeDeafenedListener(UserChangeDeafenedListener listener);

    /**
     * Gets all registered {@code UserChangeDeafenedListener}s.
     *
     * @return All registered {@code UserChangeDeafenedListener}s.
     */
    List<UserChangeDeafenedListener> getUserChangeDeafenedListeners();

    /**
     * Adds a {@code UserChangeMutedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeMutedListener> addUserChangeMutedListener(UserChangeMutedListener listener);

    /**
     * Gets all registered {@code UserChangeMutedListener}s.
     *
     * @return All registered {@code UserChangeMutedListener}s.
     */
    List<UserChangeMutedListener> getUserChangeMutedListeners();

    /**
     * Adds a {@code ModalSubmitListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ModalSubmitListener> addModalSubmitListener(ModalSubmitListener listener);

    /**
     * Gets all registered {@code ModalSubmitListener}s.
     *
     * @return All registered {@code ModalSubmitListener}s.
     */
    List<ModalSubmitListener> getModalSubmitListeners();

    /**
     * Adds a {@code MessageContextMenuCommandListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageContextMenuCommandListener> addMessageContextMenuCommandListener(MessageContextMenuCommandListener listener);

    /**
     * Gets all registered {@code MessageContextMenuCommandListener}s.
     *
     * @return All registered {@code MessageContextMenuCommandListener}s.
     */
    List<MessageContextMenuCommandListener> getMessageContextMenuCommandListeners();

    /**
     * Adds a {@code InteractionCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<InteractionCreateListener> addInteractionCreateListener(InteractionCreateListener listener);

    /**
     * Gets all registered {@code InteractionCreateListener}s.
     *
     * @return All registered {@code InteractionCreateListener}s.
     */
    List<InteractionCreateListener> getInteractionCreateListeners();

    /**
     * Adds a {@code ButtonClickListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ButtonClickListener> addButtonClickListener(ButtonClickListener listener);

    /**
     * Gets all registered {@code ButtonClickListener}s.
     *
     * @return All registered {@code ButtonClickListener}s.
     */
    List<ButtonClickListener> getButtonClickListeners();

    /**
     * Adds a {@code SelectMenuChooseListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<SelectMenuChooseListener> addSelectMenuChooseListener(SelectMenuChooseListener listener);

    /**
     * Gets all registered {@code SelectMenuChooseListener}s.
     *
     * @return All registered {@code SelectMenuChooseListener}s.
     */
    List<SelectMenuChooseListener> getSelectMenuChooseListeners();

    /**
     * Adds a {@code UserContextMenuCommandListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserContextMenuCommandListener> addUserContextMenuCommandListener(UserContextMenuCommandListener listener);

    /**
     * Gets all registered {@code UserContextMenuCommandListener}s.
     *
     * @return All registered {@code UserContextMenuCommandListener}s.
     */
    List<UserContextMenuCommandListener> getUserContextMenuCommandListeners();

    /**
     * Adds a {@code SlashCommandCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<SlashCommandCreateListener> addSlashCommandCreateListener(SlashCommandCreateListener listener);

    /**
     * Gets all registered {@code SlashCommandCreateListener}s.
     *
     * @return All registered {@code SlashCommandCreateListener}s.
     */
    List<SlashCommandCreateListener> getSlashCommandCreateListeners();

    /**
     * Adds a {@code MessageComponentCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageComponentCreateListener> addMessageComponentCreateListener(MessageComponentCreateListener listener);

    /**
     * Gets all registered {@code MessageComponentCreateListener}s.
     *
     * @return All registered {@code MessageComponentCreateListener}s.
     */
    List<MessageComponentCreateListener> getMessageComponentCreateListeners();

    /**
     * Adds a {@code AutocompleteCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<AutocompleteCreateListener> addAutocompleteCreateListener(AutocompleteCreateListener listener);

    /**
     * Gets all registered {@code AutocompleteCreateListener}s.
     *
     * @return All registered {@code AutocompleteCreateListener}s.
     */
    List<AutocompleteCreateListener> getAutocompleteCreateListeners();

    /**
     * Adds a {@code MessageCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageCreateListener> addMessageCreateListener(MessageCreateListener listener);

    /**
     * Gets all registered {@code MessageCreateListener}s.
     *
     * @return All registered {@code MessageCreateListener}s.
     */
    List<MessageCreateListener> getMessageCreateListeners();

    /**
     * Adds a {@code MessageReplyListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageReplyListener> addMessageReplyListener(MessageReplyListener listener);

    /**
     * Gets all registered {@code MessageReplyListener}s.
     *
     * @return All registered {@code MessageReplyListener}s.
     */
    List<MessageReplyListener> getMessageReplyListeners();

    /**
     * Adds a {@code ReactionAddListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionAddListener> addReactionAddListener(ReactionAddListener listener);

    /**
     * Gets all registered {@code ReactionAddListener}s.
     *
     * @return All registered {@code ReactionAddListener}s.
     */
    List<ReactionAddListener> getReactionAddListeners();

    /**
     * Adds a {@code ReactionRemoveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionRemoveListener> addReactionRemoveListener(ReactionRemoveListener listener);

    /**
     * Gets all registered {@code ReactionRemoveListener}s.
     *
     * @return All registered {@code ReactionRemoveListener}s.
     */
    List<ReactionRemoveListener> getReactionRemoveListeners();

    /**
     * Adds a {@code ServerMemberJoinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerMemberJoinListener> addServerMemberJoinListener(ServerMemberJoinListener listener);

    /**
     * Gets all registered {@code ServerMemberJoinListener}s.
     *
     * @return All registered {@code ServerMemberJoinListener}s.
     */
    List<ServerMemberJoinListener> getServerMemberJoinListeners();

    /**
     * Adds a {@code ServerMemberBanListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerMemberBanListener> addServerMemberBanListener(ServerMemberBanListener listener);

    /**
     * Gets all registered {@code ServerMemberBanListener}s.
     *
     * @return All registered {@code ServerMemberBanListener}s.
     */
    List<ServerMemberBanListener> getServerMemberBanListeners();

    /**
     * Adds a {@code ServerMemberUnbanListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerMemberUnbanListener> addServerMemberUnbanListener(ServerMemberUnbanListener listener);

    /**
     * Gets all registered {@code ServerMemberUnbanListener}s.
     *
     * @return All registered {@code ServerMemberUnbanListener}s.
     */
    List<ServerMemberUnbanListener> getServerMemberUnbanListeners();

    /**
     * Adds a {@code ServerMemberLeaveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerMemberLeaveListener> addServerMemberLeaveListener(ServerMemberLeaveListener listener);

    /**
     * Gets all registered {@code ServerMemberLeaveListener}s.
     *
     * @return All registered {@code ServerMemberLeaveListener}s.
     */
    List<ServerMemberLeaveListener> getServerMemberLeaveListeners();

    /**
     * Adds a {@code UserRoleRemoveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserRoleRemoveListener> addUserRoleRemoveListener(UserRoleRemoveListener listener);

    /**
     * Gets all registered {@code UserRoleRemoveListener}s.
     *
     * @return All registered {@code UserRoleRemoveListener}s.
     */
    List<UserRoleRemoveListener> getUserRoleRemoveListeners();

    /**
     * Adds a {@code UserRoleAddListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserRoleAddListener> addUserRoleAddListener(UserRoleAddListener listener);

    /**
     * Gets all registered {@code UserRoleAddListener}s.
     *
     * @return All registered {@code UserRoleAddListener}s.
     */
    List<UserRoleAddListener> getUserRoleAddListeners();

    /**
     * Adds a {@code PrivateChannelDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<PrivateChannelDeleteListener> addPrivateChannelDeleteListener(PrivateChannelDeleteListener listener);

    /**
     * Gets all registered {@code PrivateChannelDeleteListener}s.
     *
     * @return All registered {@code PrivateChannelDeleteListener}s.
     */
    List<PrivateChannelDeleteListener> getPrivateChannelDeleteListeners();

    /**
     * Adds a {@code PrivateChannelCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<PrivateChannelCreateListener> addPrivateChannelCreateListener(PrivateChannelCreateListener listener);

    /**
     * Gets all registered {@code PrivateChannelCreateListener}s.
     *
     * @return All registered {@code PrivateChannelCreateListener}s.
     */
    List<PrivateChannelCreateListener> getPrivateChannelCreateListeners();

    /**
     * Adds a {@code ServerVoiceChannelMemberJoinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerVoiceChannelMemberJoinListener> addServerVoiceChannelMemberJoinListener(ServerVoiceChannelMemberJoinListener listener);

    /**
     * Gets all registered {@code ServerVoiceChannelMemberJoinListener}s.
     *
     * @return All registered {@code ServerVoiceChannelMemberJoinListener}s.
     */
    List<ServerVoiceChannelMemberJoinListener> getServerVoiceChannelMemberJoinListeners();

    /**
     * Adds a {@code ServerVoiceChannelMemberLeaveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerVoiceChannelMemberLeaveListener> addServerVoiceChannelMemberLeaveListener(ServerVoiceChannelMemberLeaveListener listener);

    /**
     * Gets all registered {@code ServerVoiceChannelMemberLeaveListener}s.
     *
     * @return All registered {@code ServerVoiceChannelMemberLeaveListener}s.
     */
    List<ServerVoiceChannelMemberLeaveListener> getServerVoiceChannelMemberLeaveListeners();

    /**
     * Adds a {@code ServerChannelChangeOverwrittenPermissionsListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelChangeOverwrittenPermissionsListener> addServerChannelChangeOverwrittenPermissionsListener(ServerChannelChangeOverwrittenPermissionsListener listener);

    /**
     * Gets all registered {@code ServerChannelChangeOverwrittenPermissionsListener}s.
     *
     * @return All registered {@code ServerChannelChangeOverwrittenPermissionsListener}s.
     */
    List<ServerChannelChangeOverwrittenPermissionsListener> getServerChannelChangeOverwrittenPermissionsListeners();

    /**
     * Adds a listener that implements one or more {@code UserAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends UserAttachableListener & ObjectAttachableListener> Collection<ListenerManager<T>> addUserAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code UserAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends UserAttachableListener & ObjectAttachableListener> void removeUserAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code UserAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code UserAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends UserAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getUserAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends UserAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
