package org.javacord.api.listener.message;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.interaction.ButtonClickListener;
import org.javacord.api.listener.interaction.MessageComponentCreateListener;
import org.javacord.api.listener.interaction.MessageContextMenuCommandListener;
import org.javacord.api.listener.interaction.SelectMenuChooseListener;
import org.javacord.api.listener.message.reaction.ReactionAddListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveAllListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link MessageAttachableListener}s for potentially uncached messages.
 */
@Generated("listener-manager-generation.gradle")
public interface UncachedMessageAttachableListenerManager {

    /**
     * Adds a {@code MessageContextMenuCommandListener}.
     *
     * @param listener The listener to add.
     * @param messageId The id of the message which should be listened to.
     * @return The manager of the listener.
     */
    ListenerManager<MessageContextMenuCommandListener> addMessageContextMenuCommandListener(long messageId, MessageContextMenuCommandListener listener);

    /**
     * Gets registered {@code MessageContextMenuCommandListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code MessageContextMenuCommandListener}s.
     */
    List<MessageContextMenuCommandListener> getMessageContextMenuCommandListeners(long messageId);

    /**
     * Gets registered {@code MessageContextMenuCommandListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code MessageContextMenuCommandListener}s.
     */
    List<MessageContextMenuCommandListener> getMessageContextMenuCommandListeners(String messageId);

    /**
     * Adds a {@code ButtonClickListener}.
     *
     * @param listener The listener to add.
     * @param messageId The id of the message which should be listened to.
     * @return The manager of the listener.
     */
    ListenerManager<ButtonClickListener> addButtonClickListener(long messageId, ButtonClickListener listener);

    /**
     * Gets registered {@code ButtonClickListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code ButtonClickListener}s.
     */
    List<ButtonClickListener> getButtonClickListeners(long messageId);

    /**
     * Gets registered {@code ButtonClickListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code ButtonClickListener}s.
     */
    List<ButtonClickListener> getButtonClickListeners(String messageId);

    /**
     * Adds a {@code SelectMenuChooseListener}.
     *
     * @param listener The listener to add.
     * @param messageId The id of the message which should be listened to.
     * @return The manager of the listener.
     */
    ListenerManager<SelectMenuChooseListener> addSelectMenuChooseListener(long messageId, SelectMenuChooseListener listener);

    /**
     * Gets registered {@code SelectMenuChooseListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code SelectMenuChooseListener}s.
     */
    List<SelectMenuChooseListener> getSelectMenuChooseListeners(long messageId);

    /**
     * Gets registered {@code SelectMenuChooseListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code SelectMenuChooseListener}s.
     */
    List<SelectMenuChooseListener> getSelectMenuChooseListeners(String messageId);

    /**
     * Adds a {@code MessageComponentCreateListener}.
     *
     * @param listener The listener to add.
     * @param messageId The id of the message which should be listened to.
     * @return The manager of the listener.
     */
    ListenerManager<MessageComponentCreateListener> addMessageComponentCreateListener(long messageId, MessageComponentCreateListener listener);

    /**
     * Gets registered {@code MessageComponentCreateListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code MessageComponentCreateListener}s.
     */
    List<MessageComponentCreateListener> getMessageComponentCreateListeners(long messageId);

    /**
     * Gets registered {@code MessageComponentCreateListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code MessageComponentCreateListener}s.
     */
    List<MessageComponentCreateListener> getMessageComponentCreateListeners(String messageId);

    /**
     * Adds a {@code MessageEditListener}.
     *
     * @param listener The listener to add.
     * @param messageId The id of the message which should be listened to.
     * @return The manager of the listener.
     */
    ListenerManager<MessageEditListener> addMessageEditListener(long messageId, MessageEditListener listener);

    /**
     * Gets registered {@code MessageEditListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code MessageEditListener}s.
     */
    List<MessageEditListener> getMessageEditListeners(long messageId);

    /**
     * Gets registered {@code MessageEditListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code MessageEditListener}s.
     */
    List<MessageEditListener> getMessageEditListeners(String messageId);

    /**
     * Adds a {@code MessageDeleteListener}.
     *
     * @param listener The listener to add.
     * @param messageId The id of the message which should be listened to.
     * @return The manager of the listener.
     */
    ListenerManager<MessageDeleteListener> addMessageDeleteListener(long messageId, MessageDeleteListener listener);

    /**
     * Gets registered {@code MessageDeleteListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code MessageDeleteListener}s.
     */
    List<MessageDeleteListener> getMessageDeleteListeners(long messageId);

    /**
     * Gets registered {@code MessageDeleteListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code MessageDeleteListener}s.
     */
    List<MessageDeleteListener> getMessageDeleteListeners(String messageId);

    /**
     * Adds a {@code MessageReplyListener}.
     *
     * @param listener The listener to add.
     * @param messageId The id of the message which should be listened to.
     * @return The manager of the listener.
     */
    ListenerManager<MessageReplyListener> addMessageReplyListener(long messageId, MessageReplyListener listener);

    /**
     * Gets registered {@code MessageReplyListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code MessageReplyListener}s.
     */
    List<MessageReplyListener> getMessageReplyListeners(long messageId);

    /**
     * Gets registered {@code MessageReplyListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code MessageReplyListener}s.
     */
    List<MessageReplyListener> getMessageReplyListeners(String messageId);

    /**
     * Adds a {@code ReactionAddListener}.
     *
     * @param listener The listener to add.
     * @param messageId The id of the message which should be listened to.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionAddListener> addReactionAddListener(long messageId, ReactionAddListener listener);

    /**
     * Gets registered {@code ReactionAddListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code ReactionAddListener}s.
     */
    List<ReactionAddListener> getReactionAddListeners(long messageId);

    /**
     * Gets registered {@code ReactionAddListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code ReactionAddListener}s.
     */
    List<ReactionAddListener> getReactionAddListeners(String messageId);

    /**
     * Adds a {@code ReactionRemoveAllListener}.
     *
     * @param listener The listener to add.
     * @param messageId The id of the message which should be listened to.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionRemoveAllListener> addReactionRemoveAllListener(long messageId, ReactionRemoveAllListener listener);

    /**
     * Gets registered {@code ReactionRemoveAllListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code ReactionRemoveAllListener}s.
     */
    List<ReactionRemoveAllListener> getReactionRemoveAllListeners(long messageId);

    /**
     * Gets registered {@code ReactionRemoveAllListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code ReactionRemoveAllListener}s.
     */
    List<ReactionRemoveAllListener> getReactionRemoveAllListeners(String messageId);

    /**
     * Adds a {@code ReactionRemoveListener}.
     *
     * @param listener The listener to add.
     * @param messageId The id of the message which should be listened to.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionRemoveListener> addReactionRemoveListener(long messageId, ReactionRemoveListener listener);

    /**
     * Gets registered {@code ReactionRemoveListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code ReactionRemoveListener}s.
     */
    List<ReactionRemoveListener> getReactionRemoveListeners(long messageId);

    /**
     * Gets registered {@code ReactionRemoveListener}s.
     *
     * @param messageId The id of the message.
     * @return All registered {@code ReactionRemoveListener}s.
     */
    List<ReactionRemoveListener> getReactionRemoveListeners(String messageId);

    /**
     * Adds a listener that implements one or more {@code MessageAttachableListener}s
     * to the message with the given id.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param messageId The id of the message which should be listened to.
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends MessageAttachableListener & ObjectAttachableListener> Collection<ListenerManager<T>> addMessageAttachableListener(long messageId, T listener);

    /**
     * Adds a listener that implements one or more {@code MessageAttachableListener}s
     * to the message with the given id.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param messageId The id of the message which should be listened to.
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends MessageAttachableListener & ObjectAttachableListener> Collection<ListenerManager<T>> addMessageAttachableListener(String messageId, T listener);

    /**
     * Removes a listener that implements one or more {@code MessageAttachableListener}s
     * from the message with the given id.
     *
     * @param messageId The id of the message.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends MessageAttachableListener & ObjectAttachableListener> void removeMessageAttachableListener(long messageId, T listener);

    /**
     * Removes a listener that implements one or more {@code MessageAttachableListener}s
     * from the message with the given id.
     *
     * @param messageId The id of the message.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends MessageAttachableListener & ObjectAttachableListener> void removeMessageAttachableListener(String messageId, T listener);

    /**
     * Gets a map with all registered listeners that implement one or more
     * {@code MessageAttachableListener}s and their assigned listener classes they listen to.
     *
     * @param messageId The id of the message.
     * @param <T> The type of the listener.
     * @return A map with all registered listeners that implement one or more
     *         {@code MessageAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends MessageAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getMessageAttachableListeners(long messageId);

    /**
     * Gets a map with all registered listeners that implement one or more
     * {@code MessageAttachableListener}s and their assigned listener classes they listen to.
     *
     * @param messageId The id of the message.
     * @param <T> The type of the listener.
     * @return A map with all registered listeners that implement one or more
     *         {@code MessageAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends MessageAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getMessageAttachableListeners(String messageId);

    /**
     * Removes a listener from this object.
     *
     * @param messageId The id of the message.
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends MessageAttachableListener & ObjectAttachableListener> void removeListener(long messageId, Class<T> listenerClass, T listener);

    /**
     * Removes a listener from this object.
     *
     * @param messageId The id of the message.
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends MessageAttachableListener & ObjectAttachableListener> void removeListener(String messageId, Class<T> listenerClass, T listener);
}
