package org.javacord.api.listener.channel.server.voice;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.channel.VoiceChannelAttachableListenerManager;
import org.javacord.api.listener.channel.server.ServerChannelAttachableListenerManager;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link ServerVoiceChannelAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface ServerVoiceChannelAttachableListenerManager extends ServerChannelAttachableListenerManager, VoiceChannelAttachableListenerManager {

    /**
     * Adds a {@code ServerVoiceChannelChangeBitrateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerVoiceChannelChangeBitrateListener> addServerVoiceChannelChangeBitrateListener(ServerVoiceChannelChangeBitrateListener listener);

    /**
     * Gets all registered {@code ServerVoiceChannelChangeBitrateListener}s.
     *
     * @return All registered {@code ServerVoiceChannelChangeBitrateListener}s.
     */
    List<ServerVoiceChannelChangeBitrateListener> getServerVoiceChannelChangeBitrateListeners();

    /**
     * Adds a {@code ServerVoiceChannelMemberJoinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerVoiceChannelMemberJoinListener> addServerVoiceChannelMemberJoinListener(ServerVoiceChannelMemberJoinListener listener);

    /**
     * Gets all registered {@code ServerVoiceChannelMemberJoinListener}s.
     *
     * @return All registered {@code ServerVoiceChannelMemberJoinListener}s.
     */
    List<ServerVoiceChannelMemberJoinListener> getServerVoiceChannelMemberJoinListeners();

    /**
     * Adds a {@code ServerVoiceChannelMemberLeaveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerVoiceChannelMemberLeaveListener> addServerVoiceChannelMemberLeaveListener(ServerVoiceChannelMemberLeaveListener listener);

    /**
     * Gets all registered {@code ServerVoiceChannelMemberLeaveListener}s.
     *
     * @return All registered {@code ServerVoiceChannelMemberLeaveListener}s.
     */
    List<ServerVoiceChannelMemberLeaveListener> getServerVoiceChannelMemberLeaveListeners();

    /**
     * Adds a {@code ServerVoiceChannelChangeNsfwListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerVoiceChannelChangeNsfwListener> addServerVoiceChannelChangeNsfwListener(ServerVoiceChannelChangeNsfwListener listener);

    /**
     * Gets all registered {@code ServerVoiceChannelChangeNsfwListener}s.
     *
     * @return All registered {@code ServerVoiceChannelChangeNsfwListener}s.
     */
    List<ServerVoiceChannelChangeNsfwListener> getServerVoiceChannelChangeNsfwListeners();

    /**
     * Adds a {@code ServerVoiceChannelChangeUserLimitListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerVoiceChannelChangeUserLimitListener> addServerVoiceChannelChangeUserLimitListener(ServerVoiceChannelChangeUserLimitListener listener);

    /**
     * Gets all registered {@code ServerVoiceChannelChangeUserLimitListener}s.
     *
     * @return All registered {@code ServerVoiceChannelChangeUserLimitListener}s.
     */
    List<ServerVoiceChannelChangeUserLimitListener> getServerVoiceChannelChangeUserLimitListeners();

    /**
     * Adds a listener that implements one or more {@code ServerVoiceChannelAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends ServerVoiceChannelAttachableListener & ObjectAttachableListener> Collection<ListenerManager<? extends ServerVoiceChannelAttachableListener>> addServerVoiceChannelAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code ServerVoiceChannelAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends ServerVoiceChannelAttachableListener & ObjectAttachableListener> void removeServerVoiceChannelAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code ServerVoiceChannelAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code ServerVoiceChannelAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends ServerVoiceChannelAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getServerVoiceChannelAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends ServerVoiceChannelAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
