package org.javacord.api.listener.channel;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.interaction.AutocompleteCreateListener;
import org.javacord.api.listener.interaction.ButtonClickListener;
import org.javacord.api.listener.interaction.InteractionCreateListener;
import org.javacord.api.listener.interaction.MessageComponentCreateListener;
import org.javacord.api.listener.interaction.MessageContextMenuCommandListener;
import org.javacord.api.listener.interaction.ModalSubmitListener;
import org.javacord.api.listener.interaction.SelectMenuChooseListener;
import org.javacord.api.listener.interaction.SlashCommandCreateListener;
import org.javacord.api.listener.interaction.UserContextMenuCommandListener;
import org.javacord.api.listener.message.CachedMessagePinListener;
import org.javacord.api.listener.message.CachedMessageUnpinListener;
import org.javacord.api.listener.message.ChannelPinsUpdateListener;
import org.javacord.api.listener.message.MessageCreateListener;
import org.javacord.api.listener.message.MessageDeleteListener;
import org.javacord.api.listener.message.MessageEditListener;
import org.javacord.api.listener.message.MessageReplyListener;
import org.javacord.api.listener.message.reaction.ReactionAddListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveAllListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveListener;
import org.javacord.api.listener.user.UserStartTypingListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link TextChannelAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface TextChannelAttachableListenerManager extends ChannelAttachableListenerManager, ServerThreadChannelAttachableListenerManager {

    /**
     * Adds a {@code UserStartTypingListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserStartTypingListener> addUserStartTypingListener(UserStartTypingListener listener);

    /**
     * Gets all registered {@code UserStartTypingListener}s.
     *
     * @return All registered {@code UserStartTypingListener}s.
     */
    List<UserStartTypingListener> getUserStartTypingListeners();

    /**
     * Adds a {@code ModalSubmitListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ModalSubmitListener> addModalSubmitListener(ModalSubmitListener listener);

    /**
     * Gets all registered {@code ModalSubmitListener}s.
     *
     * @return All registered {@code ModalSubmitListener}s.
     */
    List<ModalSubmitListener> getModalSubmitListeners();

    /**
     * Adds a {@code MessageContextMenuCommandListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageContextMenuCommandListener> addMessageContextMenuCommandListener(MessageContextMenuCommandListener listener);

    /**
     * Gets all registered {@code MessageContextMenuCommandListener}s.
     *
     * @return All registered {@code MessageContextMenuCommandListener}s.
     */
    List<MessageContextMenuCommandListener> getMessageContextMenuCommandListeners();

    /**
     * Adds a {@code InteractionCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<InteractionCreateListener> addInteractionCreateListener(InteractionCreateListener listener);

    /**
     * Gets all registered {@code InteractionCreateListener}s.
     *
     * @return All registered {@code InteractionCreateListener}s.
     */
    List<InteractionCreateListener> getInteractionCreateListeners();

    /**
     * Adds a {@code ButtonClickListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ButtonClickListener> addButtonClickListener(ButtonClickListener listener);

    /**
     * Gets all registered {@code ButtonClickListener}s.
     *
     * @return All registered {@code ButtonClickListener}s.
     */
    List<ButtonClickListener> getButtonClickListeners();

    /**
     * Adds a {@code SelectMenuChooseListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<SelectMenuChooseListener> addSelectMenuChooseListener(SelectMenuChooseListener listener);

    /**
     * Gets all registered {@code SelectMenuChooseListener}s.
     *
     * @return All registered {@code SelectMenuChooseListener}s.
     */
    List<SelectMenuChooseListener> getSelectMenuChooseListeners();

    /**
     * Adds a {@code UserContextMenuCommandListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserContextMenuCommandListener> addUserContextMenuCommandListener(UserContextMenuCommandListener listener);

    /**
     * Gets all registered {@code UserContextMenuCommandListener}s.
     *
     * @return All registered {@code UserContextMenuCommandListener}s.
     */
    List<UserContextMenuCommandListener> getUserContextMenuCommandListeners();

    /**
     * Adds a {@code SlashCommandCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<SlashCommandCreateListener> addSlashCommandCreateListener(SlashCommandCreateListener listener);

    /**
     * Gets all registered {@code SlashCommandCreateListener}s.
     *
     * @return All registered {@code SlashCommandCreateListener}s.
     */
    List<SlashCommandCreateListener> getSlashCommandCreateListeners();

    /**
     * Adds a {@code MessageComponentCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageComponentCreateListener> addMessageComponentCreateListener(MessageComponentCreateListener listener);

    /**
     * Gets all registered {@code MessageComponentCreateListener}s.
     *
     * @return All registered {@code MessageComponentCreateListener}s.
     */
    List<MessageComponentCreateListener> getMessageComponentCreateListeners();

    /**
     * Adds a {@code AutocompleteCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<AutocompleteCreateListener> addAutocompleteCreateListener(AutocompleteCreateListener listener);

    /**
     * Gets all registered {@code AutocompleteCreateListener}s.
     *
     * @return All registered {@code AutocompleteCreateListener}s.
     */
    List<AutocompleteCreateListener> getAutocompleteCreateListeners();

    /**
     * Adds a {@code MessageEditListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageEditListener> addMessageEditListener(MessageEditListener listener);

    /**
     * Gets all registered {@code MessageEditListener}s.
     *
     * @return All registered {@code MessageEditListener}s.
     */
    List<MessageEditListener> getMessageEditListeners();

    /**
     * Adds a {@code MessageCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageCreateListener> addMessageCreateListener(MessageCreateListener listener);

    /**
     * Gets all registered {@code MessageCreateListener}s.
     *
     * @return All registered {@code MessageCreateListener}s.
     */
    List<MessageCreateListener> getMessageCreateListeners();

    /**
     * Adds a {@code CachedMessagePinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<CachedMessagePinListener> addCachedMessagePinListener(CachedMessagePinListener listener);

    /**
     * Gets all registered {@code CachedMessagePinListener}s.
     *
     * @return All registered {@code CachedMessagePinListener}s.
     */
    List<CachedMessagePinListener> getCachedMessagePinListeners();

    /**
     * Adds a {@code MessageDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageDeleteListener> addMessageDeleteListener(MessageDeleteListener listener);

    /**
     * Gets all registered {@code MessageDeleteListener}s.
     *
     * @return All registered {@code MessageDeleteListener}s.
     */
    List<MessageDeleteListener> getMessageDeleteListeners();

    /**
     * Adds a {@code MessageReplyListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageReplyListener> addMessageReplyListener(MessageReplyListener listener);

    /**
     * Gets all registered {@code MessageReplyListener}s.
     *
     * @return All registered {@code MessageReplyListener}s.
     */
    List<MessageReplyListener> getMessageReplyListeners();

    /**
     * Adds a {@code ReactionAddListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionAddListener> addReactionAddListener(ReactionAddListener listener);

    /**
     * Gets all registered {@code ReactionAddListener}s.
     *
     * @return All registered {@code ReactionAddListener}s.
     */
    List<ReactionAddListener> getReactionAddListeners();

    /**
     * Adds a {@code ReactionRemoveAllListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionRemoveAllListener> addReactionRemoveAllListener(ReactionRemoveAllListener listener);

    /**
     * Gets all registered {@code ReactionRemoveAllListener}s.
     *
     * @return All registered {@code ReactionRemoveAllListener}s.
     */
    List<ReactionRemoveAllListener> getReactionRemoveAllListeners();

    /**
     * Adds a {@code ReactionRemoveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionRemoveListener> addReactionRemoveListener(ReactionRemoveListener listener);

    /**
     * Gets all registered {@code ReactionRemoveListener}s.
     *
     * @return All registered {@code ReactionRemoveListener}s.
     */
    List<ReactionRemoveListener> getReactionRemoveListeners();

    /**
     * Adds a {@code ChannelPinsUpdateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ChannelPinsUpdateListener> addChannelPinsUpdateListener(ChannelPinsUpdateListener listener);

    /**
     * Gets all registered {@code ChannelPinsUpdateListener}s.
     *
     * @return All registered {@code ChannelPinsUpdateListener}s.
     */
    List<ChannelPinsUpdateListener> getChannelPinsUpdateListeners();

    /**
     * Adds a {@code CachedMessageUnpinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<CachedMessageUnpinListener> addCachedMessageUnpinListener(CachedMessageUnpinListener listener);

    /**
     * Gets all registered {@code CachedMessageUnpinListener}s.
     *
     * @return All registered {@code CachedMessageUnpinListener}s.
     */
    List<CachedMessageUnpinListener> getCachedMessageUnpinListeners();

    /**
     * Adds a listener that implements one or more {@code TextChannelAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends TextChannelAttachableListener & ObjectAttachableListener> Collection<ListenerManager<? extends TextChannelAttachableListener>> addTextChannelAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code TextChannelAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends TextChannelAttachableListener & ObjectAttachableListener> void removeTextChannelAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code TextChannelAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code TextChannelAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends TextChannelAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getTextChannelAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends TextChannelAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
