package org.javacord.api.listener.channel.user;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.channel.TextChannelAttachableListenerManager;
import org.javacord.api.listener.channel.VoiceChannelAttachableListenerManager;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link PrivateChannelAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface PrivateChannelAttachableListenerManager extends TextChannelAttachableListenerManager, VoiceChannelAttachableListenerManager {

    /**
     * Adds a {@code PrivateChannelDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<PrivateChannelDeleteListener> addPrivateChannelDeleteListener(PrivateChannelDeleteListener listener);

    /**
     * Gets all registered {@code PrivateChannelDeleteListener}s.
     *
     * @return All registered {@code PrivateChannelDeleteListener}s.
     */
    List<PrivateChannelDeleteListener> getPrivateChannelDeleteListeners();

    /**
     * Adds a listener that implements one or more {@code PrivateChannelAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends PrivateChannelAttachableListener & ObjectAttachableListener> Collection<ListenerManager<? extends PrivateChannelAttachableListener>> addPrivateChannelAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code PrivateChannelAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends PrivateChannelAttachableListener & ObjectAttachableListener> void removePrivateChannelAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code PrivateChannelAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code PrivateChannelAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends PrivateChannelAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getPrivateChannelAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends PrivateChannelAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
