package org.javacord.api.listener.channel.server.text;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.channel.TextChannelAttachableListenerManager;
import org.javacord.api.listener.channel.server.ServerChannelAttachableListenerManager;
import org.javacord.api.listener.channel.server.ServerChannelChangeNsfwFlagListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link ServerTextChannelAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface ServerTextChannelAttachableListenerManager extends ServerChannelAttachableListenerManager, TextChannelAttachableListenerManager {

    /**
     * Adds a {@code ServerTextChannelChangeSlowmodeListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerTextChannelChangeSlowmodeListener> addServerTextChannelChangeSlowmodeListener(ServerTextChannelChangeSlowmodeListener listener);

    /**
     * Gets all registered {@code ServerTextChannelChangeSlowmodeListener}s.
     *
     * @return All registered {@code ServerTextChannelChangeSlowmodeListener}s.
     */
    List<ServerTextChannelChangeSlowmodeListener> getServerTextChannelChangeSlowmodeListeners();

    /**
     * Adds a {@code WebhooksUpdateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<WebhooksUpdateListener> addWebhooksUpdateListener(WebhooksUpdateListener listener);

    /**
     * Gets all registered {@code WebhooksUpdateListener}s.
     *
     * @return All registered {@code WebhooksUpdateListener}s.
     */
    List<WebhooksUpdateListener> getWebhooksUpdateListeners();

    /**
     * Adds a {@code ServerTextChannelChangeDefaultAutoArchiveDurationListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerTextChannelChangeDefaultAutoArchiveDurationListener> addServerTextChannelChangeDefaultAutoArchiveDurationListener(ServerTextChannelChangeDefaultAutoArchiveDurationListener listener);

    /**
     * Gets all registered {@code ServerTextChannelChangeDefaultAutoArchiveDurationListener}s.
     *
     * @return All registered {@code ServerTextChannelChangeDefaultAutoArchiveDurationListener}s.
     */
    List<ServerTextChannelChangeDefaultAutoArchiveDurationListener> getServerTextChannelChangeDefaultAutoArchiveDurationListeners();

    /**
     * Adds a {@code ServerTextChannelChangeTopicListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerTextChannelChangeTopicListener> addServerTextChannelChangeTopicListener(ServerTextChannelChangeTopicListener listener);

    /**
     * Gets all registered {@code ServerTextChannelChangeTopicListener}s.
     *
     * @return All registered {@code ServerTextChannelChangeTopicListener}s.
     */
    List<ServerTextChannelChangeTopicListener> getServerTextChannelChangeTopicListeners();

    /**
     * Adds a {@code ServerChannelChangeNsfwFlagListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelChangeNsfwFlagListener> addServerChannelChangeNsfwFlagListener(ServerChannelChangeNsfwFlagListener listener);

    /**
     * Gets all registered {@code ServerChannelChangeNsfwFlagListener}s.
     *
     * @return All registered {@code ServerChannelChangeNsfwFlagListener}s.
     */
    List<ServerChannelChangeNsfwFlagListener> getServerChannelChangeNsfwFlagListeners();

    /**
     * Adds a listener that implements one or more {@code ServerTextChannelAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends ServerTextChannelAttachableListener & ObjectAttachableListener> Collection<ListenerManager<? extends ServerTextChannelAttachableListener>> addServerTextChannelAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code ServerTextChannelAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends ServerTextChannelAttachableListener & ObjectAttachableListener> void removeServerTextChannelAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code ServerTextChannelAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code ServerTextChannelAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends ServerTextChannelAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getServerTextChannelAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends ServerTextChannelAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
