package org.javacord.api.listener.channel;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.channel.server.thread.ServerThreadChannelCreateListener;
import org.javacord.api.listener.channel.server.thread.ServerThreadChannelDeleteListener;
import org.javacord.api.listener.channel.server.thread.ServerThreadChannelMembersUpdateListener;
import org.javacord.api.listener.channel.server.thread.ServerThreadChannelUpdateListener;
import org.javacord.api.listener.server.thread.ServerPrivateThreadJoinListener;
import org.javacord.api.listener.server.thread.ServerThreadChannelChangeArchiveTimestampListener;
import org.javacord.api.listener.server.thread.ServerThreadChannelChangeArchivedListener;
import org.javacord.api.listener.server.thread.ServerThreadChannelChangeAutoArchiveDurationListener;
import org.javacord.api.listener.server.thread.ServerThreadChannelChangeInvitableListener;
import org.javacord.api.listener.server.thread.ServerThreadChannelChangeLastMessageIdListener;
import org.javacord.api.listener.server.thread.ServerThreadChannelChangeLockedListener;
import org.javacord.api.listener.server.thread.ServerThreadChannelChangeMemberCountListener;
import org.javacord.api.listener.server.thread.ServerThreadChannelChangeMessageCountListener;
import org.javacord.api.listener.server.thread.ServerThreadChannelChangeRateLimitPerUserListener;
import org.javacord.api.listener.server.thread.ServerThreadChannelChangeTotalMessageSentListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link ServerThreadChannelAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface ServerThreadChannelAttachableListenerManager {

    /**
     * Adds a {@code ServerThreadChannelChangeAutoArchiveDurationListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelChangeAutoArchiveDurationListener> addServerThreadChannelChangeAutoArchiveDurationListener(ServerThreadChannelChangeAutoArchiveDurationListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelChangeAutoArchiveDurationListener}s.
     *
     * @return All registered {@code ServerThreadChannelChangeAutoArchiveDurationListener}s.
     */
    List<ServerThreadChannelChangeAutoArchiveDurationListener> getServerThreadChannelChangeAutoArchiveDurationListeners();

    /**
     * Adds a {@code ServerThreadChannelChangeMemberCountListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelChangeMemberCountListener> addServerThreadChannelChangeMemberCountListener(ServerThreadChannelChangeMemberCountListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelChangeMemberCountListener}s.
     *
     * @return All registered {@code ServerThreadChannelChangeMemberCountListener}s.
     */
    List<ServerThreadChannelChangeMemberCountListener> getServerThreadChannelChangeMemberCountListeners();

    /**
     * Adds a {@code ServerThreadChannelChangeLastMessageIdListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelChangeLastMessageIdListener> addServerThreadChannelChangeLastMessageIdListener(ServerThreadChannelChangeLastMessageIdListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelChangeLastMessageIdListener}s.
     *
     * @return All registered {@code ServerThreadChannelChangeLastMessageIdListener}s.
     */
    List<ServerThreadChannelChangeLastMessageIdListener> getServerThreadChannelChangeLastMessageIdListeners();

    /**
     * Adds a {@code ServerThreadChannelChangeArchivedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelChangeArchivedListener> addServerThreadChannelChangeArchivedListener(ServerThreadChannelChangeArchivedListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelChangeArchivedListener}s.
     *
     * @return All registered {@code ServerThreadChannelChangeArchivedListener}s.
     */
    List<ServerThreadChannelChangeArchivedListener> getServerThreadChannelChangeArchivedListeners();

    /**
     * Adds a {@code ServerThreadChannelChangeRateLimitPerUserListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelChangeRateLimitPerUserListener> addServerThreadChannelChangeRateLimitPerUserListener(ServerThreadChannelChangeRateLimitPerUserListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelChangeRateLimitPerUserListener}s.
     *
     * @return All registered {@code ServerThreadChannelChangeRateLimitPerUserListener}s.
     */
    List<ServerThreadChannelChangeRateLimitPerUserListener> getServerThreadChannelChangeRateLimitPerUserListeners();

    /**
     * Adds a {@code ServerThreadChannelChangeLockedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelChangeLockedListener> addServerThreadChannelChangeLockedListener(ServerThreadChannelChangeLockedListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelChangeLockedListener}s.
     *
     * @return All registered {@code ServerThreadChannelChangeLockedListener}s.
     */
    List<ServerThreadChannelChangeLockedListener> getServerThreadChannelChangeLockedListeners();

    /**
     * Adds a {@code ServerThreadChannelChangeInvitableListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelChangeInvitableListener> addServerThreadChannelChangeInvitableListener(ServerThreadChannelChangeInvitableListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelChangeInvitableListener}s.
     *
     * @return All registered {@code ServerThreadChannelChangeInvitableListener}s.
     */
    List<ServerThreadChannelChangeInvitableListener> getServerThreadChannelChangeInvitableListeners();

    /**
     * Adds a {@code ServerThreadChannelChangeMessageCountListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelChangeMessageCountListener> addServerThreadChannelChangeMessageCountListener(ServerThreadChannelChangeMessageCountListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelChangeMessageCountListener}s.
     *
     * @return All registered {@code ServerThreadChannelChangeMessageCountListener}s.
     */
    List<ServerThreadChannelChangeMessageCountListener> getServerThreadChannelChangeMessageCountListeners();

    /**
     * Adds a {@code ServerThreadChannelChangeArchiveTimestampListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelChangeArchiveTimestampListener> addServerThreadChannelChangeArchiveTimestampListener(ServerThreadChannelChangeArchiveTimestampListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelChangeArchiveTimestampListener}s.
     *
     * @return All registered {@code ServerThreadChannelChangeArchiveTimestampListener}s.
     */
    List<ServerThreadChannelChangeArchiveTimestampListener> getServerThreadChannelChangeArchiveTimestampListeners();

    /**
     * Adds a {@code ServerPrivateThreadJoinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerPrivateThreadJoinListener> addServerPrivateThreadJoinListener(ServerPrivateThreadJoinListener listener);

    /**
     * Gets all registered {@code ServerPrivateThreadJoinListener}s.
     *
     * @return All registered {@code ServerPrivateThreadJoinListener}s.
     */
    List<ServerPrivateThreadJoinListener> getServerPrivateThreadJoinListeners();

    /**
     * Adds a {@code ServerThreadChannelChangeTotalMessageSentListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelChangeTotalMessageSentListener> addServerThreadChannelChangeTotalMessageSentListener(ServerThreadChannelChangeTotalMessageSentListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelChangeTotalMessageSentListener}s.
     *
     * @return All registered {@code ServerThreadChannelChangeTotalMessageSentListener}s.
     */
    List<ServerThreadChannelChangeTotalMessageSentListener> getServerThreadChannelChangeTotalMessageSentListeners();

    /**
     * Adds a {@code ServerThreadChannelMembersUpdateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelMembersUpdateListener> addServerThreadChannelMembersUpdateListener(ServerThreadChannelMembersUpdateListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelMembersUpdateListener}s.
     *
     * @return All registered {@code ServerThreadChannelMembersUpdateListener}s.
     */
    List<ServerThreadChannelMembersUpdateListener> getServerThreadChannelMembersUpdateListeners();

    /**
     * Adds a {@code ServerThreadChannelUpdateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelUpdateListener> addServerThreadChannelUpdateListener(ServerThreadChannelUpdateListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelUpdateListener}s.
     *
     * @return All registered {@code ServerThreadChannelUpdateListener}s.
     */
    List<ServerThreadChannelUpdateListener> getServerThreadChannelUpdateListeners();

    /**
     * Adds a {@code ServerThreadChannelDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelDeleteListener> addServerThreadChannelDeleteListener(ServerThreadChannelDeleteListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelDeleteListener}s.
     *
     * @return All registered {@code ServerThreadChannelDeleteListener}s.
     */
    List<ServerThreadChannelDeleteListener> getServerThreadChannelDeleteListeners();

    /**
     * Adds a {@code ServerThreadChannelCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelCreateListener> addServerThreadChannelCreateListener(ServerThreadChannelCreateListener listener);

    /**
     * Gets all registered {@code ServerThreadChannelCreateListener}s.
     *
     * @return All registered {@code ServerThreadChannelCreateListener}s.
     */
    List<ServerThreadChannelCreateListener> getServerThreadChannelCreateListeners();

    /**
     * Adds a listener that implements one or more {@code ServerThreadChannelAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends ServerThreadChannelAttachableListener & ObjectAttachableListener> Collection<ListenerManager<T>> addServerThreadChannelAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code ServerThreadChannelAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends ServerThreadChannelAttachableListener & ObjectAttachableListener> void removeServerThreadChannelAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code ServerThreadChannelAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code ServerThreadChannelAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends ServerThreadChannelAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getServerThreadChannelAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends ServerThreadChannelAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
