/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.interaction;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.Attachment;
import org.javacord.api.entity.Mentionable;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.permission.Role;
import org.javacord.api.entity.user.User;
import org.javacord.api.interaction.SlashCommandInteractionOption;

public interface SlashCommandInteractionOptionsProvider {
    public List<SlashCommandInteractionOption> getOptions();

    default public Optional<SlashCommandInteractionOption> getOptionByName(String name) {
        return this.getOptions().stream().filter(option -> option.getName().equalsIgnoreCase(name)).findAny();
    }

    default public Optional<String> getOptionStringRepresentationValueByName(String name) {
        return this.getOptionByName(name).flatMap(SlashCommandInteractionOption::getStringRepresentationValue);
    }

    default public Optional<String> getOptionStringValueByName(String name) {
        return this.getOptionByName(name).flatMap(SlashCommandInteractionOption::getStringValue);
    }

    default public Optional<Long> getOptionLongValueByName(String name) {
        return this.getOptionByName(name).flatMap(SlashCommandInteractionOption::getLongValue);
    }

    default public Optional<Boolean> getOptionBooleanValueByName(String name) {
        return this.getOptionByName(name).flatMap(SlashCommandInteractionOption::getBooleanValue);
    }

    default public Optional<User> getOptionUserValueByName(String name) {
        return this.getOptionByName(name).flatMap(SlashCommandInteractionOption::getUserValue);
    }

    default public Optional<CompletableFuture<User>> requestOptionUserValueByName(String name) {
        return this.getOptionByName(name).flatMap(SlashCommandInteractionOption::requestUserValue);
    }

    default public Optional<ServerChannel> getOptionChannelValueByName(String name) {
        return this.getOptionByName(name).flatMap(SlashCommandInteractionOption::getChannelValue);
    }

    default public Optional<Role> getOptionRoleValueByName(String name) {
        return this.getOptionByName(name).flatMap(SlashCommandInteractionOption::getRoleValue);
    }

    default public Optional<Mentionable> getOptionMentionableValueByName(String name) {
        return this.getOptionByName(name).flatMap(SlashCommandInteractionOption::getMentionableValue);
    }

    default public Optional<CompletableFuture<Mentionable>> requestOptionMentionableValueByName(String name) {
        return this.getOptionByName(name).flatMap(SlashCommandInteractionOption::requestMentionableValue);
    }

    default public Optional<Double> getOptionDecimalValueByName(String name) {
        return this.getOptionByName(name).flatMap(SlashCommandInteractionOption::getDecimalValue);
    }

    default public Optional<Attachment> getOptionAttachmentValueByName(String name) {
        return this.getOptionByName(name).flatMap(SlashCommandInteractionOption::getAttachmentValue);
    }

    default public Optional<SlashCommandInteractionOption> getOptionByIndex(int index) {
        return this.getOptions().stream().skip(index).findFirst();
    }

    default public Optional<String> getOptionStringRepresentationValueByIndex(int index) {
        return this.getOptionByIndex(index).flatMap(SlashCommandInteractionOption::getStringRepresentationValue);
    }

    default public Optional<String> getOptionStringValueByIndex(int index) {
        return this.getOptionByIndex(index).flatMap(SlashCommandInteractionOption::getStringValue);
    }

    default public Optional<Long> getOptionLongValueByIndex(int index) {
        return this.getOptionByIndex(index).flatMap(SlashCommandInteractionOption::getLongValue);
    }

    default public Optional<Boolean> getOptionBooleanValueByIndex(int index) {
        return this.getOptionByIndex(index).flatMap(SlashCommandInteractionOption::getBooleanValue);
    }

    default public Optional<User> getOptionUserValueByIndex(int index) {
        return this.getOptionByIndex(index).flatMap(SlashCommandInteractionOption::getUserValue);
    }

    default public Optional<CompletableFuture<User>> requestOptionUserValueByIndex(int index) {
        return this.getOptionByIndex(index).flatMap(SlashCommandInteractionOption::requestUserValue);
    }

    default public Optional<ServerChannel> getOptionChannelValueByIndex(int index) {
        return this.getOptionByIndex(index).flatMap(SlashCommandInteractionOption::getChannelValue);
    }

    default public Optional<Role> getOptionRoleValueByIndex(int index) {
        return this.getOptionByIndex(index).flatMap(SlashCommandInteractionOption::getRoleValue);
    }

    default public Optional<Mentionable> getOptionMentionableValueByIndex(int index) {
        return this.getOptionByIndex(index).flatMap(SlashCommandInteractionOption::getMentionableValue);
    }

    default public Optional<CompletableFuture<Mentionable>> requestOptionMentionableValueByIndex(int index) {
        return this.getOptionByIndex(index).flatMap(SlashCommandInteractionOption::requestMentionableValue);
    }

    default public Optional<Double> getOptionDecimalValueByIndex(int index) {
        return this.getOptionByIndex(index).flatMap(SlashCommandInteractionOption::getDecimalValue);
    }

    default public Optional<Attachment> getOptionAttachmentValueByIndex(int index) {
        return this.getOptionByIndex(index).flatMap(SlashCommandInteractionOption::getAttachmentValue);
    }
}

