/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.message.component;

import java.util.List;
import java.util.Optional;
import org.javacord.api.entity.message.component.LowLevelComponent;
import org.javacord.api.entity.message.component.SelectMenuBuilder;
import org.javacord.api.entity.message.component.SelectMenuOption;

public interface SelectMenu
extends LowLevelComponent {
    public Optional<String> getPlaceholder();

    public String getCustomId();

    public int getMinimumValues();

    public int getMaximumValues();

    public List<SelectMenuOption> getOptions();

    public boolean isDisabled();

    public static SelectMenu create(String customId, List<SelectMenuOption> options) {
        return new SelectMenuBuilder().setCustomId(customId).addOptions(options).build();
    }

    public static SelectMenu create(String customId, List<SelectMenuOption> options, boolean isDisabled) {
        return new SelectMenuBuilder().setCustomId(customId).addOptions(options).setDisabled(isDisabled).build();
    }

    public static SelectMenu create(String customId, String placeholder, List<SelectMenuOption> options) {
        return new SelectMenuBuilder().setCustomId(customId).setPlaceholder(placeholder).addOptions(options).build();
    }

    public static SelectMenu create(String customId, String placeholder, List<SelectMenuOption> options, boolean isDisabled) {
        return new SelectMenuBuilder().setCustomId(customId).setPlaceholder(placeholder).addOptions(options).setDisabled(isDisabled).build();
    }

    public static SelectMenu create(String customId, String placeholder, int minimumValues, int maximumValues, List<SelectMenuOption> options) {
        return new SelectMenuBuilder().setCustomId(customId).setPlaceholder(placeholder).setMinimumValues(minimumValues).setMaximumValues(maximumValues).addOptions(options).build();
    }

    public static SelectMenu create(String customId, String placeholder, int minimumValues, int maximumValues, List<SelectMenuOption> options, boolean isDisabled) {
        return new SelectMenuBuilder().setCustomId(customId).setPlaceholder(placeholder).setMinimumValues(minimumValues).setMaximumValues(maximumValues).addOptions(options).setDisabled(isDisabled).build();
    }
}

