/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.message;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.Mentionable;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.MessageAttachment;
import org.javacord.api.entity.message.MessageAuthor;
import org.javacord.api.entity.message.MessageDecoration;
import org.javacord.api.entity.message.component.HighLevelComponent;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.entity.message.internal.WebhookMessageBuilderDelegate;
import org.javacord.api.entity.message.mention.AllowedMentions;
import org.javacord.api.entity.user.User;
import org.javacord.api.entity.webhook.IncomingWebhook;
import org.javacord.api.util.DiscordRegexPattern;
import org.javacord.api.util.internal.DelegateFactory;

public class WebhookMessageBuilder {
    protected final WebhookMessageBuilderDelegate delegate = DelegateFactory.createWebhookMessageBuilderDelegate();

    public static WebhookMessageBuilder fromMessage(Message message) {
        WebhookMessageBuilder builder = new WebhookMessageBuilder().setDisplayAvatar(message.getAuthor().getAvatar()).setDisplayName(message.getAuthor().getDisplayName());
        builder.getStringBuilder().append(message.getContent());
        if (!message.getEmbeds().isEmpty()) {
            message.getEmbeds().forEach(embed -> builder.addEmbed(embed.toBuilder()));
        }
        for (MessageAttachment attachment : message.getAttachments()) {
            builder.addAttachment(attachment.getUrl());
        }
        return builder;
    }

    public WebhookMessageBuilder appendCode(String language, String code) {
        this.delegate.appendCode(language, code);
        return this;
    }

    public WebhookMessageBuilder append(String message, MessageDecoration ... decorations) {
        this.delegate.append(message, decorations);
        return this;
    }

    public WebhookMessageBuilder append(Mentionable entity) {
        this.delegate.append(entity);
        return this;
    }

    public WebhookMessageBuilder append(Object object) {
        this.delegate.append(object);
        return this;
    }

    public WebhookMessageBuilder appendNewLine() {
        this.delegate.appendNewLine();
        return this;
    }

    public WebhookMessageBuilder addComponents(HighLevelComponent ... components) {
        this.delegate.addComponents(components);
        return this;
    }

    public WebhookMessageBuilder removeAllComponents() {
        this.delegate.removeAllComponents();
        return this;
    }

    public WebhookMessageBuilder removeComponent(int index) {
        this.delegate.removeComponent(index);
        return this;
    }

    public WebhookMessageBuilder removeComponent(HighLevelComponent builder) {
        this.delegate.removeComponent(builder);
        return this;
    }

    public WebhookMessageBuilder setContent(String content) {
        this.delegate.setContent(content);
        return this;
    }

    public WebhookMessageBuilder addEmbed(EmbedBuilder embed) {
        this.delegate.addEmbed(embed);
        return this;
    }

    public WebhookMessageBuilder addEmbeds(EmbedBuilder ... embeds) {
        this.delegate.addEmbeds(Arrays.asList(embeds));
        return this;
    }

    public WebhookMessageBuilder removeEmbed(EmbedBuilder embed) {
        this.delegate.removeEmbed(embed);
        return this;
    }

    public WebhookMessageBuilder removeEmbeds(EmbedBuilder ... embeds) {
        this.delegate.removeEmbeds(embeds);
        return this;
    }

    public WebhookMessageBuilder removeAllEmbeds() {
        this.delegate.removeAllEmbeds();
        return this;
    }

    public WebhookMessageBuilder setTts(boolean tts) {
        this.delegate.setTts(tts);
        return this;
    }

    @Deprecated
    public WebhookMessageBuilder addFile(BufferedImage image, String fileName) {
        this.delegate.addFile(image, fileName);
        return this;
    }

    @Deprecated
    public WebhookMessageBuilder addFile(File file) {
        this.delegate.addFile(file);
        return this;
    }

    @Deprecated
    public WebhookMessageBuilder addFile(Icon icon) {
        this.delegate.addFile(icon);
        return this;
    }

    @Deprecated
    public WebhookMessageBuilder addFile(URL url) {
        this.delegate.addFile(url);
        return this;
    }

    @Deprecated
    public WebhookMessageBuilder addFile(byte[] bytes, String fileName) {
        this.delegate.addFile(bytes, fileName);
        return this;
    }

    @Deprecated
    public WebhookMessageBuilder addFile(InputStream stream, String fileName) {
        this.delegate.addFile(stream, fileName);
        return this;
    }

    @Deprecated
    public WebhookMessageBuilder addFileAsSpoiler(BufferedImage image, String fileName) {
        this.delegate.addFile(image, "SPOILER_" + fileName);
        return this;
    }

    @Deprecated
    public WebhookMessageBuilder addFileAsSpoiler(File file) {
        this.delegate.addFileAsSpoiler(file);
        return this;
    }

    @Deprecated
    public WebhookMessageBuilder addFileAsSpoiler(Icon icon) {
        this.delegate.addFileAsSpoiler(icon);
        return this;
    }

    @Deprecated
    public WebhookMessageBuilder addFileAsSpoiler(URL url) {
        this.delegate.addFileAsSpoiler(url);
        return this;
    }

    @Deprecated
    public WebhookMessageBuilder addFileAsSpoiler(byte[] bytes, String fileName) {
        this.delegate.addFile(bytes, "SPOILER_" + fileName);
        return this;
    }

    @Deprecated
    public WebhookMessageBuilder addFileAsSpoiler(InputStream stream, String fileName) {
        this.delegate.addFile(stream, "SPOILER_" + fileName);
        return this;
    }

    public WebhookMessageBuilder addAttachment(BufferedImage image, String fileName) {
        this.delegate.addAttachment(image, fileName);
        return this;
    }

    public WebhookMessageBuilder addAttachment(File file) {
        this.delegate.addAttachment(file);
        return this;
    }

    public WebhookMessageBuilder addAttachment(Icon icon) {
        this.delegate.addAttachment(icon);
        return this;
    }

    public WebhookMessageBuilder addAttachment(URL url) {
        this.delegate.addAttachment(url);
        return this;
    }

    public WebhookMessageBuilder addAttachment(byte[] bytes, String fileName) {
        this.delegate.addAttachment(bytes, fileName);
        return this;
    }

    public WebhookMessageBuilder addAttachment(InputStream stream, String fileName) {
        this.delegate.addAttachment(stream, fileName);
        return this;
    }

    public WebhookMessageBuilder addAttachmentAsSpoiler(BufferedImage image, String fileName) {
        this.delegate.addAttachment(image, "SPOILER_" + fileName);
        return this;
    }

    public WebhookMessageBuilder addAttachmentAsSpoiler(File file) {
        this.delegate.addAttachmentAsSpoiler(file);
        return this;
    }

    public WebhookMessageBuilder addAttachmentAsSpoiler(Icon icon) {
        this.delegate.addAttachmentAsSpoiler(icon);
        return this;
    }

    public WebhookMessageBuilder addAttachmentAsSpoiler(URL url) {
        this.delegate.addAttachmentAsSpoiler(url);
        return this;
    }

    public WebhookMessageBuilder addAttachmentAsSpoiler(byte[] bytes, String fileName) {
        this.delegate.addAttachment(bytes, "SPOILER_" + fileName);
        return this;
    }

    public WebhookMessageBuilder addAttachmentAsSpoiler(InputStream stream, String fileName) {
        this.delegate.addAttachment(stream, "SPOILER_" + fileName);
        return this;
    }

    public WebhookMessageBuilder setAllowedMentions(AllowedMentions allowedMentions) {
        this.delegate.setAllowedMentions(allowedMentions);
        return this;
    }

    public WebhookMessageBuilder setDisplayName(String displayName) {
        this.delegate.setDisplayName(displayName);
        return this;
    }

    public WebhookMessageBuilder setDisplayAvatar(URL avatarUrl) {
        this.delegate.setDisplayAvatar(avatarUrl);
        return this;
    }

    public WebhookMessageBuilder setDisplayAvatar(Icon avatar) {
        this.delegate.setDisplayAvatar(avatar);
        return this;
    }

    public WebhookMessageBuilder setDisplayAuthor(MessageAuthor author) {
        this.delegate.setDisplayAuthor(author);
        return this;
    }

    public WebhookMessageBuilder setDisplayAuthor(User author) {
        this.delegate.setDisplayAuthor(author);
        return this;
    }

    public StringBuilder getStringBuilder() {
        return this.delegate.getStringBuilder();
    }

    public CompletableFuture<Message> send(IncomingWebhook webhook) {
        return this.delegate.send(webhook);
    }

    public CompletableFuture<Message> send(DiscordApi api, long webhookId, String webhookToken) {
        return this.delegate.send(api, Long.toUnsignedString(webhookId), webhookToken);
    }

    public CompletableFuture<Message> send(DiscordApi api, String webhookId, String webhookToken) {
        return this.delegate.send(api, webhookId, webhookToken);
    }

    public CompletableFuture<Message> send(DiscordApi api, String webhookUrl) throws IllegalArgumentException {
        Matcher matcher = DiscordRegexPattern.WEBHOOK_URL.matcher(webhookUrl);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The webhook url has an invalid format");
        }
        return this.send(api, matcher.group("id"), matcher.group("token"));
    }

    public CompletableFuture<Void> sendSilently(IncomingWebhook webhook) {
        return this.delegate.sendSilently(webhook);
    }

    public CompletableFuture<Void> sendSilently(DiscordApi api, long webhookId, String webhookToken) {
        return this.delegate.sendSilently(api, Long.toUnsignedString(webhookId), webhookToken);
    }

    public CompletableFuture<Void> sendSilently(DiscordApi api, String webhookId, String webhookToken) {
        return this.delegate.sendSilently(api, webhookId, webhookToken);
    }

    public CompletableFuture<Void> sendSilently(DiscordApi api, String webhookUrl) throws IllegalArgumentException {
        Matcher matcher = DiscordRegexPattern.WEBHOOK_URL.matcher(webhookUrl);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The webhook url has an invalid format");
        }
        return this.sendSilently(api, matcher.group("id"), matcher.group("token"));
    }
}

