/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.message;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.Mentionable;
import org.javacord.api.entity.message.MessageDecoration;
import org.javacord.api.entity.message.TimestampStyle;
import org.javacord.api.entity.message.component.HighLevelComponent;
import org.javacord.api.entity.message.component.LowLevelComponent;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.entity.message.internal.MessageBuilderBaseDelegate;
import org.javacord.api.entity.message.mention.AllowedMentions;
import org.javacord.api.util.internal.DelegateFactory;

abstract class MessageBuilderBase<T> {
    private final Class<T> myClass;
    protected final MessageBuilderBaseDelegate delegate = DelegateFactory.createMessageBuilderBaseDelegate();

    protected MessageBuilderBase(Class<T> myClass) {
        this.myClass = myClass;
    }

    public T addComponents(HighLevelComponent ... components) {
        this.delegate.addComponents(components);
        return this.myClass.cast(this);
    }

    public T addActionRow(LowLevelComponent ... components) {
        this.delegate.addActionRow(components);
        return this.myClass.cast(this);
    }

    public T appendCode(String language, String code) {
        this.delegate.appendCode(language, code);
        return this.myClass.cast(this);
    }

    public T appendTimestamp(long epochSeconds) {
        this.appendTimestamp(epochSeconds, TimestampStyle.SHORT_DATE_TIME);
        return this.myClass.cast(this);
    }

    public T appendTimestamp(Instant instant) {
        this.appendTimestamp(instant.getEpochSecond(), TimestampStyle.SHORT_DATE_TIME);
        return this.myClass.cast(this);
    }

    public T appendTimestamp(long epochSeconds, TimestampStyle timestampStyle) {
        this.delegate.append(timestampStyle.getTimestampTag(epochSeconds));
        return this.myClass.cast(this);
    }

    public T appendTimestamp(Instant instant, TimestampStyle timestampStyle) {
        this.appendTimestamp(instant.getEpochSecond(), timestampStyle);
        return this.myClass.cast(this);
    }

    public T append(String message, MessageDecoration ... decorations) {
        this.delegate.append(message, decorations);
        return this.myClass.cast(this);
    }

    public T append(Mentionable entity) {
        this.delegate.append(entity);
        return this.myClass.cast(this);
    }

    public T append(Object object) {
        this.delegate.append(object);
        return this.myClass.cast(this);
    }

    public T appendNewLine() {
        this.delegate.appendNewLine();
        return this.myClass.cast(this);
    }

    public T setContent(String content) {
        this.delegate.setContent(content);
        return this.myClass.cast(this);
    }

    public T removeContent() {
        this.delegate.setContent(null);
        return this.myClass.cast(this);
    }

    public T setEmbed(EmbedBuilder embed) {
        this.delegate.removeAllEmbeds();
        this.delegate.addEmbed(embed);
        return this.myClass.cast(this);
    }

    public T setEmbeds(EmbedBuilder ... embeds) {
        this.delegate.removeAllEmbeds();
        this.delegate.addEmbeds(Arrays.asList(embeds));
        return this.myClass.cast(this);
    }

    public T setEmbeds(List<EmbedBuilder> embeds) {
        this.delegate.removeAllEmbeds();
        this.delegate.addEmbeds(embeds);
        return this.myClass.cast(this);
    }

    public T addEmbed(EmbedBuilder embed) {
        this.delegate.addEmbed(embed);
        return this.myClass.cast(this);
    }

    @Deprecated
    public T addFile(BufferedImage image, String fileName) {
        this.delegate.addFile(image, fileName);
        return this.myClass.cast(this);
    }

    @Deprecated
    public T addFile(File file) {
        this.delegate.addFile(file);
        return this.myClass.cast(this);
    }

    @Deprecated
    public T addFile(Icon icon) {
        this.delegate.addFile(icon);
        return this.myClass.cast(this);
    }

    @Deprecated
    public T addFile(URL url) {
        this.delegate.addFile(url);
        return this.myClass.cast(this);
    }

    @Deprecated
    public T addFile(byte[] bytes, String fileName) {
        this.delegate.addFile(bytes, fileName);
        return this.myClass.cast(this);
    }

    @Deprecated
    public T addFile(InputStream stream, String fileName) {
        this.delegate.addFile(stream, fileName);
        return this.myClass.cast(this);
    }

    @Deprecated
    public T addFileAsSpoiler(BufferedImage image, String fileName) {
        this.delegate.addFile(image, "SPOILER_" + fileName);
        return this.myClass.cast(this);
    }

    @Deprecated
    public T addFileAsSpoiler(File file) {
        this.delegate.addFileAsSpoiler(file);
        return this.myClass.cast(this);
    }

    @Deprecated
    public T addFileAsSpoiler(Icon icon) {
        this.delegate.addFileAsSpoiler(icon);
        return this.myClass.cast(this);
    }

    @Deprecated
    public T addFileAsSpoiler(URL url) {
        this.delegate.addFileAsSpoiler(url);
        return this.myClass.cast(this);
    }

    @Deprecated
    public T addFileAsSpoiler(byte[] bytes, String fileName) {
        this.delegate.addFile(bytes, "SPOILER_" + fileName);
        return this.myClass.cast(this);
    }

    @Deprecated
    public T addFileAsSpoiler(InputStream stream, String fileName) {
        this.delegate.addFile(stream, "SPOILER_" + fileName);
        return this.myClass.cast(this);
    }

    public T addAttachment(BufferedImage image, String fileName) {
        this.delegate.addAttachment(image, fileName);
        return this.myClass.cast(this);
    }

    public T addAttachment(File file) {
        this.delegate.addAttachment(file);
        return this.myClass.cast(this);
    }

    public T addAttachment(Icon icon) {
        this.delegate.addAttachment(icon);
        return this.myClass.cast(this);
    }

    public T addAttachment(URL url) {
        this.delegate.addAttachment(url);
        return this.myClass.cast(this);
    }

    public T addAttachment(byte[] bytes, String fileName) {
        this.delegate.addAttachment(bytes, fileName);
        return this.myClass.cast(this);
    }

    public T addAttachment(InputStream stream, String fileName) {
        this.delegate.addAttachment(stream, fileName);
        return this.myClass.cast(this);
    }

    public T addAttachmentAsSpoiler(BufferedImage image, String fileName) {
        this.delegate.addAttachment(image, "SPOILER_" + fileName);
        return this.myClass.cast(this);
    }

    public T addAttachmentAsSpoiler(File file) {
        this.delegate.addAttachmentAsSpoiler(file);
        return this.myClass.cast(this);
    }

    public T addAttachmentAsSpoiler(Icon icon) {
        this.delegate.addAttachmentAsSpoiler(icon);
        return this.myClass.cast(this);
    }

    public T addAttachmentAsSpoiler(URL url) {
        this.delegate.addAttachmentAsSpoiler(url);
        return this.myClass.cast(this);
    }

    public T addAttachmentAsSpoiler(byte[] bytes, String fileName) {
        this.delegate.addAttachment(bytes, "SPOILER_" + fileName);
        return this.myClass.cast(this);
    }

    public T addAttachmentAsSpoiler(InputStream stream, String fileName) {
        this.delegate.addAttachment(stream, "SPOILER_" + fileName);
        return this.myClass.cast(this);
    }

    public T setAllowedMentions(AllowedMentions allowedMentions) {
        this.delegate.setAllowedMentions(allowedMentions);
        return this.myClass.cast(this);
    }

    public T removeAllComponents() {
        this.delegate.removeAllComponents();
        return this.myClass.cast(this);
    }

    public T addEmbeds(EmbedBuilder ... embeds) {
        this.delegate.addEmbeds(Arrays.asList(embeds));
        return this.myClass.cast(this);
    }

    public T addEmbeds(List<EmbedBuilder> embeds) {
        this.delegate.addEmbeds(embeds);
        return this.myClass.cast(this);
    }

    public T removeEmbed(EmbedBuilder embed) {
        this.delegate.removeEmbed(embed);
        return this.myClass.cast(this);
    }

    public T removeEmbeds(EmbedBuilder ... embeds) {
        this.delegate.removeEmbeds(embeds);
        return this.myClass.cast(this);
    }

    public T removeAllEmbeds() {
        this.delegate.removeAllEmbeds();
        return this.myClass.cast(this);
    }

    public T setNonce(String nonce) {
        this.delegate.setNonce(nonce);
        return this.myClass.cast(this);
    }

    public StringBuilder getStringBuilder() {
        return this.delegate.getStringBuilder();
    }
}

