/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.channel;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.audio.AudioConnection;
import org.javacord.api.entity.channel.Categorizable;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.RegularServerChannel;
import org.javacord.api.entity.channel.ServerVoiceChannelUpdater;
import org.javacord.api.entity.channel.VoiceChannel;
import org.javacord.api.entity.user.User;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelAttachableListenerManager;

public interface ServerVoiceChannel
extends RegularServerChannel,
VoiceChannel,
Categorizable,
ServerVoiceChannelAttachableListenerManager {
    default public CompletableFuture<AudioConnection> connect() {
        return this.connect(false, true);
    }

    public CompletableFuture<AudioConnection> connect(boolean var1, boolean var2);

    default public CompletableFuture<Void> disconnect() {
        return this.getServer().getAudioConnection().filter(audioConnection -> this.equals(audioConnection.getChannel())).map(AudioConnection::close).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    public int getBitrate();

    public Optional<Integer> getUserLimit();

    public Collection<Long> getConnectedUserIds();

    public Collection<User> getConnectedUsers();

    public boolean isConnected(long var1);

    default public boolean isConnected(User user) {
        return this.isConnected(user.getId());
    }

    @Override
    default public ServerVoiceChannelUpdater createUpdater() {
        return new ServerVoiceChannelUpdater(this);
    }

    default public CompletableFuture<Void> updateBitrate(int bitrate) {
        return this.createUpdater().setBitrate(bitrate).update();
    }

    default public CompletableFuture<Void> updateUserLimit(int userLimit) {
        return this.createUpdater().setUserLimit(userLimit).update();
    }

    default public CompletableFuture<Void> removeUserLimit() {
        return this.createUpdater().removeUserLimit().update();
    }

    @Override
    default public CompletableFuture<Void> updateCategory(ChannelCategory category) {
        return this.createUpdater().setCategory(category).update();
    }

    @Override
    default public CompletableFuture<Void> removeCategory() {
        return this.createUpdater().removeCategory().update();
    }

    default public Optional<? extends ServerVoiceChannel> getCurrentCachedInstance() {
        return this.getApi().getServerById(this.getServer().getId()).flatMap(server -> server.getVoiceChannelById(this.getId()));
    }

    @Override
    default public CompletableFuture<? extends ServerVoiceChannel> getLatestInstance() {
        Optional<? extends ServerVoiceChannel> currentCachedInstance = this.getCurrentCachedInstance();
        if (currentCachedInstance.isPresent()) {
            return CompletableFuture.completedFuture(currentCachedInstance.get());
        }
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(new NoSuchElementException());
        return result;
    }
}

