package org.javacord.api.listener.server.sticker;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link StickerAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface StickerAttachableListenerManager {

    /**
     * Adds a {@code StickerDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<StickerDeleteListener> addStickerDeleteListener(StickerDeleteListener listener);

    /**
     * Gets a list with all registered {@code StickerDeleteListener}s.
     *
     * @return A list with all registered {@code StickerDeleteListener}s.
     */
    List<StickerDeleteListener> getStickerDeleteListeners();

    /**
     * Adds a {@code StickerChangeNameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<StickerChangeNameListener> addStickerChangeNameListener(StickerChangeNameListener listener);

    /**
     * Gets a list with all registered {@code StickerChangeNameListener}s.
     *
     * @return A list with all registered {@code StickerChangeNameListener}s.
     */
    List<StickerChangeNameListener> getStickerChangeNameListeners();

    /**
     * Adds a {@code StickerChangeDescriptionListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<StickerChangeDescriptionListener> addStickerChangeDescriptionListener(StickerChangeDescriptionListener listener);

    /**
     * Gets a list with all registered {@code StickerChangeDescriptionListener}s.
     *
     * @return A list with all registered {@code StickerChangeDescriptionListener}s.
     */
    List<StickerChangeDescriptionListener> getStickerChangeDescriptionListeners();

    /**
     * Adds a {@code StickerChangeTagsListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<StickerChangeTagsListener> addStickerChangeTagsListener(StickerChangeTagsListener listener);

    /**
     * Gets a list with all registered {@code StickerChangeTagsListener}s.
     *
     * @return A list with all registered {@code StickerChangeTagsListener}s.
     */
    List<StickerChangeTagsListener> getStickerChangeTagsListeners();

    /**
     * Adds a listener that implements one or more {@code StickerAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends StickerAttachableListener & ObjectAttachableListener> Collection<ListenerManager<T>> addStickerAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code StickerAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends StickerAttachableListener & ObjectAttachableListener> void removeStickerAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code StickerAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code StickerAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends StickerAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getStickerAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends StickerAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
