package org.javacord.api.listener.channel;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.channel.server.thread.ServerThreadChannelCreateListener;
import org.javacord.api.listener.channel.server.thread.ServerThreadChannelDeleteListener;
import org.javacord.api.listener.channel.server.thread.ServerThreadChannelMembersUpdateListener;
import org.javacord.api.listener.channel.server.thread.ServerThreadChannelUpdateListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link ServerThreadChannelAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface ServerThreadChannelAttachableListenerManager {

    /**
     * Adds a {@code ServerThreadChannelMembersUpdateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelMembersUpdateListener> addServerThreadChannelMembersUpdateListener(ServerThreadChannelMembersUpdateListener listener);

    /**
     * Gets a list with all registered {@code ServerThreadChannelMembersUpdateListener}s.
     *
     * @return A list with all registered {@code ServerThreadChannelMembersUpdateListener}s.
     */
    List<ServerThreadChannelMembersUpdateListener> getServerThreadChannelMembersUpdateListeners();

    /**
     * Adds a {@code ServerThreadChannelUpdateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelUpdateListener> addServerThreadChannelUpdateListener(ServerThreadChannelUpdateListener listener);

    /**
     * Gets a list with all registered {@code ServerThreadChannelUpdateListener}s.
     *
     * @return A list with all registered {@code ServerThreadChannelUpdateListener}s.
     */
    List<ServerThreadChannelUpdateListener> getServerThreadChannelUpdateListeners();

    /**
     * Adds a {@code ServerThreadChannelDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelDeleteListener> addServerThreadChannelDeleteListener(ServerThreadChannelDeleteListener listener);

    /**
     * Gets a list with all registered {@code ServerThreadChannelDeleteListener}s.
     *
     * @return A list with all registered {@code ServerThreadChannelDeleteListener}s.
     */
    List<ServerThreadChannelDeleteListener> getServerThreadChannelDeleteListeners();

    /**
     * Adds a {@code ServerThreadChannelCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerThreadChannelCreateListener> addServerThreadChannelCreateListener(ServerThreadChannelCreateListener listener);

    /**
     * Gets a list with all registered {@code ServerThreadChannelCreateListener}s.
     *
     * @return A list with all registered {@code ServerThreadChannelCreateListener}s.
     */
    List<ServerThreadChannelCreateListener> getServerThreadChannelCreateListeners();

    /**
     * Adds a listener that implements one or more {@code ServerThreadChannelAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends ServerThreadChannelAttachableListener & ObjectAttachableListener> Collection<ListenerManager<T>> addServerThreadChannelAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code ServerThreadChannelAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends ServerThreadChannelAttachableListener & ObjectAttachableListener> void removeServerThreadChannelAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code ServerThreadChannelAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code ServerThreadChannelAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends ServerThreadChannelAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getServerThreadChannelAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends ServerThreadChannelAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
