package org.javacord.api.listener.server.role;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.channel.server.ServerChannelChangeOverwrittenPermissionsListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link RoleAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface RoleAttachableListenerManager {

    /**
     * Adds a {@code ServerChannelChangeOverwrittenPermissionsListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelChangeOverwrittenPermissionsListener> addServerChannelChangeOverwrittenPermissionsListener(ServerChannelChangeOverwrittenPermissionsListener listener);

    /**
     * Gets a list with all registered {@code ServerChannelChangeOverwrittenPermissionsListener}s.
     *
     * @return A list with all registered {@code ServerChannelChangeOverwrittenPermissionsListener}s.
     */
    List<ServerChannelChangeOverwrittenPermissionsListener> getServerChannelChangeOverwrittenPermissionsListeners();

    /**
     * Adds a {@code RoleChangePositionListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleChangePositionListener> addRoleChangePositionListener(RoleChangePositionListener listener);

    /**
     * Gets a list with all registered {@code RoleChangePositionListener}s.
     *
     * @return A list with all registered {@code RoleChangePositionListener}s.
     */
    List<RoleChangePositionListener> getRoleChangePositionListeners();

    /**
     * Adds a {@code UserRoleAddListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserRoleAddListener> addUserRoleAddListener(UserRoleAddListener listener);

    /**
     * Gets a list with all registered {@code UserRoleAddListener}s.
     *
     * @return A list with all registered {@code UserRoleAddListener}s.
     */
    List<UserRoleAddListener> getUserRoleAddListeners();

    /**
     * Adds a {@code RoleChangeMentionableListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleChangeMentionableListener> addRoleChangeMentionableListener(RoleChangeMentionableListener listener);

    /**
     * Gets a list with all registered {@code RoleChangeMentionableListener}s.
     *
     * @return A list with all registered {@code RoleChangeMentionableListener}s.
     */
    List<RoleChangeMentionableListener> getRoleChangeMentionableListeners();

    /**
     * Adds a {@code RoleChangeNameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleChangeNameListener> addRoleChangeNameListener(RoleChangeNameListener listener);

    /**
     * Gets a list with all registered {@code RoleChangeNameListener}s.
     *
     * @return A list with all registered {@code RoleChangeNameListener}s.
     */
    List<RoleChangeNameListener> getRoleChangeNameListeners();

    /**
     * Adds a {@code RoleChangePermissionsListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleChangePermissionsListener> addRoleChangePermissionsListener(RoleChangePermissionsListener listener);

    /**
     * Gets a list with all registered {@code RoleChangePermissionsListener}s.
     *
     * @return A list with all registered {@code RoleChangePermissionsListener}s.
     */
    List<RoleChangePermissionsListener> getRoleChangePermissionsListeners();

    /**
     * Adds a {@code RoleDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleDeleteListener> addRoleDeleteListener(RoleDeleteListener listener);

    /**
     * Gets a list with all registered {@code RoleDeleteListener}s.
     *
     * @return A list with all registered {@code RoleDeleteListener}s.
     */
    List<RoleDeleteListener> getRoleDeleteListeners();

    /**
     * Adds a {@code RoleChangeColorListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleChangeColorListener> addRoleChangeColorListener(RoleChangeColorListener listener);

    /**
     * Gets a list with all registered {@code RoleChangeColorListener}s.
     *
     * @return A list with all registered {@code RoleChangeColorListener}s.
     */
    List<RoleChangeColorListener> getRoleChangeColorListeners();

    /**
     * Adds a {@code UserRoleRemoveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserRoleRemoveListener> addUserRoleRemoveListener(UserRoleRemoveListener listener);

    /**
     * Gets a list with all registered {@code UserRoleRemoveListener}s.
     *
     * @return A list with all registered {@code UserRoleRemoveListener}s.
     */
    List<UserRoleRemoveListener> getUserRoleRemoveListeners();

    /**
     * Adds a {@code RoleChangeHoistListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleChangeHoistListener> addRoleChangeHoistListener(RoleChangeHoistListener listener);

    /**
     * Gets a list with all registered {@code RoleChangeHoistListener}s.
     *
     * @return A list with all registered {@code RoleChangeHoistListener}s.
     */
    List<RoleChangeHoistListener> getRoleChangeHoistListeners();

    /**
     * Adds a listener that implements one or more {@code RoleAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends RoleAttachableListener & ObjectAttachableListener> Collection<ListenerManager<T>> addRoleAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code RoleAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends RoleAttachableListener & ObjectAttachableListener> void removeRoleAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code RoleAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code RoleAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends RoleAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getRoleAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends RoleAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
