/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.message;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.Mentionable;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.MessageAttachment;
import org.javacord.api.entity.message.MessageDecoration;
import org.javacord.api.entity.message.Messageable;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.entity.message.internal.MessageBuilderDelegate;
import org.javacord.api.entity.message.mention.AllowedMentions;
import org.javacord.api.entity.user.User;
import org.javacord.api.entity.webhook.IncomingWebhook;
import org.javacord.api.util.DiscordRegexPattern;
import org.javacord.api.util.internal.DelegateFactory;

public class MessageBuilder {
    protected final MessageBuilderDelegate delegate = DelegateFactory.createMessageBuilderDelegate();

    public static MessageBuilder fromMessage(Message message) {
        MessageBuilder builder = new MessageBuilder();
        builder.getStringBuilder().append(message.getContent());
        if (!message.getEmbeds().isEmpty()) {
            builder.setEmbed(message.getEmbeds().get(0).toBuilder());
        }
        for (MessageAttachment attachment : message.getAttachments()) {
            builder.addAttachment(attachment.getUrl());
        }
        return builder;
    }

    public MessageBuilder appendCode(String language, String code) {
        this.delegate.appendCode(language, code);
        return this;
    }

    public MessageBuilder append(String message, MessageDecoration ... decorations) {
        this.delegate.append(message, decorations);
        return this;
    }

    public MessageBuilder append(Mentionable entity) {
        this.delegate.append(entity);
        return this;
    }

    public MessageBuilder append(Object object) {
        this.delegate.append(object);
        return this;
    }

    public MessageBuilder appendNewLine() {
        this.delegate.appendNewLine();
        return this;
    }

    public MessageBuilder setContent(String content) {
        this.delegate.setContent(content);
        return this;
    }

    public MessageBuilder setEmbed(EmbedBuilder embed) {
        this.delegate.removeAllEmbeds();
        this.delegate.addEmbed(embed);
        return this;
    }

    public MessageBuilder setTts(boolean tts) {
        this.delegate.setTts(tts);
        return this;
    }

    public MessageBuilder addFile(BufferedImage image, String fileName) {
        this.delegate.addFile(image, fileName);
        return this;
    }

    public MessageBuilder addFile(File file) {
        this.delegate.addFile(file);
        return this;
    }

    public MessageBuilder addFile(Icon icon) {
        this.delegate.addFile(icon);
        return this;
    }

    public MessageBuilder addFile(URL url) {
        this.delegate.addFile(url);
        return this;
    }

    public MessageBuilder addFile(byte[] bytes, String fileName) {
        this.delegate.addFile(bytes, fileName);
        return this;
    }

    public MessageBuilder addFile(InputStream stream, String fileName) {
        this.delegate.addFile(stream, fileName);
        return this;
    }

    public MessageBuilder addFileAsSpoiler(BufferedImage image, String fileName) {
        this.delegate.addFile(image, "SPOILER_" + fileName);
        return this;
    }

    public MessageBuilder addFileAsSpoiler(File file) {
        this.delegate.addFileAsSpoiler(file);
        return this;
    }

    public MessageBuilder addFileAsSpoiler(Icon icon) {
        this.delegate.addFileAsSpoiler(icon);
        return this;
    }

    public MessageBuilder addFileAsSpoiler(URL url) {
        this.delegate.addFileAsSpoiler(url);
        return this;
    }

    public MessageBuilder addFileAsSpoiler(byte[] bytes, String fileName) {
        this.delegate.addFile(bytes, "SPOILER_" + fileName);
        return this;
    }

    public MessageBuilder addFileAsSpoiler(InputStream stream, String fileName) {
        this.delegate.addFile(stream, "SPOILER_" + fileName);
        return this;
    }

    public MessageBuilder addAttachment(BufferedImage image, String fileName) {
        this.delegate.addAttachment(image, fileName);
        return this;
    }

    public MessageBuilder addAttachment(File file) {
        this.delegate.addAttachment(file);
        return this;
    }

    public MessageBuilder addAttachment(Icon icon) {
        this.delegate.addAttachment(icon);
        return this;
    }

    public MessageBuilder addAttachment(URL url) {
        this.delegate.addAttachment(url);
        return this;
    }

    public MessageBuilder addAttachment(byte[] bytes, String fileName) {
        this.delegate.addAttachment(bytes, fileName);
        return this;
    }

    public MessageBuilder addAttachment(InputStream stream, String fileName) {
        this.delegate.addAttachment(stream, fileName);
        return this;
    }

    public MessageBuilder addAttachmentAsSpoiler(BufferedImage image, String fileName) {
        this.delegate.addAttachment(image, "SPOILER_" + fileName);
        return this;
    }

    public MessageBuilder addAttachmentAsSpoiler(File file) {
        this.delegate.addAttachmentAsSpoiler(file);
        return this;
    }

    public MessageBuilder addAttachmentAsSpoiler(Icon icon) {
        this.delegate.addAttachmentAsSpoiler(icon);
        return this;
    }

    public MessageBuilder addAttachmentAsSpoiler(URL url) {
        this.delegate.addAttachmentAsSpoiler(url);
        return this;
    }

    public MessageBuilder addAttachmentAsSpoiler(byte[] bytes, String fileName) {
        this.delegate.addAttachment(bytes, "SPOILER_" + fileName);
        return this;
    }

    public MessageBuilder addAttachmentAsSpoiler(InputStream stream, String fileName) {
        this.delegate.addAttachment(stream, "SPOILER_" + fileName);
        return this;
    }

    public MessageBuilder setAllowedMentions(AllowedMentions allowedMentions) {
        this.delegate.setAllowedMentions(allowedMentions);
        return this;
    }

    public MessageBuilder replyTo(Message message) {
        this.delegate.replyTo(message.getId());
        return this;
    }

    public MessageBuilder replyTo(long messageId) {
        this.delegate.replyTo(messageId);
        return this;
    }

    public MessageBuilder setNonce(String nonce) {
        this.delegate.setNonce(nonce);
        return this;
    }

    public StringBuilder getStringBuilder() {
        return this.delegate.getStringBuilder();
    }

    public CompletableFuture<Message> send(User user) {
        return this.delegate.send(user);
    }

    public CompletableFuture<Message> send(TextChannel channel) {
        return this.delegate.send(channel);
    }

    public CompletableFuture<Message> send(IncomingWebhook webhook) {
        return this.delegate.send(webhook);
    }

    public CompletableFuture<Message> send(Messageable messageable) {
        return this.delegate.send(messageable);
    }

    public CompletableFuture<Message> sendWithWebhook(DiscordApi api, long webhookId, String webhookToken) {
        return this.delegate.sendWithWebhook(api, Long.toUnsignedString(webhookId), webhookToken);
    }

    public CompletableFuture<Message> sendWithWebhook(DiscordApi api, String webhookId, String webhookToken) {
        return this.delegate.sendWithWebhook(api, webhookId, webhookToken);
    }

    public CompletableFuture<Message> sendWithWebhook(DiscordApi api, String webhookUrl) throws IllegalArgumentException {
        Matcher matcher = DiscordRegexPattern.WEBHOOK_URL.matcher(webhookUrl);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The webhook url has an invalid format");
        }
        return this.sendWithWebhook(api, matcher.group("id"), matcher.group("token"));
    }
}

