/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.javacord.api.AccountType;
import org.javacord.api.AccountUpdater;
import org.javacord.api.BotInviteBuilder;
import org.javacord.api.entity.ApplicationInfo;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.Nameable;
import org.javacord.api.entity.activity.Activity;
import org.javacord.api.entity.activity.ActivityType;
import org.javacord.api.entity.channel.Channel;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.GroupChannel;
import org.javacord.api.entity.channel.PrivateChannel;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.ServerStageVoiceChannel;
import org.javacord.api.entity.channel.ServerTextChannel;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.channel.VoiceChannel;
import org.javacord.api.entity.emoji.KnownCustomEmoji;
import org.javacord.api.entity.intent.Intent;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.MessageSet;
import org.javacord.api.entity.message.UncachedMessageUtil;
import org.javacord.api.entity.permission.Permissions;
import org.javacord.api.entity.permission.Role;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.server.ServerBuilder;
import org.javacord.api.entity.server.invite.Invite;
import org.javacord.api.entity.user.User;
import org.javacord.api.entity.user.UserStatus;
import org.javacord.api.entity.webhook.IncomingWebhook;
import org.javacord.api.entity.webhook.Webhook;
import org.javacord.api.listener.GloballyAttachableListenerManager;
import org.javacord.api.util.DiscordRegexPattern;
import org.javacord.api.util.concurrent.ThreadPool;
import org.javacord.api.util.ratelimit.Ratelimiter;

public interface DiscordApi
extends GloballyAttachableListenerManager {
    public static final Pattern ESCAPED_CHARACTER = Pattern.compile("\\\\(?<char>[^a-zA-Z0-9\\p{javaWhitespace}\\xa0\\u2007\\u202E\\u202F])");

    public String getToken();

    public String getPrefixedToken();

    public Set<Intent> getIntents();

    public ThreadPool getThreadPool();

    public UncachedMessageUtil getUncachedMessageUtil();

    public AccountType getAccountType();

    public Optional<Ratelimiter> getGlobalRatelimiter();

    public Ratelimiter getGatewayIdentifyRatelimiter();

    public Duration getLatestGatewayLatency();

    public CompletableFuture<Duration> measureRestLatency();

    default public String createBotInvite() {
        return new BotInviteBuilder(this.getClientId()).build();
    }

    default public String createBotInvite(Permissions permissions) {
        return new BotInviteBuilder(this.getClientId()).setPermissions(permissions).build();
    }

    public void setMessageCacheSize(int var1, int var2);

    public int getDefaultMessageCacheCapacity();

    public int getDefaultMessageCacheStorageTimeInSeconds();

    public void setAutomaticMessageCacheCleanupEnabled(boolean var1);

    public boolean isDefaultAutomaticMessageCacheCleanupEnabled();

    public int getCurrentShard();

    public int getTotalShards();

    public boolean isWaitingForServersOnStartup();

    public boolean isWaitingForUsersOnStartup();

    public void updateStatus(UserStatus var1);

    public UserStatus getStatus();

    public void updateActivity(String var1);

    public void updateActivity(ActivityType var1, String var2);

    public void updateActivity(String var1, String var2);

    public void unsetActivity();

    public Optional<Activity> getActivity();

    public User getYourself();

    public long getOwnerId();

    default public CompletableFuture<User> getOwner() {
        return this.getUserById(this.getOwnerId());
    }

    public long getClientId();

    public void disconnect();

    public void setReconnectDelay(Function<Integer, Integer> var1);

    public int getReconnectDelay(int var1);

    public CompletableFuture<ApplicationInfo> getApplicationInfo();

    public CompletableFuture<Webhook> getWebhookById(long var1);

    public CompletableFuture<IncomingWebhook> getIncomingWebhookByIdAndToken(String var1, String var2);

    default public CompletableFuture<IncomingWebhook> getIncomingWebhookByIdAndToken(long id, String token) {
        return this.getIncomingWebhookByIdAndToken(Long.toUnsignedString(id), token);
    }

    default public CompletableFuture<IncomingWebhook> getIncomingWebhookByUrl(String url) throws IllegalArgumentException {
        Matcher matcher = DiscordRegexPattern.WEBHOOK_URL.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The webhook url has an invalid format");
        }
        return this.getIncomingWebhookByIdAndToken(matcher.group("id"), matcher.group("token"));
    }

    public Collection<Long> getUnavailableServers();

    public CompletableFuture<Invite> getInviteByCode(String var1);

    public CompletableFuture<Invite> getInviteWithMemberCountsByCode(String var1);

    default public ServerBuilder createServerBuilder() {
        return new ServerBuilder(this);
    }

    default public AccountUpdater createAccountUpdater() {
        return new AccountUpdater(this);
    }

    default public CompletableFuture<Void> updateUsername(String username) {
        return this.createAccountUpdater().setUsername(username).update();
    }

    default public CompletableFuture<Void> updateAvatar(BufferedImage avatar) {
        return this.createAccountUpdater().setAvatar(avatar).update();
    }

    default public CompletableFuture<Void> updateAvatar(BufferedImage avatar, String fileType) {
        return this.createAccountUpdater().setAvatar(avatar, fileType).update();
    }

    default public CompletableFuture<Void> updateAvatar(File avatar) {
        return this.createAccountUpdater().setAvatar(avatar).update();
    }

    default public CompletableFuture<Void> updateAvatar(Icon avatar) {
        return this.createAccountUpdater().setAvatar(avatar).update();
    }

    default public CompletableFuture<Void> updateAvatar(URL avatar) {
        return this.createAccountUpdater().setAvatar(avatar).update();
    }

    default public CompletableFuture<Void> updateAvatar(byte[] avatar) {
        return this.createAccountUpdater().setAvatar(avatar).update();
    }

    default public CompletableFuture<Void> updateAvatar(byte[] avatar, String fileType) {
        return this.createAccountUpdater().setAvatar(avatar, fileType).update();
    }

    default public CompletableFuture<Void> updateAvatar(InputStream avatar) {
        return this.createAccountUpdater().setAvatar(avatar).update();
    }

    default public CompletableFuture<Void> updateAvatar(InputStream avatar, String fileType) {
        return this.createAccountUpdater().setAvatar(avatar, fileType).update();
    }

    public boolean isUserCacheEnabled();

    default public boolean hasAllUsersInCache() {
        return !this.getServers().stream().anyMatch(Server::hasAllMembersInCache);
    }

    public Collection<User> getCachedUsers();

    public Optional<User> getCachedUserById(long var1);

    default public Optional<User> getCachedUserById(String id) {
        try {
            return this.getCachedUserById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public CompletableFuture<User> getUserById(long var1);

    default public CompletableFuture<User> getUserById(String id) {
        try {
            return this.getUserById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return this.getUserById(-1L);
        }
    }

    default public String makeMentionsReadable(String content, Server server) {
        Matcher userMention = DiscordRegexPattern.USER_MENTION.matcher(content);
        while (userMention.find()) {
            String userId = userMention.group("id");
            Optional<User> userOptional = this.getCachedUserById(userId);
            if (!userOptional.isPresent()) continue;
            User user = userOptional.get();
            String userName = server == null ? user.getName() : server.getDisplayName(user);
            content = userMention.replaceFirst(Matcher.quoteReplacement("@" + userName));
            userMention.reset(content);
        }
        Matcher roleMention = DiscordRegexPattern.ROLE_MENTION.matcher(content);
        while (roleMention.find()) {
            String roleName = this.getRoleById(roleMention.group("id")).map(Nameable::getName).orElse("deleted-role");
            content = roleMention.replaceFirst(Matcher.quoteReplacement("@" + roleName));
            roleMention.reset(content);
        }
        Matcher channelMention = DiscordRegexPattern.CHANNEL_MENTION.matcher(content);
        while (channelMention.find()) {
            String channelId = channelMention.group("id");
            String channelName = this.getServerChannelById(channelId).map(Nameable::getName).orElse("deleted-channel");
            content = channelMention.replaceFirst("#" + channelName);
            channelMention.reset(content);
        }
        Matcher customEmoji = DiscordRegexPattern.CUSTOM_EMOJI.matcher(content);
        while (customEmoji.find()) {
            String emojiId = customEmoji.group("id");
            String name = this.getCustomEmojiById(emojiId).map(Nameable::getName).orElseGet(() -> customEmoji.group("name"));
            content = customEmoji.replaceFirst(":" + name + ":");
            customEmoji.reset(content);
        }
        return ESCAPED_CHARACTER.matcher(content).replaceAll("${char}");
    }

    default public String makeMentionsReadable(String content) {
        return this.makeMentionsReadable(content, null);
    }

    default public Optional<User> getCachedUserByDiscriminatedName(String discriminatedName) {
        String[] nameAndDiscriminator = discriminatedName.split("#", 2);
        return this.getCachedUserByNameAndDiscriminator(nameAndDiscriminator[0], nameAndDiscriminator[1]);
    }

    default public Optional<User> getCachedUserByDiscriminatedNameIgnoreCase(String discriminatedName) {
        String[] nameAndDiscriminator = discriminatedName.split("#", 2);
        return this.getCachedUserByNameAndDiscriminatorIgnoreCase(nameAndDiscriminator[0], nameAndDiscriminator[1]);
    }

    default public Optional<User> getCachedUserByNameAndDiscriminator(String name, String discriminator) {
        return this.getCachedUsersByName(name).stream().filter(user -> user.getDiscriminator().equals(discriminator)).findAny();
    }

    default public Optional<User> getCachedUserByNameAndDiscriminatorIgnoreCase(String name, String discriminator) {
        return this.getCachedUsersByNameIgnoreCase(name).stream().filter(user -> user.getDiscriminator().equalsIgnoreCase(discriminator)).findAny();
    }

    default public Collection<User> getCachedUsersByName(String name) {
        return Collections.unmodifiableList(this.getCachedUsers().stream().filter(user -> user.getName().equals(name)).collect(Collectors.toList()));
    }

    default public Collection<User> getCachedUsersByNameIgnoreCase(String name) {
        return Collections.unmodifiableList(this.getCachedUsers().stream().filter(user -> user.getName().equalsIgnoreCase(name)).collect(Collectors.toList()));
    }

    default public Collection<User> getCachedUsersByNickname(String nickname, Server server) {
        return Collections.unmodifiableList(this.getCachedUsers().stream().filter(user -> user.getNickname(server).map(nickname::equals).orElse(false)).collect(Collectors.toList()));
    }

    default public Collection<User> getCachedUsersByNicknameIgnoreCase(String nickname, Server server) {
        return Collections.unmodifiableList(this.getCachedUsers().stream().filter(user -> user.getNickname(server).map(nickname::equalsIgnoreCase).orElse(false)).collect(Collectors.toList()));
    }

    default public Collection<User> getCachedUsersByDisplayName(String displayName, Server server) {
        return Collections.unmodifiableList(this.getCachedUsers().stream().filter(user -> user.getDisplayName(server).equals(displayName)).collect(Collectors.toList()));
    }

    default public Collection<User> getCachedUsersByDisplayNameIgnoreCase(String displayName, Server server) {
        return Collections.unmodifiableList(this.getCachedUsers().stream().filter(user -> user.getDisplayName(server).equalsIgnoreCase(displayName)).collect(Collectors.toList()));
    }

    public MessageSet getCachedMessages();

    public Optional<Message> getCachedMessageById(long var1);

    default public Optional<Message> getCachedMessageById(String id) {
        try {
            return this.getCachedMessageById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public CompletableFuture<Message> getMessageById(long id, TextChannel channel) {
        return channel.getMessageById(id);
    }

    default public CompletableFuture<Message> getMessageById(String id, TextChannel channel) {
        return channel.getMessageById(id);
    }

    default public Optional<CompletableFuture<Message>> getMessageByLink(String link) throws IllegalArgumentException {
        Matcher matcher = DiscordRegexPattern.MESSAGE_LINK.matcher(link);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The message link has an invalid format");
        }
        return this.getTextChannelById(matcher.group("channel")).map(textChannel -> textChannel.getMessageById(matcher.group("message")));
    }

    default public Optional<Message> getCachedMessageByLink(String link) throws IllegalArgumentException {
        Matcher matcher = DiscordRegexPattern.MESSAGE_LINK.matcher(link);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The message link has an invalid format");
        }
        return this.getCachedMessageById(matcher.group("message")).filter(message -> message.getChannel().getIdAsString().equals(matcher.group("channel")));
    }

    public Collection<Server> getServers();

    default public Optional<Server> getServerById(long id) {
        return this.getServers().stream().filter(server -> server.getId() == id).findAny();
    }

    default public Optional<Server> getServerById(String id) {
        try {
            return this.getServerById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Collection<Server> getServersByName(String name) {
        return Collections.unmodifiableList(this.getServers().stream().filter(server -> server.getName().equals(name)).collect(Collectors.toList()));
    }

    default public Collection<Server> getServersByNameIgnoreCase(String name) {
        return Collections.unmodifiableList(this.getServers().stream().filter(server -> server.getName().equalsIgnoreCase(name)).collect(Collectors.toList()));
    }

    public Collection<KnownCustomEmoji> getCustomEmojis();

    default public Optional<KnownCustomEmoji> getCustomEmojiById(long id) {
        return this.getCustomEmojis().stream().filter(emoji -> emoji.getId() == id).findAny();
    }

    default public Optional<KnownCustomEmoji> getCustomEmojiById(String id) {
        try {
            return this.getCustomEmojiById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Collection<KnownCustomEmoji> getCustomEmojisByName(String name) {
        return Collections.unmodifiableList(this.getCustomEmojis().stream().filter(emoji -> emoji.getName().equals(name)).collect(Collectors.toList()));
    }

    default public Collection<KnownCustomEmoji> getCustomEmojisByNameIgnoreCase(String name) {
        return Collections.unmodifiableList(this.getCustomEmojis().stream().filter(emoji -> emoji.getName().equalsIgnoreCase(name)).collect(Collectors.toList()));
    }

    default public Collection<Role> getRoles() {
        HashSet roles = new HashSet();
        this.getServers().stream().map(Server::getRoles).forEach(roles::addAll);
        return Collections.unmodifiableCollection(roles);
    }

    default public Optional<Role> getRoleById(long id) {
        return this.getServers().stream().map(server -> server.getRoleById(id)).filter(Optional::isPresent).map(Optional::get).findAny();
    }

    default public Optional<Role> getRoleById(String id) {
        try {
            return this.getRoleById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Collection<Role> getRolesByName(String name) {
        return Collections.unmodifiableList(this.getRoles().stream().filter(role -> role.getName().equals(name)).collect(Collectors.toList()));
    }

    default public Collection<Role> getRolesByNameIgnoreCase(String name) {
        return Collections.unmodifiableList(this.getRoles().stream().filter(role -> role.getName().equalsIgnoreCase(name)).collect(Collectors.toList()));
    }

    public Collection<Channel> getChannels();

    public Collection<GroupChannel> getGroupChannels();

    public Collection<PrivateChannel> getPrivateChannels();

    public Collection<ServerChannel> getServerChannels();

    public Collection<ChannelCategory> getChannelCategories();

    public Collection<ServerTextChannel> getServerTextChannels();

    public Collection<ServerVoiceChannel> getServerVoiceChannels();

    public Collection<ServerStageVoiceChannel> getServerStageVoiceChannels();

    public Collection<TextChannel> getTextChannels();

    public Collection<VoiceChannel> getVoiceChannels();

    public Optional<Channel> getChannelById(long var1);

    default public Optional<Channel> getChannelById(String id) {
        try {
            return this.getChannelById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Collection<Channel> getChannelsByName(String name) {
        HashSet<Channel> channels = new HashSet<Channel>();
        channels.addAll(this.getServerChannelsByName(name));
        channels.addAll(this.getGroupChannelsByName(name));
        return Collections.unmodifiableCollection(channels);
    }

    default public Collection<Channel> getChannelsByNameIgnoreCase(String name) {
        HashSet<Channel> channels = new HashSet<Channel>();
        channels.addAll(this.getServerChannelsByNameIgnoreCase(name));
        channels.addAll(this.getGroupChannelsByNameIgnoreCase(name));
        return Collections.unmodifiableCollection(channels);
    }

    default public Optional<TextChannel> getTextChannelById(long id) {
        return this.getChannelById(id).flatMap(Channel::asTextChannel);
    }

    default public Optional<TextChannel> getTextChannelById(String id) {
        try {
            return this.getTextChannelById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Collection<TextChannel> getTextChannelsByName(String name) {
        HashSet<TextChannel> channels = new HashSet<TextChannel>();
        channels.addAll(this.getServerTextChannelsByName(name));
        channels.addAll(this.getGroupChannelsByName(name));
        return Collections.unmodifiableCollection(channels);
    }

    default public Collection<TextChannel> getTextChannelsByNameIgnoreCase(String name) {
        HashSet<TextChannel> channels = new HashSet<TextChannel>();
        channels.addAll(this.getServerTextChannelsByNameIgnoreCase(name));
        channels.addAll(this.getGroupChannelsByNameIgnoreCase(name));
        return Collections.unmodifiableCollection(channels);
    }

    default public Optional<VoiceChannel> getVoiceChannelById(long id) {
        return this.getChannelById(id).flatMap(Channel::asVoiceChannel);
    }

    default public Optional<VoiceChannel> getVoiceChannelById(String id) {
        try {
            return this.getVoiceChannelById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Collection<VoiceChannel> getVoiceChannelsByName(String name) {
        HashSet<VoiceChannel> channels = new HashSet<VoiceChannel>();
        channels.addAll(this.getServerVoiceChannelsByName(name));
        channels.addAll(this.getGroupChannelsByName(name));
        return Collections.unmodifiableCollection(channels);
    }

    default public Collection<VoiceChannel> getVoiceChannelsByNameIgnoreCase(String name) {
        HashSet<VoiceChannel> channels = new HashSet<VoiceChannel>();
        channels.addAll(this.getServerVoiceChannelsByNameIgnoreCase(name));
        channels.addAll(this.getGroupChannelsByNameIgnoreCase(name));
        return Collections.unmodifiableCollection(channels);
    }

    default public Optional<ServerChannel> getServerChannelById(long id) {
        return this.getChannelById(id).flatMap(Channel::asServerChannel);
    }

    default public Optional<ServerChannel> getServerChannelById(String id) {
        try {
            return this.getServerChannelById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Collection<ServerChannel> getServerChannelsByName(String name) {
        return Collections.unmodifiableList(this.getServerChannels().stream().filter(channel -> channel.getName().equals(name)).collect(Collectors.toList()));
    }

    default public Collection<ServerChannel> getServerChannelsByNameIgnoreCase(String name) {
        return Collections.unmodifiableList(this.getServerChannels().stream().filter(channel -> channel.getName().equalsIgnoreCase(name)).collect(Collectors.toList()));
    }

    default public Optional<ChannelCategory> getChannelCategoryById(long id) {
        return this.getChannelById(id).flatMap(Channel::asChannelCategory);
    }

    default public Optional<ChannelCategory> getChannelCategoryById(String id) {
        try {
            return this.getChannelCategoryById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Collection<ChannelCategory> getChannelCategoriesByName(String name) {
        return Collections.unmodifiableList(this.getChannelCategories().stream().filter(channel -> channel.getName().equals(name)).collect(Collectors.toList()));
    }

    default public Collection<ChannelCategory> getChannelCategoriesByNameIgnoreCase(String name) {
        return Collections.unmodifiableList(this.getChannelCategories().stream().filter(channel -> channel.getName().equalsIgnoreCase(name)).collect(Collectors.toList()));
    }

    default public Optional<ServerTextChannel> getServerTextChannelById(long id) {
        return this.getChannelById(id).flatMap(Channel::asServerTextChannel);
    }

    default public Optional<ServerTextChannel> getServerTextChannelById(String id) {
        try {
            return this.getServerTextChannelById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Collection<ServerTextChannel> getServerTextChannelsByName(String name) {
        return Collections.unmodifiableList(this.getServerTextChannels().stream().filter(channel -> channel.getName().equals(name)).collect(Collectors.toList()));
    }

    default public Collection<ServerTextChannel> getServerTextChannelsByNameIgnoreCase(String name) {
        return Collections.unmodifiableList(this.getServerTextChannels().stream().filter(channel -> channel.getName().equalsIgnoreCase(name)).collect(Collectors.toList()));
    }

    default public Optional<ServerVoiceChannel> getServerVoiceChannelById(long id) {
        return this.getChannelById(id).flatMap(Channel::asServerVoiceChannel);
    }

    default public Optional<ServerVoiceChannel> getServerVoiceChannelById(String id) {
        try {
            return this.getServerVoiceChannelById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Collection<ServerVoiceChannel> getServerVoiceChannelsByName(String name) {
        return Collections.unmodifiableList(this.getServerVoiceChannels().stream().filter(channel -> channel.getName().equals(name)).collect(Collectors.toList()));
    }

    default public Collection<ServerVoiceChannel> getServerVoiceChannelsByNameIgnoreCase(String name) {
        return Collections.unmodifiableList(this.getServerVoiceChannels().stream().filter(channel -> channel.getName().equalsIgnoreCase(name)).collect(Collectors.toList()));
    }

    default public Optional<ServerStageVoiceChannel> getServerStageVoiceChannelById(long id) {
        return this.getChannelById(id).flatMap(Channel::asServerStageVoiceChannel);
    }

    default public Optional<ServerStageVoiceChannel> getServerStageVoiceChannelById(String id) {
        try {
            return this.getServerStageVoiceChannelById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Collection<ServerStageVoiceChannel> getServerStageVoiceChannelsByName(String name) {
        return Collections.unmodifiableList(this.getServerStageVoiceChannels().stream().filter(channel -> channel.getName().equals(name)).collect(Collectors.toList()));
    }

    default public Collection<ServerStageVoiceChannel> getServerStageVoiceChannelsByNameIgnoreCase(String name) {
        return Collections.unmodifiableList(this.getServerStageVoiceChannels().stream().filter(channel -> channel.getName().equalsIgnoreCase(name)).collect(Collectors.toList()));
    }

    default public Optional<PrivateChannel> getPrivateChannelById(long id) {
        return this.getChannelById(id).flatMap(Channel::asPrivateChannel);
    }

    default public Optional<PrivateChannel> getPrivateChannelById(String id) {
        try {
            return this.getPrivateChannelById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Optional<GroupChannel> getGroupChannelById(long id) {
        return this.getChannelById(id).flatMap(Channel::asGroupChannel);
    }

    default public Optional<GroupChannel> getGroupChannelById(String id) {
        try {
            return this.getGroupChannelById(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Collection<GroupChannel> getGroupChannelsByName(String name) {
        return Collections.unmodifiableList(this.getGroupChannels().stream().filter(channel -> Objects.deepEquals(channel.getName().orElse(null), name)).collect(Collectors.toList()));
    }

    default public Collection<GroupChannel> getGroupChannelsByNameIgnoreCase(String name) {
        return Collections.unmodifiableList(this.getGroupChannels().stream().filter(channel -> {
            String channelName = channel.getName().orElse(null);
            if (name == null || channelName == null) {
                return Objects.deepEquals(channelName, name);
            }
            return name.equalsIgnoreCase(channelName);
        }).collect(Collectors.toList()));
    }
}

