package org.javacord.api.listener.user;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.channel.group.GroupChannelChangeNameListener;
import org.javacord.api.listener.channel.group.GroupChannelCreateListener;
import org.javacord.api.listener.channel.group.GroupChannelDeleteListener;
import org.javacord.api.listener.channel.server.ServerChannelChangeOverwrittenPermissionsListener;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelMemberJoinListener;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelMemberLeaveListener;
import org.javacord.api.listener.channel.user.PrivateChannelCreateListener;
import org.javacord.api.listener.channel.user.PrivateChannelDeleteListener;
import org.javacord.api.listener.message.MessageCreateListener;
import org.javacord.api.listener.message.reaction.ReactionAddListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveListener;
import org.javacord.api.listener.server.member.ServerMemberBanListener;
import org.javacord.api.listener.server.member.ServerMemberJoinListener;
import org.javacord.api.listener.server.member.ServerMemberLeaveListener;
import org.javacord.api.listener.server.member.ServerMemberUnbanListener;
import org.javacord.api.listener.server.role.UserRoleAddListener;
import org.javacord.api.listener.server.role.UserRoleRemoveListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link UserAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface UserAttachableListenerManager {

    /**
     * Adds a {@code UserChangeSelfMutedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeSelfMutedListener> addUserChangeSelfMutedListener(UserChangeSelfMutedListener listener);

    /**
     * Gets a list with all registered {@code UserChangeSelfMutedListener}s.
     *
     * @return A list with all registered {@code UserChangeSelfMutedListener}s.
     */
    List<UserChangeSelfMutedListener> getUserChangeSelfMutedListeners();

    /**
     * Adds a {@code UserChangeSelfDeafenedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeSelfDeafenedListener> addUserChangeSelfDeafenedListener(UserChangeSelfDeafenedListener listener);

    /**
     * Gets a list with all registered {@code UserChangeSelfDeafenedListener}s.
     *
     * @return A list with all registered {@code UserChangeSelfDeafenedListener}s.
     */
    List<UserChangeSelfDeafenedListener> getUserChangeSelfDeafenedListeners();

    /**
     * Adds a {@code UserChangeDiscriminatorListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeDiscriminatorListener> addUserChangeDiscriminatorListener(UserChangeDiscriminatorListener listener);

    /**
     * Gets a list with all registered {@code UserChangeDiscriminatorListener}s.
     *
     * @return A list with all registered {@code UserChangeDiscriminatorListener}s.
     */
    List<UserChangeDiscriminatorListener> getUserChangeDiscriminatorListeners();

    /**
     * Adds a {@code UserChangeActivityListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeActivityListener> addUserChangeActivityListener(UserChangeActivityListener listener);

    /**
     * Gets a list with all registered {@code UserChangeActivityListener}s.
     *
     * @return A list with all registered {@code UserChangeActivityListener}s.
     */
    List<UserChangeActivityListener> getUserChangeActivityListeners();

    /**
     * Adds a {@code UserChangeMutedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeMutedListener> addUserChangeMutedListener(UserChangeMutedListener listener);

    /**
     * Gets a list with all registered {@code UserChangeMutedListener}s.
     *
     * @return A list with all registered {@code UserChangeMutedListener}s.
     */
    List<UserChangeMutedListener> getUserChangeMutedListeners();

    /**
     * Adds a {@code UserChangeDeafenedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeDeafenedListener> addUserChangeDeafenedListener(UserChangeDeafenedListener listener);

    /**
     * Gets a list with all registered {@code UserChangeDeafenedListener}s.
     *
     * @return A list with all registered {@code UserChangeDeafenedListener}s.
     */
    List<UserChangeDeafenedListener> getUserChangeDeafenedListeners();

    /**
     * Adds a {@code UserStartTypingListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserStartTypingListener> addUserStartTypingListener(UserStartTypingListener listener);

    /**
     * Gets a list with all registered {@code UserStartTypingListener}s.
     *
     * @return A list with all registered {@code UserStartTypingListener}s.
     */
    List<UserStartTypingListener> getUserStartTypingListeners();

    /**
     * Adds a {@code UserChangeNicknameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeNicknameListener> addUserChangeNicknameListener(UserChangeNicknameListener listener);

    /**
     * Gets a list with all registered {@code UserChangeNicknameListener}s.
     *
     * @return A list with all registered {@code UserChangeNicknameListener}s.
     */
    List<UserChangeNicknameListener> getUserChangeNicknameListeners();

    /**
     * Adds a {@code UserChangeAvatarListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeAvatarListener> addUserChangeAvatarListener(UserChangeAvatarListener listener);

    /**
     * Gets a list with all registered {@code UserChangeAvatarListener}s.
     *
     * @return A list with all registered {@code UserChangeAvatarListener}s.
     */
    List<UserChangeAvatarListener> getUserChangeAvatarListeners();

    /**
     * Adds a {@code UserChangeStatusListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeStatusListener> addUserChangeStatusListener(UserChangeStatusListener listener);

    /**
     * Gets a list with all registered {@code UserChangeStatusListener}s.
     *
     * @return A list with all registered {@code UserChangeStatusListener}s.
     */
    List<UserChangeStatusListener> getUserChangeStatusListeners();

    /**
     * Adds a {@code UserChangeNameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeNameListener> addUserChangeNameListener(UserChangeNameListener listener);

    /**
     * Gets a list with all registered {@code UserChangeNameListener}s.
     *
     * @return A list with all registered {@code UserChangeNameListener}s.
     */
    List<UserChangeNameListener> getUserChangeNameListeners();

    /**
     * Adds a {@code GroupChannelCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<GroupChannelCreateListener> addGroupChannelCreateListener(GroupChannelCreateListener listener);

    /**
     * Gets a list with all registered {@code GroupChannelCreateListener}s.
     *
     * @return A list with all registered {@code GroupChannelCreateListener}s.
     */
    List<GroupChannelCreateListener> getGroupChannelCreateListeners();

    /**
     * Adds a {@code GroupChannelChangeNameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<GroupChannelChangeNameListener> addGroupChannelChangeNameListener(GroupChannelChangeNameListener listener);

    /**
     * Gets a list with all registered {@code GroupChannelChangeNameListener}s.
     *
     * @return A list with all registered {@code GroupChannelChangeNameListener}s.
     */
    List<GroupChannelChangeNameListener> getGroupChannelChangeNameListeners();

    /**
     * Adds a {@code GroupChannelDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<GroupChannelDeleteListener> addGroupChannelDeleteListener(GroupChannelDeleteListener listener);

    /**
     * Gets a list with all registered {@code GroupChannelDeleteListener}s.
     *
     * @return A list with all registered {@code GroupChannelDeleteListener}s.
     */
    List<GroupChannelDeleteListener> getGroupChannelDeleteListeners();

    /**
     * Adds a {@code PrivateChannelCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<PrivateChannelCreateListener> addPrivateChannelCreateListener(PrivateChannelCreateListener listener);

    /**
     * Gets a list with all registered {@code PrivateChannelCreateListener}s.
     *
     * @return A list with all registered {@code PrivateChannelCreateListener}s.
     */
    List<PrivateChannelCreateListener> getPrivateChannelCreateListeners();

    /**
     * Adds a {@code PrivateChannelDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<PrivateChannelDeleteListener> addPrivateChannelDeleteListener(PrivateChannelDeleteListener listener);

    /**
     * Gets a list with all registered {@code PrivateChannelDeleteListener}s.
     *
     * @return A list with all registered {@code PrivateChannelDeleteListener}s.
     */
    List<PrivateChannelDeleteListener> getPrivateChannelDeleteListeners();

    /**
     * Adds a {@code ServerChannelChangeOverwrittenPermissionsListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelChangeOverwrittenPermissionsListener> addServerChannelChangeOverwrittenPermissionsListener(ServerChannelChangeOverwrittenPermissionsListener listener);

    /**
     * Gets a list with all registered {@code ServerChannelChangeOverwrittenPermissionsListener}s.
     *
     * @return A list with all registered {@code ServerChannelChangeOverwrittenPermissionsListener}s.
     */
    List<ServerChannelChangeOverwrittenPermissionsListener> getServerChannelChangeOverwrittenPermissionsListeners();

    /**
     * Adds a {@code ServerVoiceChannelMemberLeaveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerVoiceChannelMemberLeaveListener> addServerVoiceChannelMemberLeaveListener(ServerVoiceChannelMemberLeaveListener listener);

    /**
     * Gets a list with all registered {@code ServerVoiceChannelMemberLeaveListener}s.
     *
     * @return A list with all registered {@code ServerVoiceChannelMemberLeaveListener}s.
     */
    List<ServerVoiceChannelMemberLeaveListener> getServerVoiceChannelMemberLeaveListeners();

    /**
     * Adds a {@code ServerVoiceChannelMemberJoinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerVoiceChannelMemberJoinListener> addServerVoiceChannelMemberJoinListener(ServerVoiceChannelMemberJoinListener listener);

    /**
     * Gets a list with all registered {@code ServerVoiceChannelMemberJoinListener}s.
     *
     * @return A list with all registered {@code ServerVoiceChannelMemberJoinListener}s.
     */
    List<ServerVoiceChannelMemberJoinListener> getServerVoiceChannelMemberJoinListeners();

    /**
     * Adds a {@code ReactionAddListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionAddListener> addReactionAddListener(ReactionAddListener listener);

    /**
     * Gets a list with all registered {@code ReactionAddListener}s.
     *
     * @return A list with all registered {@code ReactionAddListener}s.
     */
    List<ReactionAddListener> getReactionAddListeners();

    /**
     * Adds a {@code ReactionRemoveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionRemoveListener> addReactionRemoveListener(ReactionRemoveListener listener);

    /**
     * Gets a list with all registered {@code ReactionRemoveListener}s.
     *
     * @return A list with all registered {@code ReactionRemoveListener}s.
     */
    List<ReactionRemoveListener> getReactionRemoveListeners();

    /**
     * Adds a {@code MessageCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageCreateListener> addMessageCreateListener(MessageCreateListener listener);

    /**
     * Gets a list with all registered {@code MessageCreateListener}s.
     *
     * @return A list with all registered {@code MessageCreateListener}s.
     */
    List<MessageCreateListener> getMessageCreateListeners();

    /**
     * Adds a {@code UserRoleAddListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserRoleAddListener> addUserRoleAddListener(UserRoleAddListener listener);

    /**
     * Gets a list with all registered {@code UserRoleAddListener}s.
     *
     * @return A list with all registered {@code UserRoleAddListener}s.
     */
    List<UserRoleAddListener> getUserRoleAddListeners();

    /**
     * Adds a {@code UserRoleRemoveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserRoleRemoveListener> addUserRoleRemoveListener(UserRoleRemoveListener listener);

    /**
     * Gets a list with all registered {@code UserRoleRemoveListener}s.
     *
     * @return A list with all registered {@code UserRoleRemoveListener}s.
     */
    List<UserRoleRemoveListener> getUserRoleRemoveListeners();

    /**
     * Adds a {@code ServerMemberLeaveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerMemberLeaveListener> addServerMemberLeaveListener(ServerMemberLeaveListener listener);

    /**
     * Gets a list with all registered {@code ServerMemberLeaveListener}s.
     *
     * @return A list with all registered {@code ServerMemberLeaveListener}s.
     */
    List<ServerMemberLeaveListener> getServerMemberLeaveListeners();

    /**
     * Adds a {@code ServerMemberBanListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerMemberBanListener> addServerMemberBanListener(ServerMemberBanListener listener);

    /**
     * Gets a list with all registered {@code ServerMemberBanListener}s.
     *
     * @return A list with all registered {@code ServerMemberBanListener}s.
     */
    List<ServerMemberBanListener> getServerMemberBanListeners();

    /**
     * Adds a {@code ServerMemberUnbanListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerMemberUnbanListener> addServerMemberUnbanListener(ServerMemberUnbanListener listener);

    /**
     * Gets a list with all registered {@code ServerMemberUnbanListener}s.
     *
     * @return A list with all registered {@code ServerMemberUnbanListener}s.
     */
    List<ServerMemberUnbanListener> getServerMemberUnbanListeners();

    /**
     * Adds a {@code ServerMemberJoinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerMemberJoinListener> addServerMemberJoinListener(ServerMemberJoinListener listener);

    /**
     * Gets a list with all registered {@code ServerMemberJoinListener}s.
     *
     * @return A list with all registered {@code ServerMemberJoinListener}s.
     */
    List<ServerMemberJoinListener> getServerMemberJoinListeners();

    /**
     * Adds a listener that implements one or more {@code UserAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends UserAttachableListener & ObjectAttachableListener> Collection<ListenerManager<T>> addUserAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code UserAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends UserAttachableListener & ObjectAttachableListener> void removeUserAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code UserAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code UserAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends UserAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getUserAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends UserAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
