package org.javacord.api.listener.channel;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.message.CachedMessagePinListener;
import org.javacord.api.listener.message.CachedMessageUnpinListener;
import org.javacord.api.listener.message.ChannelPinsUpdateListener;
import org.javacord.api.listener.message.MessageCreateListener;
import org.javacord.api.listener.message.MessageDeleteListener;
import org.javacord.api.listener.message.MessageEditListener;
import org.javacord.api.listener.message.reaction.ReactionAddListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveAllListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveListener;
import org.javacord.api.listener.user.UserStartTypingListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link TextChannelAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface TextChannelAttachableListenerManager extends ChannelAttachableListenerManager {

    /**
     * Adds a {@code UserStartTypingListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserStartTypingListener> addUserStartTypingListener(UserStartTypingListener listener);

    /**
     * Gets a list with all registered {@code UserStartTypingListener}s.
     *
     * @return A list with all registered {@code UserStartTypingListener}s.
     */
    List<UserStartTypingListener> getUserStartTypingListeners();

    /**
     * Adds a {@code ReactionRemoveAllListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionRemoveAllListener> addReactionRemoveAllListener(ReactionRemoveAllListener listener);

    /**
     * Gets a list with all registered {@code ReactionRemoveAllListener}s.
     *
     * @return A list with all registered {@code ReactionRemoveAllListener}s.
     */
    List<ReactionRemoveAllListener> getReactionRemoveAllListeners();

    /**
     * Adds a {@code ReactionAddListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionAddListener> addReactionAddListener(ReactionAddListener listener);

    /**
     * Gets a list with all registered {@code ReactionAddListener}s.
     *
     * @return A list with all registered {@code ReactionAddListener}s.
     */
    List<ReactionAddListener> getReactionAddListeners();

    /**
     * Adds a {@code ReactionRemoveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionRemoveListener> addReactionRemoveListener(ReactionRemoveListener listener);

    /**
     * Gets a list with all registered {@code ReactionRemoveListener}s.
     *
     * @return A list with all registered {@code ReactionRemoveListener}s.
     */
    List<ReactionRemoveListener> getReactionRemoveListeners();

    /**
     * Adds a {@code MessageEditListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageEditListener> addMessageEditListener(MessageEditListener listener);

    /**
     * Gets a list with all registered {@code MessageEditListener}s.
     *
     * @return A list with all registered {@code MessageEditListener}s.
     */
    List<MessageEditListener> getMessageEditListeners();

    /**
     * Adds a {@code CachedMessageUnpinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<CachedMessageUnpinListener> addCachedMessageUnpinListener(CachedMessageUnpinListener listener);

    /**
     * Gets a list with all registered {@code CachedMessageUnpinListener}s.
     *
     * @return A list with all registered {@code CachedMessageUnpinListener}s.
     */
    List<CachedMessageUnpinListener> getCachedMessageUnpinListeners();

    /**
     * Adds a {@code ChannelPinsUpdateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ChannelPinsUpdateListener> addChannelPinsUpdateListener(ChannelPinsUpdateListener listener);

    /**
     * Gets a list with all registered {@code ChannelPinsUpdateListener}s.
     *
     * @return A list with all registered {@code ChannelPinsUpdateListener}s.
     */
    List<ChannelPinsUpdateListener> getChannelPinsUpdateListeners();

    /**
     * Adds a {@code MessageCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageCreateListener> addMessageCreateListener(MessageCreateListener listener);

    /**
     * Gets a list with all registered {@code MessageCreateListener}s.
     *
     * @return A list with all registered {@code MessageCreateListener}s.
     */
    List<MessageCreateListener> getMessageCreateListeners();

    /**
     * Adds a {@code MessageDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageDeleteListener> addMessageDeleteListener(MessageDeleteListener listener);

    /**
     * Gets a list with all registered {@code MessageDeleteListener}s.
     *
     * @return A list with all registered {@code MessageDeleteListener}s.
     */
    List<MessageDeleteListener> getMessageDeleteListeners();

    /**
     * Adds a {@code CachedMessagePinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<CachedMessagePinListener> addCachedMessagePinListener(CachedMessagePinListener listener);

    /**
     * Gets a list with all registered {@code CachedMessagePinListener}s.
     *
     * @return A list with all registered {@code CachedMessagePinListener}s.
     */
    List<CachedMessagePinListener> getCachedMessagePinListeners();

    /**
     * Adds a listener that implements one or more {@code TextChannelAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends TextChannelAttachableListener & ObjectAttachableListener> Collection<ListenerManager<? extends TextChannelAttachableListener>> addTextChannelAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code TextChannelAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends TextChannelAttachableListener & ObjectAttachableListener> void removeTextChannelAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code TextChannelAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code TextChannelAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends TextChannelAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getTextChannelAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends TextChannelAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
