/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Properties;

public class Javacord {
    public static final String VERSION;
    public static final String COMMIT_ID;
    public static final Instant BUILD_TIMESTAMP;
    public static final String DISCORD_DOMAIN = "discord.com";
    public static final String DISCORD_CDN_DOMAIN = "cdn.discordapp.com";
    public static final String DISPLAY_VERSION;
    public static final String GITHUB_URL = "https://github.com/Javacord/Javacord";
    public static final String USER_AGENT;
    public static final String DISCORD_GATEWAY_VERSION = "6";
    public static final String DISCORD_API_VERSION = "6";

    private Javacord() {
        throw new UnsupportedOperationException();
    }

    static {
        String buildTimestamp;
        String commitId;
        Properties versionProperties = new Properties();
        try {
            InputStream versionPropertiesStream = Javacord.class.getResourceAsStream("/version.properties");
            Object object = null;
            try {
                versionProperties.load(versionPropertiesStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (versionPropertiesStream != null) {
                    if (object != null) {
                        try {
                            versionPropertiesStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        versionPropertiesStream.close();
                    }
                }
            }
        }
        catch (IOException versionPropertiesStream) {
            // empty catch block
        }
        String version = versionProperties.getProperty("version", "$version");
        switch (version) {
            case "$version": {
                VERSION = "<unknown>";
                break;
            }
            default: {
                VERSION = version;
            }
        }
        switch (commitId = versionProperties.getProperty("commitId", "$commitId")) {
            case "$commitId": {
                COMMIT_ID = "<unknown>";
                break;
            }
            default: {
                COMMIT_ID = commitId;
            }
        }
        switch (buildTimestamp = versionProperties.getProperty("buildTimestamp", "$buildTimestamp")) {
            case "$buildTimestamp": {
                BUILD_TIMESTAMP = null;
                break;
            }
            default: {
                BUILD_TIMESTAMP = Instant.parse(buildTimestamp);
            }
        }
        DISPLAY_VERSION = version.endsWith("-SNAPSHOT") ? String.format("%s [%s | %s]", VERSION, COMMIT_ID, BUILD_TIMESTAMP) : VERSION;
        USER_AGENT = "DiscordBot (https://github.com/Javacord/Javacord, v" + DISPLAY_VERSION + ")";
    }
}

