package org.javacord.api.listener.channel.server;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.channel.ChannelAttachableListenerManager;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link ServerChannelAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface ServerChannelAttachableListenerManager extends ChannelAttachableListenerManager {

    /**
     * Adds a {@code ServerChannelChangePositionListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelChangePositionListener> addServerChannelChangePositionListener(ServerChannelChangePositionListener listener);

    /**
     * Gets a list with all registered {@code ServerChannelChangePositionListener}s.
     *
     * @return A list with all registered {@code ServerChannelChangePositionListener}s.
     */
    List<ServerChannelChangePositionListener> getServerChannelChangePositionListeners();

    /**
     * Adds a {@code ServerChannelChangeOverwrittenPermissionsListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelChangeOverwrittenPermissionsListener> addServerChannelChangeOverwrittenPermissionsListener(ServerChannelChangeOverwrittenPermissionsListener listener);

    /**
     * Gets a list with all registered {@code ServerChannelChangeOverwrittenPermissionsListener}s.
     *
     * @return A list with all registered {@code ServerChannelChangeOverwrittenPermissionsListener}s.
     */
    List<ServerChannelChangeOverwrittenPermissionsListener> getServerChannelChangeOverwrittenPermissionsListeners();

    /**
     * Adds a {@code ServerChannelDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelDeleteListener> addServerChannelDeleteListener(ServerChannelDeleteListener listener);

    /**
     * Gets a list with all registered {@code ServerChannelDeleteListener}s.
     *
     * @return A list with all registered {@code ServerChannelDeleteListener}s.
     */
    List<ServerChannelDeleteListener> getServerChannelDeleteListeners();

    /**
     * Adds a {@code ServerChannelChangeNameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelChangeNameListener> addServerChannelChangeNameListener(ServerChannelChangeNameListener listener);

    /**
     * Gets a list with all registered {@code ServerChannelChangeNameListener}s.
     *
     * @return A list with all registered {@code ServerChannelChangeNameListener}s.
     */
    List<ServerChannelChangeNameListener> getServerChannelChangeNameListeners();

    /**
     * Adds a listener that implements one or more {@code ServerChannelAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends ServerChannelAttachableListener & ObjectAttachableListener> Collection<ListenerManager<? extends ServerChannelAttachableListener>> addServerChannelAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code ServerChannelAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends ServerChannelAttachableListener & ObjectAttachableListener> void removeServerChannelAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code ServerChannelAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code ServerChannelAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends ServerChannelAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getServerChannelAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends ServerChannelAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
