package org.javacord.api.listener;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Generated;
import org.javacord.api.DiscordApi;
import org.javacord.api.DiscordApiBuilder;
import org.javacord.api.listener.channel.group.GroupChannelChangeNameListener;
import org.javacord.api.listener.channel.group.GroupChannelCreateListener;
import org.javacord.api.listener.channel.group.GroupChannelDeleteListener;
import org.javacord.api.listener.channel.server.ServerChannelChangeNameListener;
import org.javacord.api.listener.channel.server.ServerChannelChangeNsfwFlagListener;
import org.javacord.api.listener.channel.server.ServerChannelChangeOverwrittenPermissionsListener;
import org.javacord.api.listener.channel.server.ServerChannelChangePositionListener;
import org.javacord.api.listener.channel.server.ServerChannelCreateListener;
import org.javacord.api.listener.channel.server.ServerChannelDeleteListener;
import org.javacord.api.listener.channel.server.text.ServerTextChannelChangeSlowmodeListener;
import org.javacord.api.listener.channel.server.text.ServerTextChannelChangeTopicListener;
import org.javacord.api.listener.channel.server.text.WebhooksUpdateListener;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelChangeBitrateListener;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelChangeUserLimitListener;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelMemberJoinListener;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelMemberLeaveListener;
import org.javacord.api.listener.channel.user.PrivateChannelCreateListener;
import org.javacord.api.listener.channel.user.PrivateChannelDeleteListener;
import org.javacord.api.listener.connection.LostConnectionListener;
import org.javacord.api.listener.connection.ReconnectListener;
import org.javacord.api.listener.connection.ResumeListener;
import org.javacord.api.listener.message.CachedMessagePinListener;
import org.javacord.api.listener.message.CachedMessageUnpinListener;
import org.javacord.api.listener.message.ChannelPinsUpdateListener;
import org.javacord.api.listener.message.MessageCreateListener;
import org.javacord.api.listener.message.MessageDeleteListener;
import org.javacord.api.listener.message.MessageEditListener;
import org.javacord.api.listener.message.reaction.ReactionAddListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveAllListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveListener;
import org.javacord.api.listener.server.ServerBecomesAvailableListener;
import org.javacord.api.listener.server.ServerBecomesUnavailableListener;
import org.javacord.api.listener.server.ServerChangeAfkChannelListener;
import org.javacord.api.listener.server.ServerChangeAfkTimeoutListener;
import org.javacord.api.listener.server.ServerChangeBoostCountListener;
import org.javacord.api.listener.server.ServerChangeBoostLevelListener;
import org.javacord.api.listener.server.ServerChangeDefaultMessageNotificationLevelListener;
import org.javacord.api.listener.server.ServerChangeDescriptionListener;
import org.javacord.api.listener.server.ServerChangeDiscoverySplashListener;
import org.javacord.api.listener.server.ServerChangeExplicitContentFilterLevelListener;
import org.javacord.api.listener.server.ServerChangeIconListener;
import org.javacord.api.listener.server.ServerChangeModeratorsOnlyChannelListener;
import org.javacord.api.listener.server.ServerChangeMultiFactorAuthenticationLevelListener;
import org.javacord.api.listener.server.ServerChangeNameListener;
import org.javacord.api.listener.server.ServerChangeOwnerListener;
import org.javacord.api.listener.server.ServerChangePreferredLocaleListener;
import org.javacord.api.listener.server.ServerChangeRegionListener;
import org.javacord.api.listener.server.ServerChangeRulesChannelListener;
import org.javacord.api.listener.server.ServerChangeServerFeatureListener;
import org.javacord.api.listener.server.ServerChangeSplashListener;
import org.javacord.api.listener.server.ServerChangeSystemChannelListener;
import org.javacord.api.listener.server.ServerChangeVanityUrlCodeListener;
import org.javacord.api.listener.server.ServerChangeVerificationLevelListener;
import org.javacord.api.listener.server.ServerJoinListener;
import org.javacord.api.listener.server.ServerLeaveListener;
import org.javacord.api.listener.server.emoji.KnownCustomEmojiChangeNameListener;
import org.javacord.api.listener.server.emoji.KnownCustomEmojiChangeWhitelistedRolesListener;
import org.javacord.api.listener.server.emoji.KnownCustomEmojiCreateListener;
import org.javacord.api.listener.server.emoji.KnownCustomEmojiDeleteListener;
import org.javacord.api.listener.server.member.ServerMemberBanListener;
import org.javacord.api.listener.server.member.ServerMemberJoinListener;
import org.javacord.api.listener.server.member.ServerMemberLeaveListener;
import org.javacord.api.listener.server.member.ServerMemberUnbanListener;
import org.javacord.api.listener.server.role.RoleChangeColorListener;
import org.javacord.api.listener.server.role.RoleChangeHoistListener;
import org.javacord.api.listener.server.role.RoleChangeMentionableListener;
import org.javacord.api.listener.server.role.RoleChangeNameListener;
import org.javacord.api.listener.server.role.RoleChangePermissionsListener;
import org.javacord.api.listener.server.role.RoleChangePositionListener;
import org.javacord.api.listener.server.role.RoleCreateListener;
import org.javacord.api.listener.server.role.RoleDeleteListener;
import org.javacord.api.listener.server.role.UserRoleAddListener;
import org.javacord.api.listener.server.role.UserRoleRemoveListener;
import org.javacord.api.listener.user.UserChangeActivityListener;
import org.javacord.api.listener.user.UserChangeAvatarListener;
import org.javacord.api.listener.user.UserChangeDeafenedListener;
import org.javacord.api.listener.user.UserChangeDiscriminatorListener;
import org.javacord.api.listener.user.UserChangeMutedListener;
import org.javacord.api.listener.user.UserChangeNameListener;
import org.javacord.api.listener.user.UserChangeNicknameListener;
import org.javacord.api.listener.user.UserChangeSelfDeafenedListener;
import org.javacord.api.listener.user.UserChangeSelfMutedListener;
import org.javacord.api.listener.user.UserChangeStatusListener;
import org.javacord.api.listener.user.UserStartTypingListener;

/**
 * This class can be used to add and retrieve {@link GloballyAttachableListener}s on the {@link DiscordApiBuilder}.
 */
@Generated("listener-manager-generation.gradle")
public interface ChainableGloballyAttachableListenerManager {

    /**
     * Adds a {@code UserChangeSelfMutedListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeSelfMutedListener(UserChangeSelfMutedListener listener) {
        return addListener(UserChangeSelfMutedListener.class,
                           listener);
    }

    /**
     * Adds a {@code UserChangeSelfMutedListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeSelfMutedListener(Supplier<UserChangeSelfMutedListener> listenerSupplier) {
        return addListener(UserChangeSelfMutedListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code UserChangeSelfMutedListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeSelfMutedListener(Function<DiscordApi, UserChangeSelfMutedListener> listenerFunction) {
        return addListener(UserChangeSelfMutedListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code UserChangeSelfDeafenedListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeSelfDeafenedListener(UserChangeSelfDeafenedListener listener) {
        return addListener(UserChangeSelfDeafenedListener.class,
                           listener);
    }

    /**
     * Adds a {@code UserChangeSelfDeafenedListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeSelfDeafenedListener(Supplier<UserChangeSelfDeafenedListener> listenerSupplier) {
        return addListener(UserChangeSelfDeafenedListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code UserChangeSelfDeafenedListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeSelfDeafenedListener(Function<DiscordApi, UserChangeSelfDeafenedListener> listenerFunction) {
        return addListener(UserChangeSelfDeafenedListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code UserChangeDiscriminatorListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeDiscriminatorListener(UserChangeDiscriminatorListener listener) {
        return addListener(UserChangeDiscriminatorListener.class,
                           listener);
    }

    /**
     * Adds a {@code UserChangeDiscriminatorListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeDiscriminatorListener(Supplier<UserChangeDiscriminatorListener> listenerSupplier) {
        return addListener(UserChangeDiscriminatorListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code UserChangeDiscriminatorListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeDiscriminatorListener(Function<DiscordApi, UserChangeDiscriminatorListener> listenerFunction) {
        return addListener(UserChangeDiscriminatorListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code UserChangeActivityListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeActivityListener(UserChangeActivityListener listener) {
        return addListener(UserChangeActivityListener.class,
                           listener);
    }

    /**
     * Adds a {@code UserChangeActivityListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeActivityListener(Supplier<UserChangeActivityListener> listenerSupplier) {
        return addListener(UserChangeActivityListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code UserChangeActivityListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeActivityListener(Function<DiscordApi, UserChangeActivityListener> listenerFunction) {
        return addListener(UserChangeActivityListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code UserChangeMutedListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeMutedListener(UserChangeMutedListener listener) {
        return addListener(UserChangeMutedListener.class,
                           listener);
    }

    /**
     * Adds a {@code UserChangeMutedListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeMutedListener(Supplier<UserChangeMutedListener> listenerSupplier) {
        return addListener(UserChangeMutedListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code UserChangeMutedListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeMutedListener(Function<DiscordApi, UserChangeMutedListener> listenerFunction) {
        return addListener(UserChangeMutedListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code UserChangeDeafenedListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeDeafenedListener(UserChangeDeafenedListener listener) {
        return addListener(UserChangeDeafenedListener.class,
                           listener);
    }

    /**
     * Adds a {@code UserChangeDeafenedListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeDeafenedListener(Supplier<UserChangeDeafenedListener> listenerSupplier) {
        return addListener(UserChangeDeafenedListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code UserChangeDeafenedListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeDeafenedListener(Function<DiscordApi, UserChangeDeafenedListener> listenerFunction) {
        return addListener(UserChangeDeafenedListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code UserStartTypingListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserStartTypingListener(UserStartTypingListener listener) {
        return addListener(UserStartTypingListener.class,
                           listener);
    }

    /**
     * Adds a {@code UserStartTypingListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserStartTypingListener(Supplier<UserStartTypingListener> listenerSupplier) {
        return addListener(UserStartTypingListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code UserStartTypingListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserStartTypingListener(Function<DiscordApi, UserStartTypingListener> listenerFunction) {
        return addListener(UserStartTypingListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code UserChangeNicknameListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeNicknameListener(UserChangeNicknameListener listener) {
        return addListener(UserChangeNicknameListener.class,
                           listener);
    }

    /**
     * Adds a {@code UserChangeNicknameListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeNicknameListener(Supplier<UserChangeNicknameListener> listenerSupplier) {
        return addListener(UserChangeNicknameListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code UserChangeNicknameListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeNicknameListener(Function<DiscordApi, UserChangeNicknameListener> listenerFunction) {
        return addListener(UserChangeNicknameListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code UserChangeAvatarListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeAvatarListener(UserChangeAvatarListener listener) {
        return addListener(UserChangeAvatarListener.class,
                           listener);
    }

    /**
     * Adds a {@code UserChangeAvatarListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeAvatarListener(Supplier<UserChangeAvatarListener> listenerSupplier) {
        return addListener(UserChangeAvatarListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code UserChangeAvatarListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeAvatarListener(Function<DiscordApi, UserChangeAvatarListener> listenerFunction) {
        return addListener(UserChangeAvatarListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code UserChangeStatusListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeStatusListener(UserChangeStatusListener listener) {
        return addListener(UserChangeStatusListener.class,
                           listener);
    }

    /**
     * Adds a {@code UserChangeStatusListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeStatusListener(Supplier<UserChangeStatusListener> listenerSupplier) {
        return addListener(UserChangeStatusListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code UserChangeStatusListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeStatusListener(Function<DiscordApi, UserChangeStatusListener> listenerFunction) {
        return addListener(UserChangeStatusListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code UserChangeNameListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeNameListener(UserChangeNameListener listener) {
        return addListener(UserChangeNameListener.class,
                           listener);
    }

    /**
     * Adds a {@code UserChangeNameListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeNameListener(Supplier<UserChangeNameListener> listenerSupplier) {
        return addListener(UserChangeNameListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code UserChangeNameListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserChangeNameListener(Function<DiscordApi, UserChangeNameListener> listenerFunction) {
        return addListener(UserChangeNameListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ResumeListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addResumeListener(ResumeListener listener) {
        return addListener(ResumeListener.class,
                           listener);
    }

    /**
     * Adds a {@code ResumeListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addResumeListener(Supplier<ResumeListener> listenerSupplier) {
        return addListener(ResumeListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ResumeListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addResumeListener(Function<DiscordApi, ResumeListener> listenerFunction) {
        return addListener(ResumeListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code LostConnectionListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addLostConnectionListener(LostConnectionListener listener) {
        return addListener(LostConnectionListener.class,
                           listener);
    }

    /**
     * Adds a {@code LostConnectionListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addLostConnectionListener(Supplier<LostConnectionListener> listenerSupplier) {
        return addListener(LostConnectionListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code LostConnectionListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addLostConnectionListener(Function<DiscordApi, LostConnectionListener> listenerFunction) {
        return addListener(LostConnectionListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ReconnectListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addReconnectListener(ReconnectListener listener) {
        return addListener(ReconnectListener.class,
                           listener);
    }

    /**
     * Adds a {@code ReconnectListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addReconnectListener(Supplier<ReconnectListener> listenerSupplier) {
        return addListener(ReconnectListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ReconnectListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addReconnectListener(Function<DiscordApi, ReconnectListener> listenerFunction) {
        return addListener(ReconnectListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code GroupChannelCreateListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addGroupChannelCreateListener(GroupChannelCreateListener listener) {
        return addListener(GroupChannelCreateListener.class,
                           listener);
    }

    /**
     * Adds a {@code GroupChannelCreateListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addGroupChannelCreateListener(Supplier<GroupChannelCreateListener> listenerSupplier) {
        return addListener(GroupChannelCreateListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code GroupChannelCreateListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addGroupChannelCreateListener(Function<DiscordApi, GroupChannelCreateListener> listenerFunction) {
        return addListener(GroupChannelCreateListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code GroupChannelChangeNameListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addGroupChannelChangeNameListener(GroupChannelChangeNameListener listener) {
        return addListener(GroupChannelChangeNameListener.class,
                           listener);
    }

    /**
     * Adds a {@code GroupChannelChangeNameListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addGroupChannelChangeNameListener(Supplier<GroupChannelChangeNameListener> listenerSupplier) {
        return addListener(GroupChannelChangeNameListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code GroupChannelChangeNameListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addGroupChannelChangeNameListener(Function<DiscordApi, GroupChannelChangeNameListener> listenerFunction) {
        return addListener(GroupChannelChangeNameListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code GroupChannelDeleteListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addGroupChannelDeleteListener(GroupChannelDeleteListener listener) {
        return addListener(GroupChannelDeleteListener.class,
                           listener);
    }

    /**
     * Adds a {@code GroupChannelDeleteListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addGroupChannelDeleteListener(Supplier<GroupChannelDeleteListener> listenerSupplier) {
        return addListener(GroupChannelDeleteListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code GroupChannelDeleteListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addGroupChannelDeleteListener(Function<DiscordApi, GroupChannelDeleteListener> listenerFunction) {
        return addListener(GroupChannelDeleteListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code PrivateChannelCreateListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addPrivateChannelCreateListener(PrivateChannelCreateListener listener) {
        return addListener(PrivateChannelCreateListener.class,
                           listener);
    }

    /**
     * Adds a {@code PrivateChannelCreateListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addPrivateChannelCreateListener(Supplier<PrivateChannelCreateListener> listenerSupplier) {
        return addListener(PrivateChannelCreateListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code PrivateChannelCreateListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addPrivateChannelCreateListener(Function<DiscordApi, PrivateChannelCreateListener> listenerFunction) {
        return addListener(PrivateChannelCreateListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code PrivateChannelDeleteListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addPrivateChannelDeleteListener(PrivateChannelDeleteListener listener) {
        return addListener(PrivateChannelDeleteListener.class,
                           listener);
    }

    /**
     * Adds a {@code PrivateChannelDeleteListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addPrivateChannelDeleteListener(Supplier<PrivateChannelDeleteListener> listenerSupplier) {
        return addListener(PrivateChannelDeleteListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code PrivateChannelDeleteListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addPrivateChannelDeleteListener(Function<DiscordApi, PrivateChannelDeleteListener> listenerFunction) {
        return addListener(PrivateChannelDeleteListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChannelChangePositionListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelChangePositionListener(ServerChannelChangePositionListener listener) {
        return addListener(ServerChannelChangePositionListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChannelChangePositionListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelChangePositionListener(Supplier<ServerChannelChangePositionListener> listenerSupplier) {
        return addListener(ServerChannelChangePositionListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChannelChangePositionListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelChangePositionListener(Function<DiscordApi, ServerChannelChangePositionListener> listenerFunction) {
        return addListener(ServerChannelChangePositionListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChannelChangeOverwrittenPermissionsListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelChangeOverwrittenPermissionsListener(ServerChannelChangeOverwrittenPermissionsListener listener) {
        return addListener(ServerChannelChangeOverwrittenPermissionsListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChannelChangeOverwrittenPermissionsListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelChangeOverwrittenPermissionsListener(Supplier<ServerChannelChangeOverwrittenPermissionsListener> listenerSupplier) {
        return addListener(ServerChannelChangeOverwrittenPermissionsListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChannelChangeOverwrittenPermissionsListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelChangeOverwrittenPermissionsListener(Function<DiscordApi, ServerChannelChangeOverwrittenPermissionsListener> listenerFunction) {
        return addListener(ServerChannelChangeOverwrittenPermissionsListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChannelDeleteListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelDeleteListener(ServerChannelDeleteListener listener) {
        return addListener(ServerChannelDeleteListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChannelDeleteListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelDeleteListener(Supplier<ServerChannelDeleteListener> listenerSupplier) {
        return addListener(ServerChannelDeleteListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChannelDeleteListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelDeleteListener(Function<DiscordApi, ServerChannelDeleteListener> listenerFunction) {
        return addListener(ServerChannelDeleteListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChannelCreateListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelCreateListener(ServerChannelCreateListener listener) {
        return addListener(ServerChannelCreateListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChannelCreateListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelCreateListener(Supplier<ServerChannelCreateListener> listenerSupplier) {
        return addListener(ServerChannelCreateListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChannelCreateListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelCreateListener(Function<DiscordApi, ServerChannelCreateListener> listenerFunction) {
        return addListener(ServerChannelCreateListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code WebhooksUpdateListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addWebhooksUpdateListener(WebhooksUpdateListener listener) {
        return addListener(WebhooksUpdateListener.class,
                           listener);
    }

    /**
     * Adds a {@code WebhooksUpdateListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addWebhooksUpdateListener(Supplier<WebhooksUpdateListener> listenerSupplier) {
        return addListener(WebhooksUpdateListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code WebhooksUpdateListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addWebhooksUpdateListener(Function<DiscordApi, WebhooksUpdateListener> listenerFunction) {
        return addListener(WebhooksUpdateListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerTextChannelChangeSlowmodeListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerTextChannelChangeSlowmodeListener(ServerTextChannelChangeSlowmodeListener listener) {
        return addListener(ServerTextChannelChangeSlowmodeListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerTextChannelChangeSlowmodeListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerTextChannelChangeSlowmodeListener(Supplier<ServerTextChannelChangeSlowmodeListener> listenerSupplier) {
        return addListener(ServerTextChannelChangeSlowmodeListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerTextChannelChangeSlowmodeListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerTextChannelChangeSlowmodeListener(Function<DiscordApi, ServerTextChannelChangeSlowmodeListener> listenerFunction) {
        return addListener(ServerTextChannelChangeSlowmodeListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerTextChannelChangeTopicListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerTextChannelChangeTopicListener(ServerTextChannelChangeTopicListener listener) {
        return addListener(ServerTextChannelChangeTopicListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerTextChannelChangeTopicListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerTextChannelChangeTopicListener(Supplier<ServerTextChannelChangeTopicListener> listenerSupplier) {
        return addListener(ServerTextChannelChangeTopicListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerTextChannelChangeTopicListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerTextChannelChangeTopicListener(Function<DiscordApi, ServerTextChannelChangeTopicListener> listenerFunction) {
        return addListener(ServerTextChannelChangeTopicListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChannelChangeNsfwFlagListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelChangeNsfwFlagListener(ServerChannelChangeNsfwFlagListener listener) {
        return addListener(ServerChannelChangeNsfwFlagListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChannelChangeNsfwFlagListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelChangeNsfwFlagListener(Supplier<ServerChannelChangeNsfwFlagListener> listenerSupplier) {
        return addListener(ServerChannelChangeNsfwFlagListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChannelChangeNsfwFlagListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelChangeNsfwFlagListener(Function<DiscordApi, ServerChannelChangeNsfwFlagListener> listenerFunction) {
        return addListener(ServerChannelChangeNsfwFlagListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerVoiceChannelMemberLeaveListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerVoiceChannelMemberLeaveListener(ServerVoiceChannelMemberLeaveListener listener) {
        return addListener(ServerVoiceChannelMemberLeaveListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerVoiceChannelMemberLeaveListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerVoiceChannelMemberLeaveListener(Supplier<ServerVoiceChannelMemberLeaveListener> listenerSupplier) {
        return addListener(ServerVoiceChannelMemberLeaveListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerVoiceChannelMemberLeaveListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerVoiceChannelMemberLeaveListener(Function<DiscordApi, ServerVoiceChannelMemberLeaveListener> listenerFunction) {
        return addListener(ServerVoiceChannelMemberLeaveListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerVoiceChannelChangeUserLimitListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerVoiceChannelChangeUserLimitListener(ServerVoiceChannelChangeUserLimitListener listener) {
        return addListener(ServerVoiceChannelChangeUserLimitListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerVoiceChannelChangeUserLimitListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerVoiceChannelChangeUserLimitListener(Supplier<ServerVoiceChannelChangeUserLimitListener> listenerSupplier) {
        return addListener(ServerVoiceChannelChangeUserLimitListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerVoiceChannelChangeUserLimitListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerVoiceChannelChangeUserLimitListener(Function<DiscordApi, ServerVoiceChannelChangeUserLimitListener> listenerFunction) {
        return addListener(ServerVoiceChannelChangeUserLimitListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerVoiceChannelChangeBitrateListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerVoiceChannelChangeBitrateListener(ServerVoiceChannelChangeBitrateListener listener) {
        return addListener(ServerVoiceChannelChangeBitrateListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerVoiceChannelChangeBitrateListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerVoiceChannelChangeBitrateListener(Supplier<ServerVoiceChannelChangeBitrateListener> listenerSupplier) {
        return addListener(ServerVoiceChannelChangeBitrateListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerVoiceChannelChangeBitrateListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerVoiceChannelChangeBitrateListener(Function<DiscordApi, ServerVoiceChannelChangeBitrateListener> listenerFunction) {
        return addListener(ServerVoiceChannelChangeBitrateListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerVoiceChannelMemberJoinListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerVoiceChannelMemberJoinListener(ServerVoiceChannelMemberJoinListener listener) {
        return addListener(ServerVoiceChannelMemberJoinListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerVoiceChannelMemberJoinListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerVoiceChannelMemberJoinListener(Supplier<ServerVoiceChannelMemberJoinListener> listenerSupplier) {
        return addListener(ServerVoiceChannelMemberJoinListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerVoiceChannelMemberJoinListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerVoiceChannelMemberJoinListener(Function<DiscordApi, ServerVoiceChannelMemberJoinListener> listenerFunction) {
        return addListener(ServerVoiceChannelMemberJoinListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChannelChangeNameListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelChangeNameListener(ServerChannelChangeNameListener listener) {
        return addListener(ServerChannelChangeNameListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChannelChangeNameListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelChangeNameListener(Supplier<ServerChannelChangeNameListener> listenerSupplier) {
        return addListener(ServerChannelChangeNameListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChannelChangeNameListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChannelChangeNameListener(Function<DiscordApi, ServerChannelChangeNameListener> listenerFunction) {
        return addListener(ServerChannelChangeNameListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ReactionRemoveAllListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addReactionRemoveAllListener(ReactionRemoveAllListener listener) {
        return addListener(ReactionRemoveAllListener.class,
                           listener);
    }

    /**
     * Adds a {@code ReactionRemoveAllListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addReactionRemoveAllListener(Supplier<ReactionRemoveAllListener> listenerSupplier) {
        return addListener(ReactionRemoveAllListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ReactionRemoveAllListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addReactionRemoveAllListener(Function<DiscordApi, ReactionRemoveAllListener> listenerFunction) {
        return addListener(ReactionRemoveAllListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ReactionAddListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addReactionAddListener(ReactionAddListener listener) {
        return addListener(ReactionAddListener.class,
                           listener);
    }

    /**
     * Adds a {@code ReactionAddListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addReactionAddListener(Supplier<ReactionAddListener> listenerSupplier) {
        return addListener(ReactionAddListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ReactionAddListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addReactionAddListener(Function<DiscordApi, ReactionAddListener> listenerFunction) {
        return addListener(ReactionAddListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ReactionRemoveListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addReactionRemoveListener(ReactionRemoveListener listener) {
        return addListener(ReactionRemoveListener.class,
                           listener);
    }

    /**
     * Adds a {@code ReactionRemoveListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addReactionRemoveListener(Supplier<ReactionRemoveListener> listenerSupplier) {
        return addListener(ReactionRemoveListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ReactionRemoveListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addReactionRemoveListener(Function<DiscordApi, ReactionRemoveListener> listenerFunction) {
        return addListener(ReactionRemoveListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code MessageEditListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addMessageEditListener(MessageEditListener listener) {
        return addListener(MessageEditListener.class,
                           listener);
    }

    /**
     * Adds a {@code MessageEditListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addMessageEditListener(Supplier<MessageEditListener> listenerSupplier) {
        return addListener(MessageEditListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code MessageEditListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addMessageEditListener(Function<DiscordApi, MessageEditListener> listenerFunction) {
        return addListener(MessageEditListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code CachedMessageUnpinListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addCachedMessageUnpinListener(CachedMessageUnpinListener listener) {
        return addListener(CachedMessageUnpinListener.class,
                           listener);
    }

    /**
     * Adds a {@code CachedMessageUnpinListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addCachedMessageUnpinListener(Supplier<CachedMessageUnpinListener> listenerSupplier) {
        return addListener(CachedMessageUnpinListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code CachedMessageUnpinListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addCachedMessageUnpinListener(Function<DiscordApi, CachedMessageUnpinListener> listenerFunction) {
        return addListener(CachedMessageUnpinListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ChannelPinsUpdateListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addChannelPinsUpdateListener(ChannelPinsUpdateListener listener) {
        return addListener(ChannelPinsUpdateListener.class,
                           listener);
    }

    /**
     * Adds a {@code ChannelPinsUpdateListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addChannelPinsUpdateListener(Supplier<ChannelPinsUpdateListener> listenerSupplier) {
        return addListener(ChannelPinsUpdateListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ChannelPinsUpdateListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addChannelPinsUpdateListener(Function<DiscordApi, ChannelPinsUpdateListener> listenerFunction) {
        return addListener(ChannelPinsUpdateListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code MessageCreateListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addMessageCreateListener(MessageCreateListener listener) {
        return addListener(MessageCreateListener.class,
                           listener);
    }

    /**
     * Adds a {@code MessageCreateListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addMessageCreateListener(Supplier<MessageCreateListener> listenerSupplier) {
        return addListener(MessageCreateListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code MessageCreateListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addMessageCreateListener(Function<DiscordApi, MessageCreateListener> listenerFunction) {
        return addListener(MessageCreateListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code MessageDeleteListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addMessageDeleteListener(MessageDeleteListener listener) {
        return addListener(MessageDeleteListener.class,
                           listener);
    }

    /**
     * Adds a {@code MessageDeleteListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addMessageDeleteListener(Supplier<MessageDeleteListener> listenerSupplier) {
        return addListener(MessageDeleteListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code MessageDeleteListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addMessageDeleteListener(Function<DiscordApi, MessageDeleteListener> listenerFunction) {
        return addListener(MessageDeleteListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code CachedMessagePinListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addCachedMessagePinListener(CachedMessagePinListener listener) {
        return addListener(CachedMessagePinListener.class,
                           listener);
    }

    /**
     * Adds a {@code CachedMessagePinListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addCachedMessagePinListener(Supplier<CachedMessagePinListener> listenerSupplier) {
        return addListener(CachedMessagePinListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code CachedMessagePinListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addCachedMessagePinListener(Function<DiscordApi, CachedMessagePinListener> listenerFunction) {
        return addListener(CachedMessagePinListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeDescriptionListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeDescriptionListener(ServerChangeDescriptionListener listener) {
        return addListener(ServerChangeDescriptionListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeDescriptionListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeDescriptionListener(Supplier<ServerChangeDescriptionListener> listenerSupplier) {
        return addListener(ServerChangeDescriptionListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeDescriptionListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeDescriptionListener(Function<DiscordApi, ServerChangeDescriptionListener> listenerFunction) {
        return addListener(ServerChangeDescriptionListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeDefaultMessageNotificationLevelListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeDefaultMessageNotificationLevelListener(ServerChangeDefaultMessageNotificationLevelListener listener) {
        return addListener(ServerChangeDefaultMessageNotificationLevelListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeDefaultMessageNotificationLevelListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeDefaultMessageNotificationLevelListener(Supplier<ServerChangeDefaultMessageNotificationLevelListener> listenerSupplier) {
        return addListener(ServerChangeDefaultMessageNotificationLevelListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeDefaultMessageNotificationLevelListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeDefaultMessageNotificationLevelListener(Function<DiscordApi, ServerChangeDefaultMessageNotificationLevelListener> listenerFunction) {
        return addListener(ServerChangeDefaultMessageNotificationLevelListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeSystemChannelListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeSystemChannelListener(ServerChangeSystemChannelListener listener) {
        return addListener(ServerChangeSystemChannelListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeSystemChannelListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeSystemChannelListener(Supplier<ServerChangeSystemChannelListener> listenerSupplier) {
        return addListener(ServerChangeSystemChannelListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeSystemChannelListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeSystemChannelListener(Function<DiscordApi, ServerChangeSystemChannelListener> listenerFunction) {
        return addListener(ServerChangeSystemChannelListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeRegionListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeRegionListener(ServerChangeRegionListener listener) {
        return addListener(ServerChangeRegionListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeRegionListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeRegionListener(Supplier<ServerChangeRegionListener> listenerSupplier) {
        return addListener(ServerChangeRegionListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeRegionListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeRegionListener(Function<DiscordApi, ServerChangeRegionListener> listenerFunction) {
        return addListener(ServerChangeRegionListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeVerificationLevelListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeVerificationLevelListener(ServerChangeVerificationLevelListener listener) {
        return addListener(ServerChangeVerificationLevelListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeVerificationLevelListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeVerificationLevelListener(Supplier<ServerChangeVerificationLevelListener> listenerSupplier) {
        return addListener(ServerChangeVerificationLevelListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeVerificationLevelListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeVerificationLevelListener(Function<DiscordApi, ServerChangeVerificationLevelListener> listenerFunction) {
        return addListener(ServerChangeVerificationLevelListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeBoostCountListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeBoostCountListener(ServerChangeBoostCountListener listener) {
        return addListener(ServerChangeBoostCountListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeBoostCountListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeBoostCountListener(Supplier<ServerChangeBoostCountListener> listenerSupplier) {
        return addListener(ServerChangeBoostCountListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeBoostCountListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeBoostCountListener(Function<DiscordApi, ServerChangeBoostCountListener> listenerFunction) {
        return addListener(ServerChangeBoostCountListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code RoleChangePositionListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangePositionListener(RoleChangePositionListener listener) {
        return addListener(RoleChangePositionListener.class,
                           listener);
    }

    /**
     * Adds a {@code RoleChangePositionListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangePositionListener(Supplier<RoleChangePositionListener> listenerSupplier) {
        return addListener(RoleChangePositionListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code RoleChangePositionListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangePositionListener(Function<DiscordApi, RoleChangePositionListener> listenerFunction) {
        return addListener(RoleChangePositionListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code UserRoleAddListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserRoleAddListener(UserRoleAddListener listener) {
        return addListener(UserRoleAddListener.class,
                           listener);
    }

    /**
     * Adds a {@code UserRoleAddListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserRoleAddListener(Supplier<UserRoleAddListener> listenerSupplier) {
        return addListener(UserRoleAddListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code UserRoleAddListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserRoleAddListener(Function<DiscordApi, UserRoleAddListener> listenerFunction) {
        return addListener(UserRoleAddListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code RoleChangeMentionableListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangeMentionableListener(RoleChangeMentionableListener listener) {
        return addListener(RoleChangeMentionableListener.class,
                           listener);
    }

    /**
     * Adds a {@code RoleChangeMentionableListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangeMentionableListener(Supplier<RoleChangeMentionableListener> listenerSupplier) {
        return addListener(RoleChangeMentionableListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code RoleChangeMentionableListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangeMentionableListener(Function<DiscordApi, RoleChangeMentionableListener> listenerFunction) {
        return addListener(RoleChangeMentionableListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code RoleChangeNameListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangeNameListener(RoleChangeNameListener listener) {
        return addListener(RoleChangeNameListener.class,
                           listener);
    }

    /**
     * Adds a {@code RoleChangeNameListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangeNameListener(Supplier<RoleChangeNameListener> listenerSupplier) {
        return addListener(RoleChangeNameListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code RoleChangeNameListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangeNameListener(Function<DiscordApi, RoleChangeNameListener> listenerFunction) {
        return addListener(RoleChangeNameListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code RoleChangePermissionsListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangePermissionsListener(RoleChangePermissionsListener listener) {
        return addListener(RoleChangePermissionsListener.class,
                           listener);
    }

    /**
     * Adds a {@code RoleChangePermissionsListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangePermissionsListener(Supplier<RoleChangePermissionsListener> listenerSupplier) {
        return addListener(RoleChangePermissionsListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code RoleChangePermissionsListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangePermissionsListener(Function<DiscordApi, RoleChangePermissionsListener> listenerFunction) {
        return addListener(RoleChangePermissionsListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code RoleDeleteListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleDeleteListener(RoleDeleteListener listener) {
        return addListener(RoleDeleteListener.class,
                           listener);
    }

    /**
     * Adds a {@code RoleDeleteListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleDeleteListener(Supplier<RoleDeleteListener> listenerSupplier) {
        return addListener(RoleDeleteListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code RoleDeleteListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleDeleteListener(Function<DiscordApi, RoleDeleteListener> listenerFunction) {
        return addListener(RoleDeleteListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code RoleChangeColorListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangeColorListener(RoleChangeColorListener listener) {
        return addListener(RoleChangeColorListener.class,
                           listener);
    }

    /**
     * Adds a {@code RoleChangeColorListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangeColorListener(Supplier<RoleChangeColorListener> listenerSupplier) {
        return addListener(RoleChangeColorListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code RoleChangeColorListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangeColorListener(Function<DiscordApi, RoleChangeColorListener> listenerFunction) {
        return addListener(RoleChangeColorListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code UserRoleRemoveListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserRoleRemoveListener(UserRoleRemoveListener listener) {
        return addListener(UserRoleRemoveListener.class,
                           listener);
    }

    /**
     * Adds a {@code UserRoleRemoveListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserRoleRemoveListener(Supplier<UserRoleRemoveListener> listenerSupplier) {
        return addListener(UserRoleRemoveListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code UserRoleRemoveListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addUserRoleRemoveListener(Function<DiscordApi, UserRoleRemoveListener> listenerFunction) {
        return addListener(UserRoleRemoveListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code RoleCreateListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleCreateListener(RoleCreateListener listener) {
        return addListener(RoleCreateListener.class,
                           listener);
    }

    /**
     * Adds a {@code RoleCreateListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleCreateListener(Supplier<RoleCreateListener> listenerSupplier) {
        return addListener(RoleCreateListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code RoleCreateListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleCreateListener(Function<DiscordApi, RoleCreateListener> listenerFunction) {
        return addListener(RoleCreateListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code RoleChangeHoistListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangeHoistListener(RoleChangeHoistListener listener) {
        return addListener(RoleChangeHoistListener.class,
                           listener);
    }

    /**
     * Adds a {@code RoleChangeHoistListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangeHoistListener(Supplier<RoleChangeHoistListener> listenerSupplier) {
        return addListener(RoleChangeHoistListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code RoleChangeHoistListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addRoleChangeHoistListener(Function<DiscordApi, RoleChangeHoistListener> listenerFunction) {
        return addListener(RoleChangeHoistListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangePreferredLocaleListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangePreferredLocaleListener(ServerChangePreferredLocaleListener listener) {
        return addListener(ServerChangePreferredLocaleListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangePreferredLocaleListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangePreferredLocaleListener(Supplier<ServerChangePreferredLocaleListener> listenerSupplier) {
        return addListener(ServerChangePreferredLocaleListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangePreferredLocaleListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangePreferredLocaleListener(Function<DiscordApi, ServerChangePreferredLocaleListener> listenerFunction) {
        return addListener(ServerChangePreferredLocaleListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeIconListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeIconListener(ServerChangeIconListener listener) {
        return addListener(ServerChangeIconListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeIconListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeIconListener(Supplier<ServerChangeIconListener> listenerSupplier) {
        return addListener(ServerChangeIconListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeIconListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeIconListener(Function<DiscordApi, ServerChangeIconListener> listenerFunction) {
        return addListener(ServerChangeIconListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code KnownCustomEmojiChangeNameListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addKnownCustomEmojiChangeNameListener(KnownCustomEmojiChangeNameListener listener) {
        return addListener(KnownCustomEmojiChangeNameListener.class,
                           listener);
    }

    /**
     * Adds a {@code KnownCustomEmojiChangeNameListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addKnownCustomEmojiChangeNameListener(Supplier<KnownCustomEmojiChangeNameListener> listenerSupplier) {
        return addListener(KnownCustomEmojiChangeNameListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code KnownCustomEmojiChangeNameListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addKnownCustomEmojiChangeNameListener(Function<DiscordApi, KnownCustomEmojiChangeNameListener> listenerFunction) {
        return addListener(KnownCustomEmojiChangeNameListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code KnownCustomEmojiCreateListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addKnownCustomEmojiCreateListener(KnownCustomEmojiCreateListener listener) {
        return addListener(KnownCustomEmojiCreateListener.class,
                           listener);
    }

    /**
     * Adds a {@code KnownCustomEmojiCreateListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addKnownCustomEmojiCreateListener(Supplier<KnownCustomEmojiCreateListener> listenerSupplier) {
        return addListener(KnownCustomEmojiCreateListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code KnownCustomEmojiCreateListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addKnownCustomEmojiCreateListener(Function<DiscordApi, KnownCustomEmojiCreateListener> listenerFunction) {
        return addListener(KnownCustomEmojiCreateListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code KnownCustomEmojiDeleteListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addKnownCustomEmojiDeleteListener(KnownCustomEmojiDeleteListener listener) {
        return addListener(KnownCustomEmojiDeleteListener.class,
                           listener);
    }

    /**
     * Adds a {@code KnownCustomEmojiDeleteListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addKnownCustomEmojiDeleteListener(Supplier<KnownCustomEmojiDeleteListener> listenerSupplier) {
        return addListener(KnownCustomEmojiDeleteListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code KnownCustomEmojiDeleteListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addKnownCustomEmojiDeleteListener(Function<DiscordApi, KnownCustomEmojiDeleteListener> listenerFunction) {
        return addListener(KnownCustomEmojiDeleteListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code KnownCustomEmojiChangeWhitelistedRolesListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addKnownCustomEmojiChangeWhitelistedRolesListener(KnownCustomEmojiChangeWhitelistedRolesListener listener) {
        return addListener(KnownCustomEmojiChangeWhitelistedRolesListener.class,
                           listener);
    }

    /**
     * Adds a {@code KnownCustomEmojiChangeWhitelistedRolesListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addKnownCustomEmojiChangeWhitelistedRolesListener(Supplier<KnownCustomEmojiChangeWhitelistedRolesListener> listenerSupplier) {
        return addListener(KnownCustomEmojiChangeWhitelistedRolesListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code KnownCustomEmojiChangeWhitelistedRolesListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addKnownCustomEmojiChangeWhitelistedRolesListener(Function<DiscordApi, KnownCustomEmojiChangeWhitelistedRolesListener> listenerFunction) {
        return addListener(KnownCustomEmojiChangeWhitelistedRolesListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerJoinListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerJoinListener(ServerJoinListener listener) {
        return addListener(ServerJoinListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerJoinListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerJoinListener(Supplier<ServerJoinListener> listenerSupplier) {
        return addListener(ServerJoinListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerJoinListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerJoinListener(Function<DiscordApi, ServerJoinListener> listenerFunction) {
        return addListener(ServerJoinListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeBoostLevelListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeBoostLevelListener(ServerChangeBoostLevelListener listener) {
        return addListener(ServerChangeBoostLevelListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeBoostLevelListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeBoostLevelListener(Supplier<ServerChangeBoostLevelListener> listenerSupplier) {
        return addListener(ServerChangeBoostLevelListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeBoostLevelListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeBoostLevelListener(Function<DiscordApi, ServerChangeBoostLevelListener> listenerFunction) {
        return addListener(ServerChangeBoostLevelListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeNameListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeNameListener(ServerChangeNameListener listener) {
        return addListener(ServerChangeNameListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeNameListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeNameListener(Supplier<ServerChangeNameListener> listenerSupplier) {
        return addListener(ServerChangeNameListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeNameListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeNameListener(Function<DiscordApi, ServerChangeNameListener> listenerFunction) {
        return addListener(ServerChangeNameListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerMemberLeaveListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerMemberLeaveListener(ServerMemberLeaveListener listener) {
        return addListener(ServerMemberLeaveListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerMemberLeaveListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerMemberLeaveListener(Supplier<ServerMemberLeaveListener> listenerSupplier) {
        return addListener(ServerMemberLeaveListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerMemberLeaveListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerMemberLeaveListener(Function<DiscordApi, ServerMemberLeaveListener> listenerFunction) {
        return addListener(ServerMemberLeaveListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerMemberBanListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerMemberBanListener(ServerMemberBanListener listener) {
        return addListener(ServerMemberBanListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerMemberBanListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerMemberBanListener(Supplier<ServerMemberBanListener> listenerSupplier) {
        return addListener(ServerMemberBanListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerMemberBanListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerMemberBanListener(Function<DiscordApi, ServerMemberBanListener> listenerFunction) {
        return addListener(ServerMemberBanListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerMemberUnbanListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerMemberUnbanListener(ServerMemberUnbanListener listener) {
        return addListener(ServerMemberUnbanListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerMemberUnbanListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerMemberUnbanListener(Supplier<ServerMemberUnbanListener> listenerSupplier) {
        return addListener(ServerMemberUnbanListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerMemberUnbanListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerMemberUnbanListener(Function<DiscordApi, ServerMemberUnbanListener> listenerFunction) {
        return addListener(ServerMemberUnbanListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerMemberJoinListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerMemberJoinListener(ServerMemberJoinListener listener) {
        return addListener(ServerMemberJoinListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerMemberJoinListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerMemberJoinListener(Supplier<ServerMemberJoinListener> listenerSupplier) {
        return addListener(ServerMemberJoinListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerMemberJoinListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerMemberJoinListener(Function<DiscordApi, ServerMemberJoinListener> listenerFunction) {
        return addListener(ServerMemberJoinListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeModeratorsOnlyChannelListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeModeratorsOnlyChannelListener(ServerChangeModeratorsOnlyChannelListener listener) {
        return addListener(ServerChangeModeratorsOnlyChannelListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeModeratorsOnlyChannelListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeModeratorsOnlyChannelListener(Supplier<ServerChangeModeratorsOnlyChannelListener> listenerSupplier) {
        return addListener(ServerChangeModeratorsOnlyChannelListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeModeratorsOnlyChannelListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeModeratorsOnlyChannelListener(Function<DiscordApi, ServerChangeModeratorsOnlyChannelListener> listenerFunction) {
        return addListener(ServerChangeModeratorsOnlyChannelListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeAfkTimeoutListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeAfkTimeoutListener(ServerChangeAfkTimeoutListener listener) {
        return addListener(ServerChangeAfkTimeoutListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeAfkTimeoutListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeAfkTimeoutListener(Supplier<ServerChangeAfkTimeoutListener> listenerSupplier) {
        return addListener(ServerChangeAfkTimeoutListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeAfkTimeoutListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeAfkTimeoutListener(Function<DiscordApi, ServerChangeAfkTimeoutListener> listenerFunction) {
        return addListener(ServerChangeAfkTimeoutListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeServerFeatureListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeServerFeatureListener(ServerChangeServerFeatureListener listener) {
        return addListener(ServerChangeServerFeatureListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeServerFeatureListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeServerFeatureListener(Supplier<ServerChangeServerFeatureListener> listenerSupplier) {
        return addListener(ServerChangeServerFeatureListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeServerFeatureListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeServerFeatureListener(Function<DiscordApi, ServerChangeServerFeatureListener> listenerFunction) {
        return addListener(ServerChangeServerFeatureListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeExplicitContentFilterLevelListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeExplicitContentFilterLevelListener(ServerChangeExplicitContentFilterLevelListener listener) {
        return addListener(ServerChangeExplicitContentFilterLevelListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeExplicitContentFilterLevelListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeExplicitContentFilterLevelListener(Supplier<ServerChangeExplicitContentFilterLevelListener> listenerSupplier) {
        return addListener(ServerChangeExplicitContentFilterLevelListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeExplicitContentFilterLevelListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeExplicitContentFilterLevelListener(Function<DiscordApi, ServerChangeExplicitContentFilterLevelListener> listenerFunction) {
        return addListener(ServerChangeExplicitContentFilterLevelListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeSplashListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeSplashListener(ServerChangeSplashListener listener) {
        return addListener(ServerChangeSplashListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeSplashListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeSplashListener(Supplier<ServerChangeSplashListener> listenerSupplier) {
        return addListener(ServerChangeSplashListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeSplashListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeSplashListener(Function<DiscordApi, ServerChangeSplashListener> listenerFunction) {
        return addListener(ServerChangeSplashListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeMultiFactorAuthenticationLevelListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeMultiFactorAuthenticationLevelListener(ServerChangeMultiFactorAuthenticationLevelListener listener) {
        return addListener(ServerChangeMultiFactorAuthenticationLevelListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeMultiFactorAuthenticationLevelListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeMultiFactorAuthenticationLevelListener(Supplier<ServerChangeMultiFactorAuthenticationLevelListener> listenerSupplier) {
        return addListener(ServerChangeMultiFactorAuthenticationLevelListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeMultiFactorAuthenticationLevelListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeMultiFactorAuthenticationLevelListener(Function<DiscordApi, ServerChangeMultiFactorAuthenticationLevelListener> listenerFunction) {
        return addListener(ServerChangeMultiFactorAuthenticationLevelListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeVanityUrlCodeListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeVanityUrlCodeListener(ServerChangeVanityUrlCodeListener listener) {
        return addListener(ServerChangeVanityUrlCodeListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeVanityUrlCodeListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeVanityUrlCodeListener(Supplier<ServerChangeVanityUrlCodeListener> listenerSupplier) {
        return addListener(ServerChangeVanityUrlCodeListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeVanityUrlCodeListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeVanityUrlCodeListener(Function<DiscordApi, ServerChangeVanityUrlCodeListener> listenerFunction) {
        return addListener(ServerChangeVanityUrlCodeListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeAfkChannelListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeAfkChannelListener(ServerChangeAfkChannelListener listener) {
        return addListener(ServerChangeAfkChannelListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeAfkChannelListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeAfkChannelListener(Supplier<ServerChangeAfkChannelListener> listenerSupplier) {
        return addListener(ServerChangeAfkChannelListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeAfkChannelListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeAfkChannelListener(Function<DiscordApi, ServerChangeAfkChannelListener> listenerFunction) {
        return addListener(ServerChangeAfkChannelListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeDiscoverySplashListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeDiscoverySplashListener(ServerChangeDiscoverySplashListener listener) {
        return addListener(ServerChangeDiscoverySplashListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeDiscoverySplashListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeDiscoverySplashListener(Supplier<ServerChangeDiscoverySplashListener> listenerSupplier) {
        return addListener(ServerChangeDiscoverySplashListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeDiscoverySplashListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeDiscoverySplashListener(Function<DiscordApi, ServerChangeDiscoverySplashListener> listenerFunction) {
        return addListener(ServerChangeDiscoverySplashListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeRulesChannelListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeRulesChannelListener(ServerChangeRulesChannelListener listener) {
        return addListener(ServerChangeRulesChannelListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeRulesChannelListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeRulesChannelListener(Supplier<ServerChangeRulesChannelListener> listenerSupplier) {
        return addListener(ServerChangeRulesChannelListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeRulesChannelListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeRulesChannelListener(Function<DiscordApi, ServerChangeRulesChannelListener> listenerFunction) {
        return addListener(ServerChangeRulesChannelListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerBecomesUnavailableListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerBecomesUnavailableListener(ServerBecomesUnavailableListener listener) {
        return addListener(ServerBecomesUnavailableListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerBecomesUnavailableListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerBecomesUnavailableListener(Supplier<ServerBecomesUnavailableListener> listenerSupplier) {
        return addListener(ServerBecomesUnavailableListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerBecomesUnavailableListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerBecomesUnavailableListener(Function<DiscordApi, ServerBecomesUnavailableListener> listenerFunction) {
        return addListener(ServerBecomesUnavailableListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerChangeOwnerListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeOwnerListener(ServerChangeOwnerListener listener) {
        return addListener(ServerChangeOwnerListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerChangeOwnerListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeOwnerListener(Supplier<ServerChangeOwnerListener> listenerSupplier) {
        return addListener(ServerChangeOwnerListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerChangeOwnerListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerChangeOwnerListener(Function<DiscordApi, ServerChangeOwnerListener> listenerFunction) {
        return addListener(ServerChangeOwnerListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerBecomesAvailableListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerBecomesAvailableListener(ServerBecomesAvailableListener listener) {
        return addListener(ServerBecomesAvailableListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerBecomesAvailableListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerBecomesAvailableListener(Supplier<ServerBecomesAvailableListener> listenerSupplier) {
        return addListener(ServerBecomesAvailableListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerBecomesAvailableListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerBecomesAvailableListener(Function<DiscordApi, ServerBecomesAvailableListener> listenerFunction) {
        return addListener(ServerBecomesAvailableListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code ServerLeaveListener} to all created {@code DiscordApi} instances.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerLeaveListener(ServerLeaveListener listener) {
        return addListener(ServerLeaveListener.class,
                           listener);
    }

    /**
     * Adds a {@code ServerLeaveListener} to all created {@code DiscordApi} instances. The supplier is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerLeaveListener(Supplier<ServerLeaveListener> listenerSupplier) {
        return addListener(ServerLeaveListener.class,
                           listenerSupplier);
    }

    /**
     * Adds a {@code ServerLeaveListener} to all created {@code DiscordApi} instances. The function is called
     * for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    default DiscordApiBuilder addServerLeaveListener(Function<DiscordApi, ServerLeaveListener> listenerFunction) {
        return addListener(ServerLeaveListener.class,
                           listenerFunction);
    }

    /**
     * Adds a {@code GloballyAttachableListener} to all created {@code DiscordApi} instances.
     * Adding a listener multiple times will only add it once.
     * The order of invocation is according to first addition.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The current instance in order to chain call methods.
     */
    <T extends GloballyAttachableListener> DiscordApiBuilder addListener(Class<T> listenerClass, T listener);

    /**
     * Adds a listener that implements one or more {@code GloballyAttachableListener}s to all created
     * {@code DiscordApi} instances.
     * Adding a listener multiple times will only add it once.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @return The current instance in order to chain call methods.
     */
    DiscordApiBuilder addListener(GloballyAttachableListener listener);

    /**
     * Adds a {@code GloballyAttachableListener} to all created {@code DiscordApi} instances. The supplier is
     * called for every created {@code DiscordApi} instance, so either the same or different instances can be
     * registered. One example would be a method reference to a default constructor like
     * {@code MyListener::new}.
     * Adding a listener multiple times will only add it once.
     * The order of invocation is according to first addition.
     *
     * @param listenerClass The listener class.
     * @param listenerSupplier The supplier of listeners to add.
     * @param <T> The type of the listener.
     * @return The current instance in order to chain call methods.
     */
    <T extends GloballyAttachableListener> DiscordApiBuilder addListener(Class<T> listenerClass, Supplier<T> listenerSupplier);

    /**
     * Adds a listener that implements one or more {@code GloballyAttachableListener}s to all created
     * {@code DiscordApi} instances. The supplier is called for every created {@code DiscordApi} instance,
     * so either the same or different instances can be registered. One example would be a method reference
     * to a default constructor like {@code MyListener::new}.
     * Adding a listener multiple times will only add it once.
     * The order of invocation is according to first addition.
     *
     * @param listenerSupplier The supplier of listeners to add.
     * @return The current instance in order to chain call methods.
     */
    DiscordApiBuilder addListener(Supplier<GloballyAttachableListener> listenerSupplier);

    /**
     * Adds a {@code GloballyAttachableListener} to all created {@code DiscordApi} instances. The function
     * is called for every created {@code DiscordApi} instance, so either the same or different instances
     * can be registered. One example would be a method reference to a constructor with a {@code DiscordApi}
     * parameter like {@code MyListener::new}.
     * Adding a listener multiple times will only add it once.
     * The order of invocation is according to first addition.
     *
     * @param listenerClass The listener class.
     * @param listenerFunction The function to provide listeners to add.
     * @param <T> The type of the listener.
     * @return The current instance in order to chain call methods.
     */
    <T extends GloballyAttachableListener> DiscordApiBuilder addListener(Class<T> listenerClass, Function<DiscordApi, T> listenerFunction);

    /**
     * Adds a listener that implements one or more {@code GloballyAttachableListener}s to all created
     * {@code DiscordApi} instances. The function is called for every created {@code DiscordApi} instance,
     * so either the same or different instances can be registered. One example would be a method reference
     * to a constructor with a {@code DiscordApi} parameter like {@code MyListener::new}.
     * Adding a listener multiple times will only add it once.
     * The order of invocation is according to first addition.
     *
     * @param listenerFunction The function to provide listeners to add.
     * @return The current instance in order to chain call methods.
     */
    DiscordApiBuilder addListener(Function<DiscordApi, GloballyAttachableListener> listenerFunction);

    /**
     * Removes a listener that implements one or more {@code GloballyAttachableListener}s from the list of
     * listeners to be added to {@code DiscordApi} instances. If the listener was already added to a
     * {@code DiscordApi} instance, it will not get removed by calling this method.
     * This method should normally only be used before calling one of the login methods.
     *
     * @param listener The listener to remove.
     * @return The current instance in order to chain call methods.
     */
    DiscordApiBuilder removeListener(GloballyAttachableListener listener);

    /**
     * Removes a {@code GloballyAttachableListener} from the list of listeners to be added to
     * {@code DiscordApi} instances. If the listener was already added to a {@code DiscordApi} instance,
     * it will not get removed by calling this method.
     * This method should normally only be used before calling one of the login methods.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     * @return The current instance in order to chain call methods.
     */
    <T extends GloballyAttachableListener> DiscordApiBuilder removeListener(Class<T> listenerClass, T listener);

    /**
     * Removes a supplier of listeners that implements one or more {@code GloballyAttachableListener}s
     * from the list of listeners to be added to {@code DiscordApi} instances. If the listener was already
     * added to a {@code DiscordApi} instance, it will not get removed by calling this method.
     * This method should normally only be used before calling one of the login methods.
     *
     * @param listenerSupplier The supplier of listeners to remove.
     * @return The current instance in order to chain call methods.
     */
    DiscordApiBuilder removeListenerSupplier(Supplier<GloballyAttachableListener> listenerSupplier);

    /**
     * Removes a supplier of {@code GloballyAttachableListener}s from the list of listeners to be added to
     * {@code DiscordApi} instances. If the listener was already added to a {@code DiscordApi} instance,
     * it will not get removed by calling this method.
     * This method should normally only be used before calling one of the login methods.
     *
     * @param listenerClass The listener class.
     * @param listenerSupplier The supplier of listeners to remove.
     * @param <T> The type of the listener.
     * @return The current instance in order to chain call methods.
     */
    <T extends GloballyAttachableListener> DiscordApiBuilder removeListenerSupplier(Class<T> listenerClass, Supplier<T> listenerSupplier);

    /**
     * Removes a function that provides listeners that implements one or more
     * {@code GloballyAttachableListener}s from the list of listeners to be added to {@code DiscordApi}
     * instances. If the listener was already added to a {@code DiscordApi} instance, it will not get
     * removed by calling this method.
     * This method should normally only be used before calling one of the login methods.
     *
     * @param listenerFunction The function to provide listeners to remove.
     * @return The current instance in order to chain call methods.
     */
    DiscordApiBuilder removeListenerFunction(Function<DiscordApi, GloballyAttachableListener> listenerFunction);

    /**
     * Removes a function that provides {@code GloballyAttachableListener}s from the list of listeners to be
     * added to {@code DiscordApi} instances. If the listener was already added to a {@code DiscordApi}
     * instance, it will not get removed by calling this method.
     * This method should normally only be used before calling one of the login methods.
     *
     * @param listenerClass The listener class.
     * @param listenerFunction The function to provide listeners to remove.
     * @param <T> The type of the listener.
     * @return The current instance in order to chain call methods.
     */
    <T extends GloballyAttachableListener> DiscordApiBuilder removeListenerFunction(Class<T> listenerClass, Function<DiscordApi, T> listenerFunction);
}
