/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.channel;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.channel.Categorizable;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.ChannelType;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.ServerVoiceChannelUpdater;
import org.javacord.api.entity.channel.VoiceChannel;
import org.javacord.api.entity.user.User;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelAttachableListenerManager;

public interface ServerVoiceChannel
extends ServerChannel,
VoiceChannel,
Categorizable,
ServerVoiceChannelAttachableListenerManager {
    @Override
    default public ChannelType getType() {
        return ChannelType.SERVER_VOICE_CHANNEL;
    }

    public int getBitrate();

    public Optional<Integer> getUserLimit();

    public Collection<Long> getConnectedUserIds();

    public Collection<User> getConnectedUsers();

    public boolean isConnected(long var1);

    default public boolean isConnected(User user) {
        return this.isConnected(user.getId());
    }

    @Override
    default public ServerVoiceChannelUpdater createUpdater() {
        return new ServerVoiceChannelUpdater(this);
    }

    default public CompletableFuture<Void> updateBitrate(int bitrate) {
        return this.createUpdater().setBitrate(bitrate).update();
    }

    default public CompletableFuture<Void> updateUserLimit(int userLimit) {
        return this.createUpdater().setUserLimit(userLimit).update();
    }

    default public CompletableFuture<Void> removeUserLimit() {
        return this.createUpdater().removeUserLimit().update();
    }

    @Override
    default public CompletableFuture<Void> updateCategory(ChannelCategory category) {
        return this.createUpdater().setCategory(category).update();
    }

    @Override
    default public CompletableFuture<Void> removeCategory() {
        return this.createUpdater().removeCategory().update();
    }

    default public Optional<ServerVoiceChannel> getCurrentCachedInstance() {
        return this.getApi().getServerById(this.getServer().getId()).flatMap(server -> server.getVoiceChannelById(this.getId()));
    }

    @Override
    default public CompletableFuture<ServerVoiceChannel> getLatestInstance() {
        Optional<ServerVoiceChannel> currentCachedInstance = this.getCurrentCachedInstance();
        if (currentCachedInstance.isPresent()) {
            return CompletableFuture.completedFuture(currentCachedInstance.get());
        }
        CompletableFuture<ServerVoiceChannel> result = new CompletableFuture<ServerVoiceChannel>();
        result.completeExceptionally(new NoSuchElementException());
        return result;
    }
}

