/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.channel;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.Mentionable;
import org.javacord.api.entity.channel.Categorizable;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.ChannelType;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.ServerTextChannelUpdater;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.webhook.WebhookBuilder;
import org.javacord.api.listener.channel.server.text.ServerTextChannelAttachableListenerManager;

public interface ServerTextChannel
extends ServerChannel,
TextChannel,
Mentionable,
Categorizable,
ServerTextChannelAttachableListenerManager {
    @Override
    default public ChannelType getType() {
        return ChannelType.SERVER_TEXT_CHANNEL;
    }

    public boolean isNsfw();

    public String getTopic();

    default public WebhookBuilder createWebhookBuilder() {
        return new WebhookBuilder(this);
    }

    @Override
    default public ServerTextChannelUpdater createUpdater() {
        return new ServerTextChannelUpdater(this);
    }

    default public CompletableFuture<Void> updateTopic(String topic) {
        return this.createUpdater().setTopic(topic).update();
    }

    default public CompletableFuture<Void> updateNsfwFlag(boolean nsfw) {
        return this.createUpdater().setNsfwFlag(nsfw).update();
    }

    @Override
    default public CompletableFuture<Void> updateCategory(ChannelCategory category) {
        return this.createUpdater().setCategory(category).update();
    }

    @Override
    default public CompletableFuture<Void> removeCategory() {
        return this.createUpdater().removeCategory().update();
    }

    public int getSlowmodeDelayInSeconds();

    default public boolean hasSlowmode() {
        return this.getSlowmodeDelayInSeconds() == 0;
    }

    default public CompletableFuture<Void> updateSlowmodeDelayInSeconds(int delay) {
        return this.createUpdater().setSlowmodeDelayInSeconds(delay).update();
    }

    default public CompletableFuture<Void> unsetSlowmode() {
        return this.createUpdater().unsetSlowmode().update();
    }

    default public Optional<ServerTextChannel> getCurrentCachedInstance() {
        return this.getApi().getServerById(this.getServer().getId()).flatMap(server -> server.getTextChannelById(this.getId()));
    }

    @Override
    default public CompletableFuture<ServerTextChannel> getLatestInstance() {
        Optional<ServerTextChannel> currentCachedInstance = this.getCurrentCachedInstance();
        if (currentCachedInstance.isPresent()) {
            return CompletableFuture.completedFuture(currentCachedInstance.get());
        }
        CompletableFuture<ServerTextChannel> result = new CompletableFuture<ServerTextChannel>();
        result.completeExceptionally(new NoSuchElementException());
        return result;
    }
}

